/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.utils;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.EMFCompareMessages;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.utils.IEqualityHelper;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DiffUtil {
    private DiffUtil() {
    }

    public static double diceCoefficient(String first, String second) {
        double coefficient;
        char[] str2;
        char[] str1 = first.toCharArray();
        if (Arrays.equals(str1, str2 = second.toCharArray())) {
            coefficient = 1.0;
        } else if (str1.length <= 2 || str2.length <= 2) {
            int equalChars = 0;
            int i = 0;
            while (i < Math.min(str1.length, str2.length)) {
                if (str1[i] == str2[i]) {
                    ++equalChars;
                }
                ++i;
            }
            int union = str1.length + str2.length;
            coefficient = str1.length != str2.length ? (double)equalChars / (double)union : (double)equalChars * 2.0 / (double)union;
        } else {
            char[] chars;
            HashSet s1Bigrams = Sets.newHashSet();
            HashSet s2Bigrams = Sets.newHashSet();
            int i = 0;
            while (i < str1.length - 1) {
                chars = new char[]{str1[i], str1[i + 1]};
                s1Bigrams.add(String.valueOf(chars));
                ++i;
            }
            i = 0;
            while (i < str2.length - 1) {
                chars = new char[]{str2[i], str2[i + 1]};
                s2Bigrams.add(String.valueOf(chars));
                ++i;
            }
            Sets.SetView intersection = Sets.intersection((Set)s1Bigrams, (Set)s2Bigrams);
            coefficient = 2.0 * (double)intersection.size() / (double)(s1Bigrams.size() + s2Bigrams.size());
        }
        return coefficient;
    }

    public static <E> List<E> longestCommonSubsequence(Comparison comparison, Iterable<E> ignoredElements, List<E> sequence1, List<E> sequence2) {
        ArrayList copy1 = Lists.newArrayList(sequence1);
        ArrayList copy2 = Lists.newArrayList(sequence2);
        List<E> prefix = DiffUtil.trimPrefix(comparison, ignoredElements, copy1, copy2);
        List<E> suffix = DiffUtil.trimSuffix(comparison, ignoredElements, copy1, copy2);
        List<E> subLCS = copy1.size() > Short.MAX_VALUE || copy2.size() > Short.MAX_VALUE ? DiffUtil.intLongestCommonSubsequence(comparison, ignoredElements, copy1, copy2) : DiffUtil.shortLongestCommonSubsequence(comparison, ignoredElements, copy1, copy2);
        return ImmutableList.copyOf((Iterable)Iterables.concat(prefix, subLCS, suffix));
    }

    public static <E> List<E> longestCommonSubsequence(Comparison comparison, List<E> sequence1, List<E> sequence2) {
        return DiffUtil.longestCommonSubsequence(comparison, Collections.emptyList(), sequence1, sequence2);
    }

    private static <E> List<E> trimPrefix(Comparison comparison, Iterable<E> ignoredElements, List<E> sequence1, List<E> sequence2) {
        IEqualityHelper equalityHelper = comparison.getEqualityHelper();
        int size1 = sequence1.size();
        int size2 = sequence2.size();
        ArrayList prefix = Lists.newArrayList();
        int start1 = 1;
        int start2 = 1;
        boolean matching = true;
        while (start1 <= size1 && start2 <= size2 && matching) {
            E second;
            E first = sequence1.get(start1 - 1);
            if (equalityHelper.matchingValues(first, second = sequence2.get(start2 - 1))) {
                prefix.add(first);
                ++start1;
                ++start2;
                continue;
            }
            boolean ignore1 = DiffUtil.contains(comparison, equalityHelper, ignoredElements, first);
            boolean ignore2 = DiffUtil.contains(comparison, equalityHelper, ignoredElements, second);
            if (ignore1) {
                ++start1;
            }
            if (ignore2) {
                ++start2;
            }
            if (ignore1 || ignore2) continue;
            matching = false;
        }
        int i = 1;
        while (i < start1) {
            sequence1.remove(0);
            ++i;
        }
        i = 1;
        while (i < start2) {
            sequence2.remove(0);
            ++i;
        }
        return prefix;
    }

    private static <E> List<E> trimSuffix(Comparison comparison, Iterable<E> ignoredElements, List<E> sequence1, List<E> sequence2) {
        IEqualityHelper equalityHelper = comparison.getEqualityHelper();
        int size1 = sequence1.size();
        int size2 = sequence2.size();
        ArrayList suffix = Lists.newArrayList();
        int end1 = size1;
        int end2 = size2;
        boolean matching = true;
        while (end1 > 0 && end2 > 0 && matching) {
            E second;
            E first = sequence1.get(end1 - 1);
            if (equalityHelper.matchingValues(first, second = sequence2.get(end2 - 1))) {
                suffix.add(first);
                --end1;
                --end2;
                continue;
            }
            boolean ignore1 = DiffUtil.contains(comparison, equalityHelper, ignoredElements, first);
            boolean ignore2 = DiffUtil.contains(comparison, equalityHelper, ignoredElements, second);
            if (ignore1) {
                --end1;
            }
            if (ignore2) {
                --end2;
            }
            if (ignore1 || ignore2) continue;
            matching = false;
        }
        int i = size1;
        while (i > end1) {
            sequence1.remove(sequence1.size() - 1);
            --i;
        }
        i = size2;
        while (i > end2) {
            sequence2.remove(sequence2.size() - 1);
            --i;
        }
        return Lists.reverse((List)suffix);
    }

    private static <E> boolean contains(Comparison comparison, IEqualityHelper equalityHelper, Iterable<E> sequence, E element) {
        for (E candidate : sequence) {
            if (!equalityHelper.matchingValues(candidate, element)) continue;
            return true;
        }
        return false;
    }

    private static <E> List<E> shortLongestCommonSubsequence(Comparison comparison, Iterable<E> ignoredElements, List<E> sequence1, List<E> sequence2) {
        IEqualityHelper equalityHelper = comparison.getEqualityHelper();
        int size1 = sequence1.size();
        int size2 = sequence2.size();
        short[][] matrix = new short[size1 + 1][size2 + 1];
        int i = 1;
        while (i <= size1) {
            E first = sequence1.get(i - 1);
            int j = 1;
            while (j <= size2) {
                E second = sequence2.get(j - 1);
                matrix[i][j] = equalityHelper.matchingValues(first, second) && !DiffUtil.contains(comparison, equalityHelper, ignoredElements, second) ? (short)(1 + matrix[i - 1][j - 1]) : (short)Math.max(matrix[i - 1][j], matrix[i][j - 1]);
                ++j;
            }
            ++i;
        }
        int current1 = size1;
        int current2 = size2;
        ArrayList result = Lists.newArrayList();
        while (current1 > 0 && current2 > 0) {
            short currentLength = matrix[current1][current2];
            short nextLeft = matrix[current1][current2 - 1];
            short nextUp = matrix[current1 - 1][current2];
            if (currentLength > nextLeft && currentLength > nextUp) {
                result.add(sequence1.get(current1 - 1));
                --current1;
                --current2;
                continue;
            }
            if (nextLeft >= nextUp) {
                --current2;
                continue;
            }
            --current1;
        }
        return Lists.reverse((List)result);
    }

    private static <E> List<E> intLongestCommonSubsequence(Comparison comparison, Iterable<E> ignoredElements, List<E> sequence1, List<E> sequence2) {
        IEqualityHelper equalityHelper = comparison.getEqualityHelper();
        int size1 = sequence1.size();
        int size2 = sequence2.size();
        int[][] matrix = new int[size1 + 1][size2 + 1];
        int i = 1;
        while (i <= size1) {
            E first = sequence1.get(i - 1);
            int j = 1;
            while (j <= size2) {
                E second = sequence2.get(j - 1);
                matrix[i][j] = equalityHelper.matchingValues(first, second) && !DiffUtil.contains(comparison, equalityHelper, ignoredElements, second) ? 1 + matrix[i - 1][j - 1] : Math.max(matrix[i - 1][j], matrix[i][j - 1]);
                ++j;
            }
            ++i;
        }
        int current1 = size1;
        int current2 = size2;
        ArrayList result = Lists.newArrayList();
        while (current1 > 0 && current2 > 0) {
            int currentLength = matrix[current1][current2];
            int nextLeft = matrix[current1][current2 - 1];
            int nextUp = matrix[current1 - 1][current2];
            if (currentLength > nextLeft && currentLength > nextUp) {
                result.add(sequence1.get(current1 - 1));
                --current1;
                --current2;
                continue;
            }
            if (nextLeft >= nextUp) {
                --current2;
                continue;
            }
            --current1;
        }
        return Lists.reverse((List)result);
    }

    public static <E> int findInsertionIndex(Comparison comparison, Iterable<E> ignoredElements, List<E> source, List<E> target, E newElement) {
        IEqualityHelper equalityHelper = comparison.getEqualityHelper();
        List<E> lcs = ignoredElements != null ? DiffUtil.longestCommonSubsequence(comparison, ignoredElements, source, target) : DiffUtil.longestCommonSubsequence(comparison, source, target);
        E firstLCS = null;
        E lastLCS = null;
        if (lcs.size() > 0) {
            firstLCS = lcs.get(0);
            lastLCS = lcs.listIterator(lcs.size()).previous();
        }
        int currentIndex = -1;
        int firstLCSIndex = -1;
        int lastLCSIndex = -1;
        if (firstLCS == null) {
            firstLCSIndex = -2;
            lastLCSIndex = -2;
        }
        ListIterator<E> sourceIterator = source.listIterator();
        int i = 0;
        while (sourceIterator.hasNext() && (currentIndex == -1 || firstLCSIndex == -1)) {
            E sourceElement = sourceIterator.next();
            if (currentIndex == -1 && equalityHelper.matchingValues(sourceElement, newElement)) {
                currentIndex = i;
            }
            if (firstLCSIndex == -1 && equalityHelper.matchingValues(sourceElement, firstLCS)) {
                firstLCSIndex = i;
            }
            ++i;
        }
        int sourceSize = source.size();
        sourceIterator = source.listIterator(sourceSize);
        int i2 = sourceSize - 1;
        while (sourceIterator.hasPrevious() && lastLCSIndex == -1) {
            E sourceElement = sourceIterator.previous();
            if (lastLCSIndex == -1 && equalityHelper.matchingValues(sourceElement, lastLCS)) {
                lastLCSIndex = i2;
            }
            --i2;
        }
        int insertionIndex = -1;
        insertionIndex = firstLCSIndex == -2 ? target.size() : (currentIndex < firstLCSIndex ? DiffUtil.insertBeforeLCS(target, equalityHelper, firstLCS) : (currentIndex > lastLCSIndex ? DiffUtil.findInsertionIndexAfterLCS(target, equalityHelper, lastLCS) : DiffUtil.findInsertionIndexWithinLCS(source, target, equalityHelper, lcs, currentIndex)));
        if (insertionIndex == -1) {
            insertionIndex = target.size();
        }
        return insertionIndex;
    }

    private static <E> int findInsertionIndexWithinLCS(List<E> source, List<E> target, IEqualityHelper equalityHelper, List<E> lcs, int currentIndex) {
        int insertionIndex = -1;
        int lcsIndexOfSubsequenceStart = -1;
        int i = 0;
        while (i < currentIndex) {
            E sourceElement = source.get(i);
            boolean isInLCS = false;
            int j = lcsIndexOfSubsequenceStart + 1;
            while (j < lcs.size() && !isInLCS) {
                E lcsElement = lcs.get(j);
                if (equalityHelper.matchingValues(sourceElement, lcsElement)) {
                    isInLCS = true;
                    ++lcsIndexOfSubsequenceStart;
                }
                ++j;
            }
            ++i;
        }
        HashMultiset dupesLCS = HashMultiset.create(lcs.subList(0, lcsIndexOfSubsequenceStart + 1));
        E subsequenceStart = lcs.get(lcsIndexOfSubsequenceStart);
        int duplicatesToGo = dupesLCS.count(subsequenceStart) - 1;
        int i2 = 0;
        while (i2 < target.size() && insertionIndex == -1) {
            E targetElement = target.get(i2);
            if (equalityHelper.matchingValues(targetElement, subsequenceStart)) {
                if (duplicatesToGo > 0) {
                    --duplicatesToGo;
                } else {
                    insertionIndex = i2 + 1;
                }
            }
            ++i2;
        }
        return insertionIndex;
    }

    private static <E> int findInsertionIndexAfterLCS(List<E> target, IEqualityHelper equalityHelper, E lastLCS) {
        int insertionIndex = -1;
        int i = target.size() - 1;
        while (i >= 0 && insertionIndex == -1) {
            E targetElement = target.get(i);
            if (equalityHelper.matchingValues(targetElement, lastLCS)) {
                insertionIndex = i + 1;
            }
            --i;
        }
        return insertionIndex;
    }

    private static <E> int insertBeforeLCS(List<E> target, IEqualityHelper equalityHelper, E firstLCS) {
        int insertionIndex = -1;
        int i = 0;
        while (i < target.size() && insertionIndex == -1) {
            E targetElement = target.get(i);
            if (equalityHelper.matchingValues(targetElement, firstLCS)) {
                insertionIndex = i;
            }
            ++i;
        }
        return insertionIndex;
    }

    public static <E> int findInsertionIndex(Comparison comparison, List<E> source, List<E> target, E newElement) {
        return DiffUtil.findInsertionIndex(comparison, null, source, target, newElement);
    }

    public static int findInsertionIndex(Comparison comparison, Diff diff, boolean rightToLeft) {
        Object targetList;
        EObject expectedContainer;
        Object value;
        EAttribute feature;
        if (diff instanceof AttributeChange) {
            feature = ((AttributeChange)diff).getAttribute();
            value = ((AttributeChange)diff).getValue();
        } else if (diff instanceof ReferenceChange) {
            feature = ((ReferenceChange)diff).getReference();
            value = ((ReferenceChange)diff).getValue();
        } else {
            throw new IllegalArgumentException(EMFCompareMessages.getString("DiffUtil.IllegalDiff", diff.eClass().getName()));
        }
        if (!feature.isMany()) {
            throw new IllegalArgumentException(EMFCompareMessages.getString("DiffUtil.IllegalFeature", feature.getName()));
        }
        Match match = diff.getMatch();
        if (feature instanceof EReference && ((EReference)feature).isContainment() && diff.getKind() == DifferenceKind.MOVE) {
            Match valueMatch = comparison.getMatch((EObject)value);
            Match targetContainerMatch = rightToLeft && valueMatch.getRight() != null ? comparison.getMatch(valueMatch.getRight().eContainer()) : (!rightToLeft && valueMatch.getLeft() != null ? comparison.getMatch(valueMatch.getLeft().eContainer()) : comparison.getMatch(valueMatch.getOrigin().eContainer()));
            expectedContainer = rightToLeft ? targetContainerMatch.getLeft() : targetContainerMatch.getRight();
        } else {
            expectedContainer = rightToLeft ? match.getLeft() : match.getRight();
        }
        List<Object> sourceList = DiffUtil.getSourceList(diff, (EStructuralFeature)feature, rightToLeft);
        if (expectedContainer != null) {
            List temp = (List)ReferenceUtil.safeEGet(expectedContainer, (EStructuralFeature)feature);
            targetList = feature == EcorePackage.Literals.ECLASS__ESUPER_TYPES || feature == EcorePackage.Literals.EOPERATION__EEXCEPTIONS ? temp : (temp instanceof InternalEList ? ((InternalEList)temp).basicList() : temp);
        } else {
            targetList = ImmutableList.of();
        }
        Iterable ignoredElements = Iterables.concat(DiffUtil.computeIgnoredElements(targetList, diff), Collections.singleton(value));
        ignoredElements = Lists.newArrayList((Iterable)ignoredElements);
        return DiffUtil.findInsertionIndex(comparison, ignoredElements, sourceList, targetList, value);
    }

    private static List<Object> getSourceList(Diff diff, EStructuralFeature feature, boolean rightToLeft) {
        Object sourceList;
        EObject expectedContainer;
        Match match = diff.getMatch();
        if (diff.getKind() == DifferenceKind.MOVE) {
            boolean undoingRight;
            boolean undoingLeft = rightToLeft && diff.getSource() == DifferenceSource.LEFT;
            boolean bl = undoingRight = !rightToLeft && diff.getSource() == DifferenceSource.RIGHT;
            expectedContainer = (undoingLeft || undoingRight) && match.getOrigin() != null ? match.getOrigin() : (rightToLeft ? match.getRight() : match.getLeft());
        } else {
            expectedContainer = match.getOrigin() != null && diff.getKind() == DifferenceKind.DELETE ? match.getOrigin() : (rightToLeft ? match.getRight() : match.getLeft());
        }
        if (expectedContainer != null) {
            List temp = (List)ReferenceUtil.safeEGet(expectedContainer, feature);
            sourceList = feature == EcorePackage.Literals.ECLASS__ESUPER_TYPES || feature == EcorePackage.Literals.EOPERATION__EEXCEPTIONS ? temp : (temp instanceof InternalEList ? ((InternalEList)temp).basicList() : temp);
        } else {
            sourceList = ImmutableList.of();
        }
        return sourceList;
    }

    private static <E> Iterable<E> computeIgnoredElements(Iterable<E> candidates, Diff diff) {
        EAttribute feature;
        Match match = diff.getMatch();
        ArrayList filteredCandidates = Lists.newArrayList(match.getDifferences());
        if (diff instanceof AttributeChange) {
            feature = ((AttributeChange)diff).getAttribute();
        } else if (diff instanceof ReferenceChange) {
            feature = ((ReferenceChange)diff).getReference();
        } else {
            return Collections.emptyList();
        }
        LinkedHashSet ignored = Sets.newLinkedHashSet();
        for (E candidate : candidates) {
            if (candidate instanceof EObject) {
                EList<Diff> differences = match.getComparison().getDifferences((EObject)candidate);
                if (!Iterables.any(differences, (Predicate)new UnresolvedDiffMatching((EStructuralFeature)feature, candidate))) continue;
                ignored.add(candidate);
                continue;
            }
            if (!Iterables.any((Iterable)filteredCandidates, (Predicate)new UnresolvedDiffMatching((EStructuralFeature)feature, candidate))) continue;
            ignored.add(candidate);
        }
        return ignored;
    }

    public static Function<Diff, Iterable<Diff>> getSubDiffs(boolean leftToRight) {
        return DiffUtil.getSubDiffs(leftToRight, new LinkedHashSet<Diff>());
    }

    private static Function<Diff, Iterable<Diff>> getSubDiffs(final boolean leftToRight, final LinkedHashSet<Diff> processedDiffs) {
        return new Function<Diff, Iterable<Diff>>(){

            public Iterable<Diff> apply(Diff diff) {
                if (diff instanceof ReferenceChange) {
                    Match matchOfValue = diff.getMatch().getComparison().getMatch(((ReferenceChange)diff).getValue());
                    if (((ReferenceChange)diff).getReference().isContainment()) {
                        Iterable<Diff> subDiffs = matchOfValue.getAllDifferences();
                        Iterables.addAll((Collection)processedDiffs, subDiffs);
                        Iterable associatedDiffs = DiffUtil.getAssociatedDiffs(diff, subDiffs, processedDiffs, leftToRight);
                        return ImmutableSet.copyOf((Iterable)Iterables.concat(subDiffs, (Iterable)associatedDiffs));
                    }
                }
                return ImmutableSet.of();
            }
        };
    }

    private static Iterable<Diff> getAssociatedDiffs(Diff diffRoot, Iterable<Diff> subDiffs, LinkedHashSet<Diff> processedDiffs, boolean leftToRight) {
        HashSet<Diff> associatedDiffs = new HashSet<Diff>();
        for (Diff diff : subDiffs) {
            LinkedHashSet<Diff> reqs = new LinkedHashSet<Diff>();
            if (leftToRight) {
                if (diff.getSource() == DifferenceSource.LEFT) {
                    reqs.addAll((Collection<Diff>)diff.getRequires());
                } else {
                    reqs.addAll((Collection<Diff>)diff.getRequiredBy());
                }
            } else if (diff.getSource() == DifferenceSource.LEFT) {
                reqs.addAll((Collection<Diff>)diff.getRequiredBy());
            } else {
                reqs.addAll((Collection<Diff>)diff.getRequires());
            }
            reqs.remove(diffRoot);
            associatedDiffs.addAll(reqs);
            for (Diff req : reqs) {
                if (Iterables.contains(subDiffs, (Object)req) || processedDiffs.contains(req)) continue;
                processedDiffs.add(req);
                Iterables.addAll(associatedDiffs, (Iterable)((Iterable)DiffUtil.getSubDiffs(leftToRight, processedDiffs).apply((Object)req)));
            }
        }
        return associatedDiffs;
    }

    @Deprecated
    public static Iterable<Diff> getAssociatedDiffs(Diff diffRoot, Iterable<Diff> subDiffs, boolean leftToRight) {
        return Collections.emptyList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnresolvedDiffMatching
    implements Predicate<Diff> {
        private final EStructuralFeature feature;
        private final Object element;

        public UnresolvedDiffMatching(EStructuralFeature feature, Object element) {
            this.feature = feature;
            this.element = element;
        }

        public boolean apply(Diff input) {
            boolean apply = false;
            apply = input instanceof AttributeChange ? input.getState() == DifferenceState.UNRESOLVED && ((AttributeChange)input).getAttribute() == this.feature && this.matchingValues((AttributeChange)input, this.element) : (input instanceof ReferenceChange ? input.getState() == DifferenceState.UNRESOLVED && ((ReferenceChange)input).getReference() == this.feature && this.matchingValues((ReferenceChange)input, this.element) : false);
            return apply;
        }

        private boolean matchingValues(AttributeChange diff, Object value) {
            if (diff.getValue() == value) {
                return true;
            }
            IEqualityHelper helper = diff.getMatch().getComparison().getEqualityHelper();
            return helper.matchingAttributeValues(diff.getValue(), value);
        }

        private boolean matchingValues(ReferenceChange diff, Object value) {
            if (diff.getValue() == value) {
                return true;
            }
            IEqualityHelper helper = diff.getMatch().getComparison().getEqualityHelper();
            return helper.matchingValues(diff.getValue(), value);
        }
    }
}

