/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.handler;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.command.ICompareCopyCommand;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.handler.util.EMFCompareUIHandlerUtil;
import org.eclipse.emf.compare.internal.utils.DiffUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractAcceptRejectChange
extends AbstractHandler {
    private CompareConfiguration configuration;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object editorInput = HandlerUtil.getVariable((ExecutionEvent)event, (String)"activeEditorInput");
        if (editorInput instanceof CompareEditorInput) {
            EObject data;
            Notifier target;
            this.configuration = ((CompareEditorInput)editorInput).getCompareConfiguration();
            Object diffNode = ((CompareEditorInput)editorInput).getSelectedEdition();
            if (diffNode instanceof Adapter && (target = ((Adapter)diffNode).getTarget()) instanceof TreeNode && (data = ((TreeNode)target).getData()) instanceof Diff) {
                boolean leftEditableOnly;
                boolean rightEditableOnly = !this.configuration.isLeftEditable() && this.configuration.isRightEditable();
                boolean bl = leftEditableOnly = this.configuration.isLeftEditable() && !this.configuration.isRightEditable();
                if (leftEditableOnly) {
                    if (this.isCopyDiffCase((Diff)data, false)) {
                        EMFCompareUIHandlerUtil.copyDiff((Diff)data, false, this.configuration);
                    } else {
                        this.changeStateFromUnresolvedToMerged((Diff)data, true);
                    }
                } else if (rightEditableOnly) {
                    if (this.isCopyDiffCase((Diff)data, true)) {
                        EMFCompareUIHandlerUtil.copyDiff((Diff)data, true, this.configuration);
                    } else {
                        this.changeStateFromUnresolvedToMerged((Diff)data, false);
                    }
                }
                EMFCompareUIHandlerUtil.navigate(true, this.configuration);
            }
        }
        return null;
    }

    protected abstract boolean isCopyDiffCase(Diff var1, boolean var2);

    private void changeStateFromUnresolvedToMerged(Diff diffToChangeState, boolean leftToRight) {
        if (diffToChangeState != null) {
            ICompareEditingDomain compareEditingDomain = (ICompareEditingDomain)this.configuration.getProperty("org.eclipse.emf.compare.rcp.ui.EDITING_DOMAIN");
            AcceptRejectChangeCommand changeStateCommand = new AcceptRejectChangeCommand(compareEditingDomain.getChangeRecorder(), diffToChangeState, leftToRight, this.configuration);
            compareEditingDomain.getCommandStack().execute((Command)changeStateCommand);
        }
    }

    private static class AcceptRejectChangeCommand
    extends ChangeCommand
    implements ICompareCopyCommand {
        private Diff difference;
        private boolean leftToRight;
        private CompareConfiguration configuration;

        public AcceptRejectChangeCommand(ChangeRecorder changeRecorder, Diff difference, boolean leftToRight, CompareConfiguration configuration) {
            super(changeRecorder, (Collection)ImmutableSet.builder().add((Object)difference).addAll((Iterable)DiffUtil.getRequires((Diff)difference, (boolean)leftToRight)).build());
            this.difference = difference;
            this.leftToRight = leftToRight;
            this.configuration = configuration;
        }

        public void doExecute() {
            for (Diff require : DiffUtil.getRequires((Diff)this.difference, (boolean)this.leftToRight)) {
                EMFCompareUIHandlerUtil.setMergeDataForDiff(require, this.leftToRight, this.configuration.isLeftEditable(), this.configuration.isRightEditable());
                require.setState(DifferenceState.MERGED);
            }
            EMFCompareUIHandlerUtil.setMergeDataForDiff(this.difference, this.leftToRight, this.configuration.isLeftEditable(), this.configuration.isRightEditable());
            this.difference.setState(DifferenceState.MERGED);
        }

        public boolean isLeftToRight() {
            return this.leftToRight;
        }
    }
}

