/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.resolver;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.eclipse.emf.compare.graph.IGraph;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.DependencyFoundEvent;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ResolvedEvent;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ResourceRemovedEvent;

public class DependencyGraphUpdater<T> {
    private final IGraph<T> dependencyGraph;
    private static final Logger LOGGER = Logger.getLogger(DependencyGraphUpdater.class);

    public DependencyGraphUpdater(IGraph<T> graph, EventBus eventBus) {
        this.dependencyGraph = (IGraph)Preconditions.checkNotNull(graph);
        eventBus.register((Object)this);
    }

    @Subscribe
    public synchronized void recordNode(ResolvedEvent<T> event) {
        this.dependencyGraph.add(event.getNode());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Added node " + event.getNode()));
        }
    }

    @Subscribe
    public synchronized void recordEdge(DependencyFoundEvent<T> event) {
        this.dependencyGraph.addChildren(event.getFrom(), Collections.singleton(event.getTo()));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Added edge " + event.getFrom() + " -> " + event.getTo()));
        }
        if (event.hasParent()) {
            this.dependencyGraph.addParentData(event.getTo(), event.getParent().get());
        }
    }

    @Subscribe
    public synchronized void recordRemoval(ResourceRemovedEvent<T> event) {
        this.dependencyGraph.removeAll(event.getElements());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Cleared " + event.getElements().size() + " nodes."));
        }
    }
}

