/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.merge;

import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.logical.EMFModelProvider;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.CrossReferenceResolutionScope;
import org.eclipse.emf.compare.ide.ui.tests.CompareTestCase;
import org.eclipse.emf.compare.ide.ui.tests.egit.fixture.GitTestRepository;
import org.eclipse.emf.compare.ide.ui.tests.egit.fixture.MockSystemReader;
import org.eclipse.emf.compare.ide.ui.tests.workspace.TestProject;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.util.SystemReader;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class RemoteNewProjectTests
extends CompareTestCase {
    private static final String MASTER = "refs/heads/master";
    private static final String BRANCH_1 = "refs/heads/branch1";
    private static final String BRANCH_2 = "refs/heads/branch2";
    private static final String BRANCH_3 = "refs/heads/branch3";
    protected GitTestRepository repository;
    private File gitDir;
    private static String deafultResolutionScope;

    @BeforeClass
    public static void setUpClass() {
        IEclipsePreferences eGitPreferences = InstanceScope.INSTANCE.getNode("org.eclipse.egit.core");
        eGitPreferences.put("core_preferredMergeStrategy", "model recursive");
        eGitPreferences.putBoolean("core_autoShareProjects", false);
        eGitPreferences.putBoolean("core_autoIgnoreDerivedResources", false);
        IPreferenceStore store = EMFCompareIDEUIPlugin.getDefault().getPreferenceStore();
        deafultResolutionScope = store.getString("org.eclipse.emf.compare.ide.ui.preference.resolutionScope");
        store.setValue("org.eclipse.emf.compare.ide.ui.preference.resolutionScope", CrossReferenceResolutionScope.WORKSPACE.name());
    }

    @AfterClass
    public static void tearDownClass() {
        IPreferenceStore store = EMFCompareIDEUIPlugin.getDefault().getPreferenceStore();
        store.setValue("org.eclipse.emf.compare.ide.ui.preference.resolutionScope", deafultResolutionScope);
    }

    @Before
    public void setUp() throws Exception {
        RepositoryCache.getInstance().clear();
        MockSystemReader mockSystemReader = new MockSystemReader();
        SystemReader.setInstance((SystemReader)mockSystemReader);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        String gitRepoPath = workspaceRoot.getRawLocation().toFile() + File.separator + "repo";
        mockSystemReader.setProperty("GIT_CEILING_DIRECTORIES", workspaceRoot.getLocation().toFile().getParentFile().getAbsoluteFile().toString());
        this.gitDir = new File(gitRepoPath, ".git");
        this.repository = new GitTestRepository(this.gitDir);
        this.repository.ignore(workspaceRoot.getRawLocation().append(".metadata").toFile());
    }

    @After
    public void tearDown() throws Exception {
        File gitRoot;
        EMFModelProvider emfModelProvider = (EMFModelProvider)ModelProvider.getModelProviderDescriptor((String)"org.eclipse.emf.compare.model.provider").getModelProvider();
        emfModelProvider.clear();
        this.repository.dispose();
        RepositoryCache.getInstance().clear();
        if (this.gitDir.exists() && (gitRoot = this.gitDir.getParentFile()).exists()) {
            Throwable throwable = null;
            Object var4_5 = null;
            try (Stream<Path> walk = Files.walk(gitRoot.toPath(), new FileVisitOption[0]);){
                walk.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    @Test
    public void testCollaborativeModeling_UseCase001_MergeFragmentFromRemoteProject() throws Exception {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        File workingDirectory = this.repository.getRepository().getWorkTree();
        TestProject testProject1 = new TestProject("Project1", workingDirectory.getAbsolutePath());
        IProject iProject = testProject1.getProject();
        this.repository.connect(iProject);
        File file1 = testProject1.getOrCreateFile(iProject, "file1.ecore");
        IFile iFile1 = testProject1.getIFile(iProject, file1);
        Resource resource1 = this.connectResource(iFile1, (ResourceSet)resourceSet);
        EPackage root = this.createPackage(null, "parent");
        EPackage child = this.createPackage(root, "child");
        this.createClass(child, "C1");
        resource1.getContents().add((Object)root);
        this.save(new Resource[]{resource1});
        this.repository.addAllAndCommit("1st-commit");
        this.repository.createBranch(MASTER, BRANCH_1);
        TestProject testProject2 = new TestProject("Project2", workingDirectory.getAbsolutePath());
        IProject iProject2 = testProject2.getProject();
        this.repository.connect(iProject2);
        File file2 = testProject2.getOrCreateFile(iProject2, "file2.ecore");
        IFile iFile2 = testProject2.getIFile(iProject2, file2);
        File file22 = testProject2.getOrCreateFile(iProject2, "file22.txt");
        IFile iFile22 = testProject2.getIFile(iProject2, file22);
        Resource resource2 = this.connectResource(iFile2, (ResourceSet)resourceSet);
        resource2.getContents().add((Object)child);
        resource1.getContents().clear();
        resource1.getContents().add((Object)root);
        this.save(new Resource[]{resource2});
        this.save(new Resource[]{resource1});
        this.repository.addAllAndCommit("2nd-commit");
        this.repository.createBranch(MASTER, BRANCH_2);
        this.repository.reset(BRANCH_1, ResetCommand.ResetType.HARD);
        resourceSet.getResources().clear();
        resource1 = resourceSet.getResource(URI.createPlatformResourceURI((String)iFile1.getFullPath().toString(), (boolean)true), true);
        root = (EPackage)resource1.getContents().get(0);
        EPackage child2 = this.createPackage(root, "child2");
        this.save(new Resource[]{resource1});
        this.repository.addAllAndCommit("3rd-commit");
        this.repository.createBranch(MASTER, BRANCH_3);
        this.repository.mergeLogicalWithNewCommit(BRANCH_2);
        Assert.assertTrue((boolean)this.repository.status().getConflicting().isEmpty());
        Assert.assertTrue((boolean)iProject.isAccessible());
        Assert.assertFalse((boolean)iProject2.isAccessible());
        Assert.assertTrue((boolean)iFile1.exists());
        Assert.assertFalse((boolean)iFile2.exists());
        Assert.assertFalse((boolean)iFile22.exists());
        Assert.assertTrue((boolean)file2.exists());
        Assert.assertTrue((boolean)file22.exists());
        resourceSet.getResources().clear();
        resource1 = resourceSet.getResource(URI.createPlatformResourceURI((String)iFile1.getFullPath().toString(), (boolean)true), true);
        resource2 = resourceSet.getResource(URI.createFileURI((String)file2.getAbsolutePath()), true);
        resource2.setURI(URI.createPlatformResourceURI((String)iFile2.getFullPath().toString(), (boolean)true));
        EcoreUtil.resolveAll((ResourceSet)resourceSet);
        root = (EPackage)resource1.getContents().get(0);
        Assert.assertEquals((Object)"parent", (Object)root.getName());
        child = (EPackage)root.getESubpackages().get(0);
        Assert.assertEquals((Object)"child", (Object)child.getName());
        Assert.assertSame((Object)resource2, (Object)((InternalEObject)child).eDirectResource());
        EClass testC1 = (EClass)child.getEClassifiers().get(0);
        Assert.assertEquals((Object)"C1", (Object)testC1.getName());
        child2 = (EPackage)root.getESubpackages().get(1);
        Assert.assertEquals((Object)"child2", (Object)child2.getName());
        testProject1.dispose();
        testProject2.dispose();
    }

    @Test
    public void testCollaborativeModeling_UseCase002_MergeFragmentContainingRenameFromRemoteProject() throws Exception {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        File workingDirectory = this.repository.getRepository().getWorkTree();
        TestProject testProject1 = new TestProject("Project1", workingDirectory.getAbsolutePath());
        IProject iProject = testProject1.getProject();
        this.repository.connect(iProject);
        File file1 = testProject1.getOrCreateFile(iProject, "file1.ecore");
        IFile iFile1 = testProject1.getIFile(iProject, file1);
        Resource resource1 = this.connectResource(iFile1, (ResourceSet)resourceSet);
        EPackage root = this.createPackage(null, "parent");
        EPackage child = this.createPackage(root, "child");
        this.createClass(child, "C1");
        resource1.getContents().add((Object)root);
        this.save(new Resource[]{resource1});
        this.repository.addAllAndCommit("1st-commit");
        this.repository.createBranch(MASTER, BRANCH_1);
        TestProject testProject2 = new TestProject("Project2", workingDirectory.getAbsolutePath());
        IProject iProject2 = testProject2.getProject();
        this.repository.connect(iProject2);
        File file2 = testProject2.getOrCreateFile(iProject2, "file2.ecore");
        IFile iFile2 = testProject2.getIFile(iProject2, file2);
        File file22 = testProject2.getOrCreateFile(iProject2, "file22.txt");
        IFile iFile22 = testProject2.getIFile(iProject2, file22);
        Resource resource2 = this.connectResource(iFile2, (ResourceSet)resourceSet);
        resource2.getContents().add((Object)child);
        resource1.getContents().clear();
        resource1.getContents().add((Object)root);
        this.save(new Resource[]{resource2});
        this.save(new Resource[]{resource1});
        this.repository.addAllAndCommit("2nd-commit");
        this.repository.createBranch(MASTER, BRANCH_2);
        this.repository.reset(BRANCH_1, ResetCommand.ResetType.HARD);
        resourceSet.getResources().clear();
        resource1 = resourceSet.getResource(URI.createPlatformResourceURI((String)iFile1.getFullPath().toString(), (boolean)true), true);
        root = (EPackage)resource1.getContents().get(0);
        child = (EPackage)root.getESubpackages().get(0);
        child.setName("newChild");
        this.save(new Resource[]{resource1});
        this.repository.addAllAndCommit("3rd-commit");
        this.repository.createBranch(MASTER, BRANCH_3);
        this.repository.mergeLogicalWithNewCommit(BRANCH_2);
        Assert.assertTrue((boolean)this.repository.status().getConflicting().isEmpty());
        Assert.assertTrue((boolean)iProject.isAccessible());
        Assert.assertFalse((boolean)iProject2.isAccessible());
        Assert.assertTrue((boolean)iFile1.exists());
        Assert.assertFalse((boolean)iFile2.exists());
        Assert.assertFalse((boolean)iFile22.exists());
        Assert.assertTrue((boolean)file2.exists());
        Assert.assertTrue((boolean)file22.exists());
        resourceSet.getResources().clear();
        resource1 = resourceSet.getResource(URI.createPlatformResourceURI((String)iFile1.getFullPath().toString(), (boolean)true), true);
        resource2 = resourceSet.getResource(URI.createFileURI((String)file2.getAbsolutePath()), true);
        resource2.setURI(URI.createPlatformResourceURI((String)iFile2.getFullPath().toString(), (boolean)true));
        EcoreUtil.resolveAll((ResourceSet)resourceSet);
        root = (EPackage)resource1.getContents().get(0);
        Assert.assertEquals((Object)"parent", (Object)root.getName());
        child = (EPackage)root.getESubpackages().get(0);
        Assert.assertEquals((Object)"newChild", (Object)child.getName());
        Assert.assertSame((Object)resource2, (Object)((InternalEObject)child).eDirectResource());
        EClass testC1 = (EClass)child.getEClassifiers().get(0);
        Assert.assertEquals((Object)"C1", (Object)testC1.getName());
        testProject1.dispose();
        testProject2.dispose();
    }

    @Test
    public void testCollaborativeModeling_UseCase003_MergeFragmentFromOutsideRepository() throws Exception {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        File workingDirectory = this.repository.getRepository().getWorkTree();
        TestProject testProject1 = new TestProject("Project1", workingDirectory.getAbsolutePath());
        IProject iProject = testProject1.getProject();
        this.repository.connect(iProject);
        File file1 = testProject1.getOrCreateFile(iProject, "file1.ecore");
        IFile iFile1 = testProject1.getIFile(iProject, file1);
        Resource resource1 = this.connectResource(iFile1, (ResourceSet)resourceSet);
        EPackage root = this.createPackage(null, "parent");
        resource1.getContents().add((Object)root);
        EClass c1 = this.createClass(root, "C1");
        this.save(new Resource[]{resource1});
        this.repository.addAllAndCommit("1st-commit");
        this.repository.createBranch(MASTER, BRANCH_1);
        TestProject testProject2 = new TestProject("Project2", ResourcesPlugin.getWorkspace().getRoot().getLocation().toString());
        IProject iProject2 = testProject2.getProject();
        File file2 = testProject2.getOrCreateFile(iProject2, "file2.ecore");
        IFile iFile2 = testProject2.getIFile(iProject2, file2);
        File file22 = testProject2.getOrCreateFile(iProject2, "file22.txt");
        IFile iFile22 = testProject2.getIFile(iProject2, file22);
        Resource resource2 = this.connectResource(iFile2, (ResourceSet)resourceSet);
        EPackage root2 = this.createPackage(null, "parent2");
        EClass c2 = this.createClass(root2, "C2");
        resource2.getContents().add((Object)root2);
        this.save(new Resource[]{resource2});
        c1.getESuperTypes().add((Object)c2);
        this.save(new Resource[]{resource1});
        this.repository.addAllAndCommit("2nd-commit");
        this.repository.createBranch(MASTER, BRANCH_2);
        this.repository.reset(BRANCH_1, ResetCommand.ResetType.HARD);
        resourceSet.getResources().clear();
        resource1 = resourceSet.getResource(URI.createPlatformResourceURI((String)iFile1.getFullPath().toString(), (boolean)true), true);
        root = (EPackage)resource1.getContents().get(0);
        c1 = (EClass)root.getEClassifiers().get(0);
        EAttribute att1 = this.createAttribute(c1, "attribute1", null);
        this.save(new Resource[]{resource1});
        this.repository.addAllAndCommit("3rd-commit");
        this.repository.createBranch(MASTER, BRANCH_3);
        this.repository.mergeLogicalWithNewCommit(BRANCH_2);
        Assert.assertTrue((boolean)this.repository.status().getConflicting().isEmpty());
        Assert.assertTrue((boolean)iProject.isAccessible());
        Assert.assertTrue((boolean)iProject2.isAccessible());
        Assert.assertTrue((boolean)iFile1.exists());
        Assert.assertTrue((boolean)iFile2.exists());
        Assert.assertTrue((boolean)iFile22.exists());
        Assert.assertTrue((boolean)file2.exists());
        Assert.assertTrue((boolean)file22.exists());
        resourceSet.getResources().clear();
        resource1 = resourceSet.getResource(URI.createPlatformResourceURI((String)iFile1.getFullPath().toString(), (boolean)true), true);
        resource2 = resourceSet.getResource(URI.createPlatformResourceURI((String)iFile2.getFullPath().toString(), (boolean)true), true);
        root = (EPackage)resource1.getContents().get(0);
        Assert.assertEquals((Object)"parent", (Object)root.getName());
        c1 = (EClass)root.getEClassifiers().get(0);
        Assert.assertEquals((Object)"C1", (Object)c1.getName());
        att1 = (EAttribute)c1.getEAttributes().get(0);
        Assert.assertEquals((Object)"attribute1", (Object)att1.getName());
        root2 = (EPackage)resource2.getContents().get(0);
        Assert.assertEquals((Object)"parent2", (Object)root2.getName());
        c2 = (EClass)root2.getEClassifiers().get(0);
        Assert.assertEquals((Object)"C2", (Object)c2.getName());
        Assert.assertEquals((Object)c2, (Object)c1.getESuperTypes().get(0));
        testProject1.dispose();
        testProject2.dispose();
    }

    @Test
    public void testCollaborativeModeling_UseCase004_MergeFragmentFromRemoteProject_NotAtRepoRoot() throws Exception {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        File workingDirectory = this.repository.getRepository().getWorkTree();
        TestProject testProject1 = new TestProject("Project1", String.valueOf(workingDirectory.getAbsolutePath()) + "/a/b/c/d/e/f/g/");
        IProject iProject = testProject1.getProject();
        this.repository.connect(iProject);
        File file1 = testProject1.getOrCreateFile(iProject, "folder1/folder2/folder3/file1.ecore");
        IFile iFile1 = testProject1.getIFile(iProject, file1);
        Resource resource1 = this.connectResource(iFile1, (ResourceSet)resourceSet);
        EPackage root = this.createPackage(null, "parent");
        EPackage child = this.createPackage(root, "child");
        this.createClass(child, "C1");
        resource1.getContents().add((Object)root);
        this.save(new Resource[]{resource1});
        this.repository.addAllAndCommit("1st-commit");
        this.repository.createBranch(MASTER, BRANCH_1);
        TestProject testProject2 = new TestProject("Project2", String.valueOf(workingDirectory.getAbsolutePath()) + "/h/i/j/");
        IProject iProject2 = testProject2.getProject();
        this.repository.connect(iProject2);
        File file2 = testProject2.getOrCreateFile(iProject2, "folder1/folder2/folder3/folder4/file2.ecore");
        IFile iFile2 = testProject2.getIFile(iProject2, file2);
        File file22 = testProject2.getOrCreateFile(iProject2, "folder1/folder2/file22.txt");
        IFile iFile22 = testProject2.getIFile(iProject2, file22);
        Resource resource2 = this.connectResource(iFile2, (ResourceSet)resourceSet);
        resource2.getContents().add((Object)child);
        resource1.getContents().clear();
        resource1.getContents().add((Object)root);
        this.save(new Resource[]{resource2});
        this.save(new Resource[]{resource1});
        this.repository.addAllAndCommit("2nd-commit");
        this.repository.createBranch(MASTER, BRANCH_2);
        this.repository.reset(BRANCH_1, ResetCommand.ResetType.HARD);
        resourceSet.getResources().clear();
        resource1 = resourceSet.getResource(URI.createFileURI((String)file1.getAbsolutePath()), true);
        root = (EPackage)resource1.getContents().get(0);
        child = (EPackage)root.getESubpackages().get(0);
        child.setName("newChild");
        this.save(new Resource[]{resource1});
        this.repository.addAllAndCommit("3rd-commit");
        this.repository.createBranch(MASTER, BRANCH_3);
        this.repository.mergeLogicalWithNewCommit(BRANCH_2);
        Assert.assertTrue((boolean)this.repository.status().getConflicting().isEmpty());
        Assert.assertTrue((boolean)iProject.isAccessible());
        Assert.assertFalse((boolean)iProject2.isAccessible());
        Assert.assertTrue((boolean)iFile1.exists());
        Assert.assertFalse((boolean)iFile2.exists());
        Assert.assertFalse((boolean)iFile22.exists());
        Assert.assertTrue((boolean)file2.exists());
        Assert.assertTrue((boolean)file22.exists());
        resourceSet.getResources().clear();
        resource1 = resourceSet.getResource(URI.createPlatformResourceURI((String)iFile1.getFullPath().toString(), (boolean)true), true);
        resource2 = resourceSet.getResource(URI.createFileURI((String)file2.getAbsolutePath()), true);
        resource2.setURI(URI.createPlatformResourceURI((String)iFile2.getFullPath().toString(), (boolean)true));
        EcoreUtil.resolveAll((ResourceSet)resourceSet);
        root = (EPackage)resource1.getContents().get(0);
        Assert.assertEquals((Object)"parent", (Object)root.getName());
        child = (EPackage)root.getESubpackages().get(0);
        Assert.assertEquals((Object)"newChild", (Object)child.getName());
        Assert.assertSame((Object)resource2, (Object)((InternalEObject)child).eDirectResource());
        EClass testC1 = (EClass)child.getEClassifiers().get(0);
        Assert.assertEquals((Object)"C1", (Object)testC1.getName());
    }

    @Test
    public void testCollaborativeModeling_UseCase005_MergeFragmentFromRemoteProjectInsideAnotherProject() throws Exception {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        File workingDirectory = this.repository.getRepository().getWorkTree();
        TestProject testProject1 = new TestProject("Project1", workingDirectory.getAbsolutePath());
        IProject iProject = testProject1.getProject();
        this.repository.connect(iProject);
        File file1 = testProject1.getOrCreateFile(iProject, "file1.ecore");
        IFile iFile1 = testProject1.getIFile(iProject, file1);
        Resource resource1 = this.connectResource(iFile1, (ResourceSet)resourceSet);
        EPackage root = this.createPackage(null, "parent");
        EPackage child = this.createPackage(root, "child");
        this.createClass(child, "C1");
        resource1.getContents().add((Object)root);
        this.save(new Resource[]{resource1});
        this.repository.addAllAndCommit("1st-commit");
        this.repository.createBranch(MASTER, BRANCH_1);
        TestProject testProject2 = new TestProject("Project2", String.valueOf(workingDirectory.getAbsolutePath()) + "/Project1/a/");
        IProject iProject2 = testProject2.getProject();
        this.repository.connect(iProject2);
        File file2 = testProject2.getOrCreateFile(iProject2, "file2.ecore");
        IFile iFile2 = testProject2.getIFile(iProject2, file2);
        File file22 = testProject2.getOrCreateFile(iProject2, "folder1/folder2/file22.txt");
        IFile iFile22 = testProject2.getIFile(iProject2, file22);
        Resource resource2 = this.connectResource(iFile2, (ResourceSet)resourceSet);
        resource2.getContents().add((Object)child);
        resource1.getContents().clear();
        resource1.getContents().add((Object)root);
        this.save(new Resource[]{resource2});
        this.save(new Resource[]{resource1});
        this.repository.addAllAndCommit("2nd-commit");
        this.repository.createBranch(MASTER, BRANCH_2);
        this.repository.reset(BRANCH_1, ResetCommand.ResetType.HARD);
        resourceSet.getResources().clear();
        resource1 = resourceSet.getResource(URI.createFileURI((String)file1.getAbsolutePath()), true);
        root = (EPackage)resource1.getContents().get(0);
        child = (EPackage)root.getESubpackages().get(0);
        child.setName("newChild");
        this.save(new Resource[]{resource1});
        this.repository.addAllAndCommit("3rd-commit");
        this.repository.createBranch(MASTER, BRANCH_3);
        this.repository.mergeLogicalWithNewCommit(BRANCH_2);
        Assert.assertTrue((boolean)this.repository.status().getConflicting().isEmpty());
        Assert.assertTrue((boolean)iProject.isAccessible());
        Assert.assertFalse((boolean)iProject2.isAccessible());
        Assert.assertTrue((boolean)iFile1.exists());
        Assert.assertFalse((boolean)iFile2.exists());
        Assert.assertFalse((boolean)iFile22.exists());
        Assert.assertTrue((boolean)file2.exists());
        Assert.assertTrue((boolean)file22.exists());
        resourceSet.getResources().clear();
        resource1 = resourceSet.getResource(URI.createPlatformResourceURI((String)iFile1.getFullPath().toString(), (boolean)true), true);
        resource2 = resourceSet.getResource(URI.createFileURI((String)file2.getAbsolutePath()), true);
        resource2.setURI(URI.createPlatformResourceURI((String)iFile2.getFullPath().toString(), (boolean)true));
        EcoreUtil.resolveAll((ResourceSet)resourceSet);
        root = (EPackage)resource1.getContents().get(0);
        Assert.assertEquals((Object)"parent", (Object)root.getName());
        child = (EPackage)root.getESubpackages().get(0);
        Assert.assertEquals((Object)"newChild", (Object)child.getName());
        Assert.assertSame((Object)resource2, (Object)((InternalEObject)child).eDirectResource());
        EClass testC1 = (EClass)child.getEClassifiers().get(0);
        Assert.assertEquals((Object)"C1", (Object)testC1.getName());
    }

    @Test
    public void testCollaborativeModeling_UseCase006_MergeMultipleIndependentFragmentsFromRemoteProject() throws Exception {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        File workingDirectory = this.repository.getRepository().getWorkTree();
        TestProject testProject1 = new TestProject("Project1", workingDirectory.getAbsolutePath());
        IProject iProject = testProject1.getProject();
        this.repository.connect(iProject);
        File file1 = testProject1.getOrCreateFile(iProject, "file1.ecore");
        IFile iFile1 = testProject1.getIFile(iProject, file1);
        Resource resource1 = this.connectResource(iFile1, (ResourceSet)resourceSet);
        EPackage root = this.createPackage(null, "parent");
        EPackage child1 = this.createPackage(root, "child1");
        this.createClass(child1, "C1");
        EPackage child2 = this.createPackage(root, "child2");
        this.createClass(child2, "C2");
        resource1.getContents().add((Object)root);
        this.save(new Resource[]{resource1});
        this.repository.addAllAndCommit("1st-commit");
        this.repository.createBranch(MASTER, BRANCH_1);
        TestProject testProject2 = new TestProject("Project2", workingDirectory.getAbsolutePath());
        IProject iProject2 = testProject2.getProject();
        this.repository.connect(iProject2);
        File file2 = testProject2.getOrCreateFile(iProject2, "file2.ecore");
        IFile iFile2 = testProject2.getIFile(iProject2, file2);
        File file3 = testProject2.getOrCreateFile(iProject2, "file3.ecore");
        IFile iFile3 = testProject2.getIFile(iProject2, file3);
        File file22 = testProject2.getOrCreateFile(iProject2, "file22.txt");
        IFile iFile22 = testProject2.getIFile(iProject2, file22);
        Resource resource2 = this.connectResource(iFile2, (ResourceSet)resourceSet);
        Resource resource3 = this.connectResource(iFile3, (ResourceSet)resourceSet);
        resource2.getContents().add((Object)child1);
        resource3.getContents().add((Object)child2);
        resource1.getContents().clear();
        resource1.getContents().add((Object)root);
        this.save(new Resource[]{resource3});
        this.save(new Resource[]{resource2});
        this.save(new Resource[]{resource1});
        this.repository.addAllAndCommit("2nd-commit");
        this.repository.createBranch(MASTER, BRANCH_2);
        this.repository.reset(BRANCH_1, ResetCommand.ResetType.HARD);
        resourceSet.getResources().clear();
        resource1 = resourceSet.getResource(URI.createPlatformResourceURI((String)iFile1.getFullPath().toString(), (boolean)true), true);
        root = (EPackage)resource1.getContents().get(0);
        child1 = (EPackage)root.getESubpackages().get(0);
        child1.setName("newChild1");
        child2 = (EPackage)root.getESubpackages().get(1);
        child2.setName("newChild2");
        this.save(new Resource[]{resource1});
        this.repository.addAllAndCommit("3rd-commit");
        this.repository.createBranch(MASTER, BRANCH_3);
        this.repository.mergeLogicalWithNewCommit(BRANCH_2);
        Assert.assertTrue((boolean)this.repository.status().getConflicting().isEmpty());
        Assert.assertTrue((boolean)iProject.isAccessible());
        Assert.assertFalse((boolean)iProject2.isAccessible());
        Assert.assertTrue((boolean)iFile1.exists());
        Assert.assertFalse((boolean)iFile2.exists());
        Assert.assertFalse((boolean)iFile3.exists());
        Assert.assertFalse((boolean)iFile22.exists());
        Assert.assertTrue((boolean)file2.exists());
        Assert.assertTrue((boolean)file3.exists());
        Assert.assertTrue((boolean)file22.exists());
        resourceSet.getResources().clear();
        resource1 = resourceSet.getResource(URI.createPlatformResourceURI((String)iFile1.getFullPath().toString(), (boolean)true), true);
        resource2 = resourceSet.getResource(URI.createFileURI((String)file2.getAbsolutePath()), true);
        resource3 = resourceSet.getResource(URI.createFileURI((String)file3.getAbsolutePath()), true);
        resource2.setURI(URI.createPlatformResourceURI((String)iFile2.getFullPath().toString(), (boolean)true));
        resource3.setURI(URI.createPlatformResourceURI((String)iFile3.getFullPath().toString(), (boolean)true));
        EcoreUtil.resolveAll((ResourceSet)resourceSet);
        root = (EPackage)resource1.getContents().get(0);
        Assert.assertEquals((Object)"parent", (Object)root.getName());
        child1 = (EPackage)root.getESubpackages().get(0);
        Assert.assertEquals((Object)"newChild1", (Object)child1.getName());
        Assert.assertSame((Object)resource2, (Object)((InternalEObject)child1).eDirectResource());
        EClass testC1 = (EClass)child1.getEClassifiers().get(0);
        Assert.assertEquals((Object)"C1", (Object)testC1.getName());
        child2 = (EPackage)root.getESubpackages().get(1);
        Assert.assertEquals((Object)"newChild2", (Object)child2.getName());
        Assert.assertSame((Object)resource3, (Object)((InternalEObject)child2).eDirectResource());
        EClass testC2 = (EClass)child2.getEClassifiers().get(0);
        Assert.assertEquals((Object)"C2", (Object)testC2.getName());
        testProject1.dispose();
        testProject2.dispose();
    }

    @Test
    public void testCollaborativeModeling_UseCase007_MergeMultipleDependentFragmentsFromRemoteProject() throws Exception {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        File workingDirectory = this.repository.getRepository().getWorkTree();
        TestProject testProject1 = new TestProject("Project1", workingDirectory.getAbsolutePath());
        IProject iProject = testProject1.getProject();
        this.repository.connect(iProject);
        File file1 = testProject1.getOrCreateFile(iProject, "file1.ecore");
        IFile iFile1 = testProject1.getIFile(iProject, file1);
        Resource resource1 = this.connectResource(iFile1, (ResourceSet)resourceSet);
        EPackage root = this.createPackage(null, "parent");
        EPackage child1 = this.createPackage(root, "child1");
        this.createClass(child1, "C1");
        EPackage child2 = this.createPackage(child1, "child1");
        this.createClass(child2, "C2");
        resource1.getContents().add((Object)root);
        this.save(new Resource[]{resource1});
        this.repository.addAllAndCommit("1st-commit");
        this.repository.createBranch(MASTER, BRANCH_1);
        TestProject testProject2 = new TestProject("Project2", workingDirectory.getAbsolutePath());
        IProject iProject2 = testProject2.getProject();
        this.repository.connect(iProject2);
        File file2 = testProject2.getOrCreateFile(iProject2, "file2.ecore");
        IFile iFile2 = testProject2.getIFile(iProject2, file2);
        File file3 = testProject2.getOrCreateFile(iProject2, "file3.ecore");
        IFile iFile3 = testProject2.getIFile(iProject2, file3);
        File file22 = testProject2.getOrCreateFile(iProject2, "file22.txt");
        IFile iFile22 = testProject2.getIFile(iProject2, file22);
        Resource resource2 = this.connectResource(iFile2, (ResourceSet)resourceSet);
        Resource resource3 = this.connectResource(iFile3, (ResourceSet)resourceSet);
        resource3.getContents().add((Object)child2);
        resource2.getContents().add((Object)child1);
        resource1.getContents().clear();
        resource1.getContents().add((Object)root);
        this.save(new Resource[]{resource3});
        this.save(new Resource[]{resource2});
        this.save(new Resource[]{resource1});
        this.repository.addAllAndCommit("2nd-commit");
        this.repository.createBranch(MASTER, BRANCH_2);
        this.repository.reset(BRANCH_1, ResetCommand.ResetType.HARD);
        resourceSet.getResources().clear();
        resource1 = resourceSet.getResource(URI.createPlatformResourceURI((String)iFile1.getFullPath().toString(), (boolean)true), true);
        root = (EPackage)resource1.getContents().get(0);
        child1 = (EPackage)root.getESubpackages().get(0);
        child1.setName("newChild1");
        child2 = (EPackage)child1.getESubpackages().get(0);
        child2.setName("newChild2");
        this.save(new Resource[]{resource1});
        this.repository.addAllAndCommit("3rd-commit");
        this.repository.createBranch(MASTER, BRANCH_3);
        this.repository.mergeLogicalWithNewCommit(BRANCH_2);
        Assert.assertTrue((boolean)this.repository.status().getConflicting().isEmpty());
        Assert.assertTrue((boolean)iProject.isAccessible());
        Assert.assertFalse((boolean)iProject2.isAccessible());
        Assert.assertTrue((boolean)iFile1.exists());
        Assert.assertFalse((boolean)iFile2.exists());
        Assert.assertFalse((boolean)iFile3.exists());
        Assert.assertFalse((boolean)iFile22.exists());
        Assert.assertTrue((boolean)file2.exists());
        Assert.assertTrue((boolean)file3.exists());
        Assert.assertTrue((boolean)file22.exists());
        resourceSet.getResources().clear();
        resource3 = resourceSet.getResource(URI.createFileURI((String)file3.getAbsolutePath()), true);
        resource2 = resourceSet.getResource(URI.createFileURI((String)file2.getAbsolutePath()), true);
        resource1 = resourceSet.getResource(URI.createPlatformResourceURI((String)iFile1.getFullPath().toString(), (boolean)true), true);
        resource2.setURI(URI.createPlatformResourceURI((String)iFile2.getFullPath().toString(), (boolean)true));
        EcoreUtil.resolveAll((ResourceSet)resourceSet);
        root = (EPackage)resource1.getContents().get(0);
        Assert.assertEquals((Object)"parent", (Object)root.getName());
        child1 = (EPackage)root.getESubpackages().get(0);
        Assert.assertEquals((Object)"newChild1", (Object)child1.getName());
        Assert.assertSame((Object)resource2, (Object)((InternalEObject)child1).eDirectResource());
        EClass testC1 = (EClass)child1.getEClassifiers().get(0);
        Assert.assertEquals((Object)"C1", (Object)testC1.getName());
        child2 = (EPackage)child1.getESubpackages().get(0);
        Assert.assertEquals((Object)"newChild2", (Object)child2.getName());
        Assert.assertSame((Object)resource3, (Object)((InternalEObject)child2).eDirectResource());
        EClass testC2 = (EClass)child2.getEClassifiers().get(0);
        Assert.assertEquals((Object)"C2", (Object)testC2.getName());
        testProject1.dispose();
        testProject2.dispose();
    }

    @Test
    public void testCollaborativeModeling_UseCase008_MergeFragmentFromSameProject() throws Exception {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        File workingDirectory = this.repository.getRepository().getWorkTree();
        TestProject testProject1 = new TestProject("Project1", workingDirectory.getAbsolutePath());
        IProject iProject = testProject1.getProject();
        this.repository.connect(iProject);
        File file1 = testProject1.getOrCreateFile(iProject, "file1.ecore");
        IFile iFile1 = testProject1.getIFile(iProject, file1);
        Resource resource1 = this.connectResource(iFile1, (ResourceSet)resourceSet);
        EPackage root = this.createPackage(null, "parent");
        EPackage child = this.createPackage(root, "child");
        this.createClass(child, "C1");
        resource1.getContents().add((Object)root);
        this.save(new Resource[]{resource1});
        this.repository.addAllAndCommit("1st-commit");
        this.repository.createBranch(MASTER, BRANCH_1);
        File file2 = testProject1.getOrCreateFile(iProject, "file2.ecore");
        IFile iFile2 = testProject1.getIFile(iProject, file2);
        File file22 = testProject1.getOrCreateFile(iProject, "file22.txt");
        IFile iFile22 = testProject1.getIFile(iProject, file22);
        Resource resource2 = this.connectResource(iFile2, (ResourceSet)resourceSet);
        resource2.getContents().add((Object)child);
        resource1.getContents().clear();
        resource1.getContents().add((Object)root);
        this.save(new Resource[]{resource2});
        this.save(new Resource[]{resource1});
        this.repository.addAllAndCommit("2nd-commit");
        this.repository.createBranch(MASTER, BRANCH_2);
        this.repository.reset(BRANCH_1, ResetCommand.ResetType.HARD);
        resourceSet.getResources().clear();
        resource1 = resourceSet.getResource(URI.createPlatformResourceURI((String)iFile1.getFullPath().toString(), (boolean)true), true);
        root = (EPackage)resource1.getContents().get(0);
        child = (EPackage)root.getESubpackages().get(0);
        child.setName("newChild");
        this.save(new Resource[]{resource1});
        this.repository.addAllAndCommit("3rd-commit");
        this.repository.createBranch(MASTER, BRANCH_3);
        this.repository.mergeLogicalWithNewCommit(BRANCH_2);
        Assert.assertTrue((boolean)this.repository.status().getConflicting().isEmpty());
        Assert.assertTrue((boolean)iProject.isAccessible());
        Assert.assertTrue((boolean)iFile1.exists());
        Assert.assertTrue((boolean)iFile2.exists());
        Assert.assertTrue((boolean)iFile22.exists());
        resourceSet.getResources().clear();
        resource1 = resourceSet.getResource(URI.createPlatformResourceURI((String)iFile1.getFullPath().toString(), (boolean)true), true);
        resource2 = resourceSet.getResource(URI.createFileURI((String)file2.getAbsolutePath()), true);
        resource2.setURI(URI.createPlatformResourceURI((String)iFile2.getFullPath().toString(), (boolean)true));
        EcoreUtil.resolveAll((ResourceSet)resourceSet);
        root = (EPackage)resource1.getContents().get(0);
        Assert.assertEquals((Object)"parent", (Object)root.getName());
        child = (EPackage)root.getESubpackages().get(0);
        Assert.assertEquals((Object)"newChild", (Object)child.getName());
        Assert.assertSame((Object)resource2, (Object)((InternalEObject)child).eDirectResource());
        EClass testC1 = (EClass)child.getEClassifiers().get(0);
        Assert.assertEquals((Object)"C1", (Object)testC1.getName());
        testProject1.dispose();
    }

    @Test
    public void testCollaborativeModeling_UseCase009_MergeFragmentFromLocalProject() throws Exception {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        File workingDirectory = this.repository.getRepository().getWorkTree();
        TestProject testProject1 = new TestProject("Project1", workingDirectory.getAbsolutePath());
        IProject iProject = testProject1.getProject();
        this.repository.connect(iProject);
        File file1 = testProject1.getOrCreateFile(iProject, "file1.ecore");
        IFile iFile1 = testProject1.getIFile(iProject, file1);
        Resource resource1 = this.connectResource(iFile1, (ResourceSet)resourceSet);
        EPackage root = this.createPackage(null, "parent");
        EPackage child = this.createPackage(root, "child");
        this.createClass(child, "C1");
        resource1.getContents().add((Object)root);
        this.save(new Resource[]{resource1});
        this.repository.addAllAndCommit("1st-commit");
        this.repository.createBranch(MASTER, BRANCH_1);
        child.setName("newChild");
        this.save(new Resource[]{resource1});
        this.repository.addAllAndCommit("2nd-commit");
        this.repository.createBranch(MASTER, BRANCH_2);
        this.repository.reset(BRANCH_1, ResetCommand.ResetType.HARD);
        resourceSet.getResources().clear();
        TestProject testProject2 = new TestProject("Project2", workingDirectory.getAbsolutePath());
        IProject iProject2 = testProject2.getProject();
        this.repository.connect(iProject2);
        File file2 = testProject2.getOrCreateFile(iProject2, "file2.ecore");
        IFile iFile2 = testProject2.getIFile(iProject2, file2);
        File file22 = testProject2.getOrCreateFile(iProject2, "file22.txt");
        IFile iFile22 = testProject2.getIFile(iProject2, file22);
        Resource resource2 = this.connectResource(iFile2, (ResourceSet)resourceSet);
        child.setName("child");
        resource2.getContents().add((Object)child);
        this.save(new Resource[]{resource2});
        this.save(new Resource[]{resource1});
        this.repository.addAllAndCommit("3rd-commit");
        this.repository.createBranch(MASTER, BRANCH_3);
        this.repository.mergeLogicalWithNewCommit(BRANCH_2);
        Assert.assertTrue((boolean)this.repository.status().getConflicting().isEmpty());
        Assert.assertTrue((boolean)iProject.isAccessible());
        Assert.assertTrue((boolean)iProject2.isAccessible());
        Assert.assertTrue((boolean)iFile1.exists());
        Assert.assertTrue((boolean)iFile2.exists());
        Assert.assertTrue((boolean)iFile22.exists());
        resourceSet.getResources().clear();
        resource1 = resourceSet.getResource(URI.createPlatformResourceURI((String)iFile1.getFullPath().toString(), (boolean)true), true);
        resource2 = resourceSet.getResource(URI.createPlatformResourceURI((String)iFile2.getFullPath().toString(), (boolean)true), true);
        EcoreUtil.resolveAll((ResourceSet)resourceSet);
        root = (EPackage)resource1.getContents().get(0);
        Assert.assertEquals((Object)"parent", (Object)root.getName());
        child = (EPackage)root.getESubpackages().get(0);
        Assert.assertEquals((Object)"newChild", (Object)child.getName());
        Assert.assertSame((Object)resource2, (Object)((InternalEObject)child).eDirectResource());
        EClass testC1 = (EClass)child.getEClassifiers().get(0);
        Assert.assertEquals((Object)"C1", (Object)testC1.getName());
        testProject1.dispose();
        testProject2.dispose();
    }
}

