/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.merge;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.compare.egit.internal.merge.GitResourceVariantTreeProvider;
import org.eclipse.emf.compare.egit.internal.merge.GitResourceVariantTreeSubscriber;
import org.eclipse.emf.compare.egit.internal.merge.TreeWalkResourceVariantTreeProvider;
import org.eclipse.emf.compare.ide.ui.tests.merge.VariantsTestCase;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.NameConflictTreeWalk;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.diff.ITwoWayDiff;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.mapping.provider.ResourceDiff;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GitResourceVariantTreeSubscriberTest
extends VariantsTestCase {
    private static final String BRANCH_CHANGES = "branch changes\n";
    private static final String MASTER_CHANGES = "\nsome changes";
    private static final String BASE = "base";
    private File file1;
    private File file2;
    private IFile iFile1;
    private IFile iFile2;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.file1 = this.repository.createFile(this.iProject, "file1");
        this.file2 = this.repository.createFile(this.iProject, "file2");
        this.iFile1 = this.repository.getIFile(this.iProject, this.file1);
        this.iFile2 = this.repository.getIFile(this.iProject, this.file2);
    }

    @Test
    public void testSubscriber() throws Exception {
        GitResourceVariantTreeProvider provider = this.createTreeProvider();
        GitResourceVariantTreeSubscriber subscriber = new GitResourceVariantTreeSubscriber(provider);
        Assert.assertTrue((boolean)subscriber.isSupervised((IResource)this.iProject));
        Assert.assertTrue((boolean)subscriber.isSupervised((IResource)this.iFile1));
        Assert.assertTrue((boolean)subscriber.isSupervised((IResource)this.iFile2));
        Assert.assertSame((Object)provider.getBaseTree(), (Object)subscriber.getBaseTree());
        Assert.assertSame((Object)provider.getRemoteTree(), (Object)subscriber.getRemoteTree());
        Assert.assertSame((Object)provider.getSourceTree(), (Object)subscriber.getSourceTree());
        Assert.assertNotNull((Object)subscriber.getDiff((IResource)this.iProject));
        Assert.assertNotNull((Object)subscriber.getDiff((IResource)this.iFile1));
        Assert.assertNotNull((Object)subscriber.getDiff((IResource)this.iFile2));
        Assert.assertNotNull((Object)subscriber.getSyncInfo((IResource)this.iProject));
        Assert.assertNotNull((Object)subscriber.getSyncInfo((IResource)this.iFile1));
        Assert.assertNotNull((Object)subscriber.getSyncInfo((IResource)this.iFile2));
    }

    @Test
    public void testSyncInfo() throws Exception {
        GitResourceVariantTreeProvider provider = this.createTreeProvider();
        GitResourceVariantTreeSubscriber subscriber = new GitResourceVariantTreeSubscriber(provider);
        SyncInfo projectInfo = subscriber.getSyncInfo((IResource)this.iProject);
        Assert.assertNotNull((Object)projectInfo);
        Assert.assertEquals((long)15L, (long)projectInfo.getKind());
        SyncInfo syncInfo1 = subscriber.getSyncInfo((IResource)this.iFile1);
        Assert.assertNotNull((Object)syncInfo1);
        Assert.assertEquals((long)7L, (long)syncInfo1.getKind());
        IResourceVariant baseVariant1 = syncInfo1.getBase();
        IResourceVariant remoteVariant1 = syncInfo1.getRemote();
        this.assertContentEquals(baseVariant1, "some content for the first file");
        this.assertContentEquals(remoteVariant1, "some content for the first file");
        SyncInfo syncInfo2 = subscriber.getSyncInfo((IResource)this.iFile2);
        Assert.assertNotNull((Object)syncInfo2);
        Assert.assertEquals((long)11L, (long)syncInfo2.getKind());
        IResourceVariant baseVariant2 = syncInfo2.getBase();
        IResourceVariant remoteVariant2 = syncInfo2.getRemote();
        this.assertContentEquals(baseVariant2, "some content for the second file");
        this.assertContentEquals(remoteVariant2, "branch changes\nsome content for the second file");
    }

    @Test
    public void testDiff() throws Exception {
        GitResourceVariantTreeProvider provider = this.createTreeProvider();
        GitResourceVariantTreeSubscriber subscriber = new GitResourceVariantTreeSubscriber(provider);
        IDiff diff1 = subscriber.getDiff((IResource)this.iFile1);
        Assert.assertTrue((boolean)(diff1 instanceof IThreeWayDiff));
        Assert.assertEquals((long)4L, (long)diff1.getKind());
        Assert.assertEquals((long)256L, (long)((IThreeWayDiff)diff1).getDirection());
        ITwoWayDiff localDiff1 = ((IThreeWayDiff)diff1).getLocalChange();
        ITwoWayDiff remoteDiff1 = ((IThreeWayDiff)diff1).getRemoteChange();
        Assert.assertNull((Object)remoteDiff1);
        Assert.assertTrue((boolean)(localDiff1 instanceof ResourceDiff));
        IFileRevision localState1 = ((ResourceDiff)localDiff1).getAfterState();
        IFileRevision baseState1 = ((ResourceDiff)localDiff1).getBeforeState();
        Assert.assertNotNull((Object)localState1);
        Assert.assertNotNull((Object)baseState1);
        Assert.assertTrue((boolean)this.iFile1.getName().equals(localState1.getName()));
        Assert.assertTrue((boolean)this.iFile1.getName().equals(baseState1.getName()));
        IStorage localStorage1 = localState1.getStorage((IProgressMonitor)new NullProgressMonitor());
        IStorage baseStorage1 = baseState1.getStorage((IProgressMonitor)new NullProgressMonitor());
        this.assertContentEquals(localStorage1, "some content for the first file\nsome changes");
        this.assertContentEquals(baseStorage1, "some content for the first file");
        IDiff diff2 = subscriber.getDiff((IResource)this.iFile2);
        Assert.assertTrue((boolean)(diff2 instanceof IThreeWayDiff));
        Assert.assertEquals((long)4L, (long)diff2.getKind());
        Assert.assertEquals((long)512L, (long)((IThreeWayDiff)diff2).getDirection());
        ITwoWayDiff localDiff2 = ((IThreeWayDiff)diff2).getLocalChange();
        ITwoWayDiff remoteDiff2 = ((IThreeWayDiff)diff2).getRemoteChange();
        Assert.assertTrue((boolean)(remoteDiff2 instanceof ResourceDiff));
        Assert.assertNull((Object)localDiff2);
        IFileRevision remoteState2 = ((ResourceDiff)remoteDiff2).getAfterState();
        IFileRevision ancestorState2 = ((ResourceDiff)remoteDiff2).getBeforeState();
        Assert.assertTrue((boolean)this.iFile2.getName().equals(ancestorState2.getName()));
        Assert.assertTrue((boolean)this.iFile2.getName().equals(remoteState2.getName()));
        IStorage ancestorStorage2 = ancestorState2.getStorage((IProgressMonitor)new NullProgressMonitor());
        IStorage remoteStorage2 = remoteState2.getStorage((IProgressMonitor)new NullProgressMonitor());
        this.assertContentEquals(ancestorStorage2, "some content for the second file");
        this.assertContentEquals(remoteStorage2, "branch changes\nsome content for the second file");
    }

    @Test
    public void testAddLocalAndRemote() throws Exception {
        GitResourceVariantTreeProvider provider = this.createTreeProviderWithAdditions();
        GitResourceVariantTreeSubscriber subscriber = new GitResourceVariantTreeSubscriber(provider);
        IDiff diff1 = subscriber.getDiff((IResource)this.iFile1);
        Assert.assertTrue((boolean)(diff1 instanceof IThreeWayDiff));
        Assert.assertEquals((long)1L, (long)diff1.getKind());
        Assert.assertEquals((long)256L, (long)((IThreeWayDiff)diff1).getDirection());
        ITwoWayDiff localDiff1 = ((IThreeWayDiff)diff1).getLocalChange();
        ITwoWayDiff remoteDiff1 = ((IThreeWayDiff)diff1).getRemoteChange();
        Assert.assertTrue((boolean)(localDiff1 instanceof ResourceDiff));
        Assert.assertNull((Object)remoteDiff1);
        IFileRevision ancestorState1 = ((ResourceDiff)localDiff1).getBeforeState();
        IFileRevision localState1 = ((ResourceDiff)localDiff1).getAfterState();
        Assert.assertTrue((boolean)this.iFile1.getName().equals(localState1.getName()));
        Assert.assertNull((Object)ancestorState1);
        IStorage localStorage1 = localState1.getStorage((IProgressMonitor)new NullProgressMonitor());
        this.assertContentEquals(localStorage1, "some content for the first file");
        IDiff diff2 = subscriber.getDiff((IResource)this.iFile2);
        Assert.assertTrue((boolean)(diff2 instanceof IThreeWayDiff));
        Assert.assertEquals((long)1L, (long)diff2.getKind());
        Assert.assertEquals((long)512L, (long)((IThreeWayDiff)diff2).getDirection());
        ITwoWayDiff localDiff2 = ((IThreeWayDiff)diff2).getLocalChange();
        ITwoWayDiff remoteDiff2 = ((IThreeWayDiff)diff2).getRemoteChange();
        Assert.assertTrue((boolean)(remoteDiff2 instanceof ResourceDiff));
        Assert.assertNull((Object)localDiff2);
        IFileRevision ancestorState2 = ((ResourceDiff)remoteDiff2).getBeforeState();
        IFileRevision remoteState2 = ((ResourceDiff)remoteDiff2).getAfterState();
        Assert.assertNull((Object)ancestorState2);
        Assert.assertTrue((boolean)this.iFile2.getName().equals(remoteState2.getName()));
        IStorage remoteStorage2 = remoteState2.getStorage((IProgressMonitor)new NullProgressMonitor());
        this.assertContentEquals(remoteStorage2, "some content for the second file");
    }

    @Test
    public void testRemoveLocalAndRemote() throws Exception {
        GitResourceVariantTreeProvider provider = this.createTreeProviderWithDeletions();
        GitResourceVariantTreeSubscriber subscriber = new GitResourceVariantTreeSubscriber(provider);
        IDiff diff1 = subscriber.getDiff((IResource)this.iFile1);
        Assert.assertTrue((boolean)(diff1 instanceof IThreeWayDiff));
        Assert.assertEquals((long)2L, (long)diff1.getKind());
        Assert.assertEquals((long)256L, (long)((IThreeWayDiff)diff1).getDirection());
        ITwoWayDiff localDiff1 = ((IThreeWayDiff)diff1).getLocalChange();
        ITwoWayDiff remoteDiff1 = ((IThreeWayDiff)diff1).getRemoteChange();
        Assert.assertTrue((boolean)(localDiff1 instanceof ResourceDiff));
        Assert.assertNull((Object)remoteDiff1);
        IFileRevision ancestorState1 = ((ResourceDiff)localDiff1).getBeforeState();
        IFileRevision localState1 = ((ResourceDiff)localDiff1).getAfterState();
        Assert.assertTrue((boolean)this.iFile1.getName().equals(ancestorState1.getName()));
        Assert.assertNull((Object)localState1);
        IStorage ancestorStorage1 = ancestorState1.getStorage((IProgressMonitor)new NullProgressMonitor());
        this.assertContentEquals(ancestorStorage1, "some content for the first file");
        IDiff diff2 = subscriber.getDiff((IResource)this.iFile2);
        Assert.assertTrue((boolean)(diff2 instanceof IThreeWayDiff));
        Assert.assertEquals((long)2L, (long)diff2.getKind());
        Assert.assertEquals((long)512L, (long)((IThreeWayDiff)diff2).getDirection());
        ITwoWayDiff localDiff2 = ((IThreeWayDiff)diff2).getLocalChange();
        ITwoWayDiff remoteDiff2 = ((IThreeWayDiff)diff2).getRemoteChange();
        Assert.assertTrue((boolean)(remoteDiff2 instanceof ResourceDiff));
        Assert.assertNull((Object)localDiff2);
        IFileRevision ancestorState2 = ((ResourceDiff)remoteDiff2).getBeforeState();
        IFileRevision remoteState2 = ((ResourceDiff)remoteDiff2).getAfterState();
        Assert.assertTrue((boolean)this.iFile2.getName().equals(ancestorState2.getName()));
        Assert.assertNull((Object)remoteState2);
        IStorage rancestorStorage2 = ancestorState2.getStorage((IProgressMonitor)new NullProgressMonitor());
        this.assertContentEquals(rancestorStorage2, "some content for the second file");
    }

    private GitResourceVariantTreeProvider createTreeProvider() throws Exception {
        this.repository.appendContentAndCommit(this.iProject, this.file1, "some content for the first file", "first file - initial commit");
        this.repository.appendContentAndCommit(this.iProject, this.file2, "some content for the second file", "second file - initial commit");
        this.repository.createBranch("refs/heads/master", BASE);
        this.repository.createAndCheckoutBranch("refs/heads/master", "refs/heads/branch");
        this.setContentsAndCommit(this.repository, this.iFile2, "branch changes\nsome content for the second file", "branch commit");
        this.repository.checkoutBranch("refs/heads/master");
        this.setContentsAndCommit(this.repository, this.iFile1, "some content for the first file\nsome changes", "master commit");
        this.iProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        try (RevWalk walk = new RevWalk(this.repo);){
            RevTree baseTree = walk.parseTree((AnyObjectId)this.repo.resolve(BASE));
            RevTree sourceTree = walk.parseTree((AnyObjectId)this.repo.resolve("refs/heads/master"));
            RevTree remoteTree = walk.parseTree((AnyObjectId)this.repo.resolve("refs/heads/branch"));
            NameConflictTreeWalk treeWalk = new NameConflictTreeWalk(this.repo);
            int baseTreeIteratorIndex = treeWalk.addTree((AnyObjectId)baseTree);
            treeWalk.addTree((AnyObjectId)sourceTree);
            treeWalk.addTree((AnyObjectId)remoteTree);
            TreeWalkResourceVariantTreeProvider treeWalkResourceVariantTreeProvider = new TreeWalkResourceVariantTreeProvider.Builder().setRepository(this.repo).setaBaseTree(treeWalk.getTree(baseTreeIteratorIndex, AbstractTreeIterator.class)).setHeadTree(sourceTree).setMergeTree(remoteTree).setDircache(this.repo.readDirCache()).setReader(this.repo.newObjectReader()).build();
            return treeWalkResourceVariantTreeProvider;
        }
    }

    private GitResourceVariantTreeProvider createTreeProviderWithAdditions() throws Exception {
        this.repository.createBranch("refs/heads/master", BASE);
        this.repository.createAndCheckoutBranch("refs/heads/master", "refs/heads/branch");
        this.file2 = this.repository.createFile(this.iProject, "file2");
        this.repository.appendContentAndCommit(this.iProject, this.file2, "some content for the second file", "Creation of file2 in branch2.");
        this.repository.checkoutBranch("refs/heads/master");
        this.file1 = this.repository.createFile(this.iProject, "file1");
        this.repository.appendContentAndCommit(this.iProject, this.file1, "some content for the first file", "Creation of file1 in branch1.");
        this.iProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        try (RevWalk walk = new RevWalk(this.repo);){
            RevTree baseTree = walk.parseTree((AnyObjectId)this.repo.resolve(BASE));
            RevTree sourceTree = walk.parseTree((AnyObjectId)this.repo.resolve("refs/heads/master"));
            RevTree remoteTree = walk.parseTree((AnyObjectId)this.repo.resolve("refs/heads/branch"));
            NameConflictTreeWalk treeWalk = new NameConflictTreeWalk(this.repo);
            int baseTreeIteratorIndex = treeWalk.addTree((AnyObjectId)baseTree);
            treeWalk.addTree((AnyObjectId)sourceTree);
            treeWalk.addTree((AnyObjectId)remoteTree);
            TreeWalkResourceVariantTreeProvider treeWalkResourceVariantTreeProvider = new TreeWalkResourceVariantTreeProvider.Builder().setRepository(this.repo).setaBaseTree(treeWalk.getTree(baseTreeIteratorIndex, AbstractTreeIterator.class)).setHeadTree(sourceTree).setMergeTree(remoteTree).setDircache(this.repo.readDirCache()).setReader(this.repo.newObjectReader()).build();
            return treeWalkResourceVariantTreeProvider;
        }
    }

    private GitResourceVariantTreeProvider createTreeProviderWithDeletions() throws Exception {
        this.file1 = this.repository.createFile(this.iProject, "file1");
        this.repository.appendContentAndCommit(this.iProject, this.file1, "some content for the first file", "Creation of file1 in branch1.");
        this.file2 = this.repository.createFile(this.iProject, "file2");
        this.repository.appendContentAndCommit(this.iProject, this.file2, "some content for the second file", "Creation of file2 in branch2.");
        this.repository.createBranch("refs/heads/master", BASE);
        this.repository.createAndCheckoutBranch("refs/heads/master", "refs/heads/branch");
        this.repository.untrack(this.file2);
        this.repository.commit("Removed file2 in branch.");
        this.repository.checkoutBranch("refs/heads/master");
        this.repository.untrack(this.file1);
        this.repository.commit("Removed file1 in master.");
        this.iProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        try (RevWalk walk = new RevWalk(this.repo);){
            RevTree baseTree = walk.parseTree((AnyObjectId)this.repo.resolve(BASE));
            RevTree sourceTree = walk.parseTree((AnyObjectId)this.repo.resolve("refs/heads/master"));
            RevTree remoteTree = walk.parseTree((AnyObjectId)this.repo.resolve("refs/heads/branch"));
            NameConflictTreeWalk treeWalk = new NameConflictTreeWalk(this.repo);
            int baseTreeIteratorIndex = treeWalk.addTree((AnyObjectId)baseTree);
            treeWalk.addTree((AnyObjectId)sourceTree);
            treeWalk.addTree((AnyObjectId)remoteTree);
            TreeWalkResourceVariantTreeProvider treeWalkResourceVariantTreeProvider = new TreeWalkResourceVariantTreeProvider.Builder().setRepository(this.repo).setaBaseTree(treeWalk.getTree(baseTreeIteratorIndex, AbstractTreeIterator.class)).setHeadTree(sourceTree).setMergeTree(remoteTree).setDircache(this.repo.readDirCache()).setReader(this.repo.newObjectReader()).build();
            return treeWalkResourceVariantTreeProvider;
        }
    }
}

