/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.impl.DifferenceFilterManager;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.filters.IDeactivableDiffFilter;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.filters.IDifferenceFilter;
import org.eclipse.emf.compare.scope.IComparisonScope;

public class DifferenceFilterRegistryImpl
implements IDifferenceFilter.Registry {
    private final DifferenceFilterManager filterManager;

    public DifferenceFilterRegistryImpl(DifferenceFilterManager filterManager) {
        this.filterManager = filterManager;
    }

    public List<IDifferenceFilter> getFilters(IComparisonScope scope, Comparison comparison) {
        Set<IDifferenceFilter> filtersEnabledByDefault = this.filterManager.getCurrentByDefaultFilters();
        Collection<IDeactivableDiffFilter> inactiveFilters = this.filterManager.getCurrentInactiveFilters();
        Iterable matchingFilters = Iterables.filter(this.filterManager.getAllFilters(), DifferenceFilterRegistryImpl.isFilterActivable(scope, comparison));
        for (IDifferenceFilter filter : matchingFilters) {
            if (filtersEnabledByDefault.contains(filter)) {
                filter.setDefaultSelected(true);
            } else {
                filter.setDefaultSelected(false);
            }
            if (inactiveFilters.contains(filter)) {
                ((IDeactivableDiffFilter)filter).setActive(false);
                continue;
            }
            if (!(filter instanceof IDeactivableDiffFilter)) continue;
            ((IDeactivableDiffFilter)filter).setActive(true);
        }
        return Lists.newArrayList((Iterable)matchingFilters);
    }

    static final Predicate<IDifferenceFilter> isFilterActivable(final IComparisonScope scope, final Comparison comparison) {
        return new Predicate<IDifferenceFilter>(){

            public boolean apply(IDifferenceFilter d) {
                return d.isEnabled(scope, comparison);
            }
        };
    }

    @Override
    public IDifferenceFilter add(IDifferenceFilter filter) {
        Preconditions.checkNotNull((Object)filter);
        return this.filterManager.add(filter);
    }

    @Override
    public IDifferenceFilter remove(String className) {
        return this.filterManager.remove(className);
    }

    @Override
    public void clear() {
        this.filterManager.clear();
    }
}

