/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.scope;

import java.io.IOException;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope2;
import org.eclipse.emf.compare.tests.fullcomparison.data.identifier.IdentifierMatchInputData;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.junit.Assert;
import org.junit.Test;

public class ComparisonScopeAdapterTest {
    private static final URI TEST_URI_1 = URI.createURI((String)"test_uri_1");
    private static final URI TEST_URI_2 = URI.createURI((String)"test_uri_2");

    @Test
    public void testAccessingScopeFromComparison() throws IOException {
        IdentifierMatchInputData mockModel = new IdentifierMatchInputData();
        Resource left = mockModel.getExtlibraryLeft();
        Resource right = mockModel.getExtlibraryRight();
        Resource origin = mockModel.getExtlibraryOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        scope.getAllInvolvedResourceURIs().add(TEST_URI_1);
        scope.getAllInvolvedResourceURIs().add(TEST_URI_2);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        IComparisonScope2 comparisonScope = this.adaptToComparisonScope(comparison);
        Assert.assertNotNull((Object)comparisonScope);
        Assert.assertTrue((boolean)comparisonScope.getAllInvolvedResourceURIs().contains(TEST_URI_1));
        Assert.assertTrue((boolean)comparisonScope.getAllInvolvedResourceURIs().contains(TEST_URI_2));
    }

    private IComparisonScope2 adaptToComparisonScope(Comparison comparison) {
        return (IComparisonScope2)EcoreUtil.getAdapter((List)comparison.eAdapters(), IComparisonScope2.class);
    }
}

