/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.merge;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.merge.BatchMerger;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.merge.ThreeWayAttributeMergeScenario;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.Assert;
import org.junit.Test;

public class MultiLineAttributeMergeTest {
    private static final String NL = "\n";
    private IMerger.Registry mergerRegistry = IMerger.RegistryImpl.createStandaloneInstance();

    @Test
    public void changeSingleLineTextOnOneSide() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?";
        String left = "They don't call it a Quarter Pounder with Cheese?";
        String right = "They do not call it a Quarter Pounder with Cheese?";
        String merged = "They do not call it a Quarter Pounder with Cheese?";
        this.assertRejectedAndMergedBidirectional("They don't call it a Quarter Pounder with Cheese?", "They don't call it a Quarter Pounder with Cheese?", "They do not call it a Quarter Pounder with Cheese?", "They do not call it a Quarter Pounder with Cheese?");
    }

    @Test
    public void addSingleLineTextOnOneSide() throws IOException {
        String origin = "";
        String left = "They don't call it a Quarter Pounder with Cheese?";
        String right = "";
        String merged = "They don't call it a Quarter Pounder with Cheese?";
        this.assertRejectedAndMergedBidirectional("", "They don't call it a Quarter Pounder with Cheese?", "", "They don't call it a Quarter Pounder with Cheese?");
    }

    @Test
    public void unsetSingleLineTextOnOneSide() throws IOException {
        String right;
        String origin = "They don't call it a Quarter Pounder with Cheese?";
        String left = "They don't call it a Quarter Pounder with Cheese?";
        String merged = right = null;
        this.assertRejectedAndMergedBidirectional("They don't call it a Quarter Pounder with Cheese?", "They don't call it a Quarter Pounder with Cheese?", right, merged);
    }

    @Test
    public void removeSingleLineTextOnOneSide() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?";
        String left = "They don't call it a Quarter Pounder with Cheese?";
        String right = "";
        String merged = null;
        this.assertRejectedAndMergedBidirectional("They don't call it a Quarter Pounder with Cheese?", "They don't call it a Quarter Pounder with Cheese?", "", merged);
    }

    @Test
    public void changeAndRemoveLinesInMultiLineTextOnOneSide() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.";
        String left = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.";
        String right = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat _do_ they call it?\nThey call it a Royale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.";
        String merged = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat _do_ they call it?\nThey call it a Royale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.";
        this.assertRejectedAndMergedBidirectional("They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat _do_ they call it?\nThey call it a Royale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat _do_ they call it?\nThey call it a Royale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.");
    }

    @Test
    public void changeAndRemoveDifferentLinesInMultiLineOnTextBothSides() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.";
        String left = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a \"Big Mac\"?";
        String right = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat _do_ they call it?\nThey call it a Royale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.";
        String merged = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat _do_ they call it?\nThey call it a Royale with Cheese.\nThat's right.\nWhat do they call a \"Big Mac\"?";
        this.assertRejectedAndMergedBidirectional("They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat do they call it?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a \"Big Mac\"?", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat _do_ they call it?\nThey call it a Royale with Cheese.\nThat's right.\nWhat do they call a Big Mac?\nA Big Mac's a Big Mac, but they call it Le Big Mac.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nWhat _do_ they call it?\nThey call it a Royale with Cheese.\nThat's right.\nWhat do they call a \"Big Mac\"?");
    }

    @Test
    public void addDifferentLineAtDifferentLineInMultiLineText() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.";
        String left = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.";
        String right = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?";
        String merged = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?";
        this.assertRejectedAndMergedBidirectional("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system, they wouldn't know what a Quarter Pounder is.\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?");
    }

    @Test
    public void acceptingLeftInsertOnRightSideAndRejectingRightInsertOnRightSideAfterwards() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.";
        String left = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system.\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.";
        String right = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nWhat do they call a Big Mac?\nThat's right.";
        this.assertAcceptingLeftOnRightSideAndRejectingRightOnRightSideIsLeftValue("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system.\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nWhat do they call a Big Mac?\nThat's right.");
        this.assertAcceptingRightOnLeftSideAndRejectingLeftOnLeftSideIsRightValue("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nWhat do they call a Big Mac?\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system.\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.");
    }

    @Test
    public void acceptingLeftInsertOnRightSideAndRejectingRightDeleteOnRightSideAfterwards() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.";
        String left = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system.\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.";
        String right = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nThat's right.";
        this.assertAcceptingLeftOnRightSideAndRejectingRightOnRightSideIsLeftValue("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system.\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nThat's right.");
        this.assertAcceptingRightOnLeftSideAndRejectingLeftOnLeftSideIsRightValue("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system.\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.");
    }

    @Test
    public void acceptingLeftInsertOnRightSideAndRejectingRightChangeOnRightSideAfterwards() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.";
        String left = "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system.\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.";
        String right = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right!!!!";
        this.assertAcceptingLeftOnRightSideAndRejectingRightOnRightSideIsLeftValue("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system.\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right!!!!");
        this.assertAcceptingRightOnLeftSideAndRejectingLeftOnLeftSideIsRightValue("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right!!!!", "They don't call it a Quarter Pounder with Cheese?\nNah, they got the metric system.\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.");
    }

    @Test
    public void acceptingLeftChangeOnRightSideAndRejectingRightInsertOnRightSideAfterwards() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.";
        String left = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese!!!\nRoyale with Cheese.\nThat's right.";
        String right = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nWhat do they call a Big Mac?\nThat's right.";
        this.assertAcceptingLeftOnRightSideAndRejectingRightOnRightSideIsLeftValue("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese!!!\nRoyale with Cheese.\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nWhat do they call a Big Mac?\nThat's right.");
        this.assertAcceptingRightOnLeftSideAndRejectingLeftOnLeftSideIsRightValue("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nWhat do they call a Big Mac?\nThat's right.", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese!!!\nRoyale with Cheese.\nThat's right.");
    }

    @Test
    public void acceptingLeftChangeOnRightSideAndRejectingRightDeleteOnRightSideAfterwards() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?";
        String left = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese!!!\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?";
        String right = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nWhat do they call a Big Mac?";
        this.assertAcceptingLeftOnRightSideAndRejectingRightOnRightSideIsLeftValue("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese!!!\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nWhat do they call a Big Mac?");
        this.assertAcceptingRightOnLeftSideAndRejectingLeftOnLeftSideIsRightValue("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nWhat do they call a Big Mac?", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese!!!\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?");
    }

    @Test
    public void acceptingLeftChangeOnRightSideAndRejectingRightChangeOnRightSideAfterwards() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?";
        String left = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese!!!\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?";
        String right = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?????";
        this.assertAcceptingLeftOnRightSideAndRejectingRightOnRightSideIsLeftValue("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese!!!\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?????");
        this.assertAcceptingRightOnLeftSideAndRejectingLeftOnLeftSideIsRightValue("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?????", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese!!!\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?");
    }

    @Test
    public void acceptingLeftDeleteOnRightSideAndRejectingRightInsertOnRightSideAfterwards() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?";
        String left = "They don't call it a Quarter Pounder with Cheese?\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?";
        String right = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nThat's freaking right.\nWhat do they call a Big Mac?";
        this.assertAcceptingLeftOnRightSideAndRejectingRightOnRightSideIsLeftValue("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?", "They don't call it a Quarter Pounder with Cheese?\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nThat's freaking right.\nWhat do they call a Big Mac?");
        this.assertAcceptingRightOnLeftSideAndRejectingLeftOnLeftSideIsRightValue("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nThat's freaking right.\nWhat do they call a Big Mac?", "They don't call it a Quarter Pounder with Cheese?\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?");
    }

    @Test
    public void acceptingLeftDeleteOnRightSideAndRejectingRightChangeOnRightSideAfterwards() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?";
        String left = "They don't call it a Quarter Pounder with Cheese?\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?";
        String right = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?????";
        this.assertAcceptingLeftOnRightSideAndRejectingRightOnRightSideIsLeftValue("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?", "They don't call it a Quarter Pounder with Cheese?\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?????");
        this.assertAcceptingRightOnLeftSideAndRejectingLeftOnLeftSideIsRightValue("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?????", "They don't call it a Quarter Pounder with Cheese?\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?");
    }

    @Test
    public void acceptingLeftDeleteOnRightSideAndRejectingRightDeleteOnRightSideAfterwards() throws IOException {
        String origin = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?";
        String left = "They don't call it a Quarter Pounder with Cheese?\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?";
        String right = "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nWhat do they call a Big Mac?";
        this.assertAcceptingLeftOnRightSideAndRejectingRightOnRightSideIsLeftValue("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?", "They don't call it a Quarter Pounder with Cheese?\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nWhat do they call a Big Mac?");
        this.assertAcceptingRightOnLeftSideAndRejectingLeftOnLeftSideIsRightValue("They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?", "They don't call it a Quarter Pounder with Cheese?\nThey call it a Royale with Cheese.\nRoyale with Cheese.\nWhat do they call a Big Mac?", "They don't call it a Quarter Pounder with Cheese?\nRoyale with Cheese.\nThat's right.\nWhat do they call a Big Mac?");
    }

    private void assertAcceptingLeftOnRightSideAndRejectingRightOnRightSideIsLeftValue(String origin, String left, String right) throws IOException {
        ThreeWayAttributeMergeScenario scenario = this.createMergeScenario(origin, left, right);
        Comparison comparison = this.compare(scenario);
        this.acceptLeft(comparison);
        this.rejectRight(comparison);
        String rightValue = scenario.getRightAttributeValue();
        Assert.assertEquals((Object)this.nullIfEmpty(left), (Object)this.nullIfEmpty(rightValue));
    }

    private void assertAcceptingRightOnLeftSideAndRejectingLeftOnLeftSideIsRightValue(String origin, String left, String right) throws IOException {
        ThreeWayAttributeMergeScenario scenario = this.createMergeScenario(origin, left, right);
        Comparison comparison = this.compare(scenario);
        this.acceptRight(comparison);
        this.rejectLeft(comparison);
        String leftValue = scenario.getLeftAttributeValue();
        Assert.assertEquals((Object)this.nullIfEmpty(right), (Object)this.nullIfEmpty(leftValue));
    }

    private void assertRejectedAndMergedBidirectional(String origin, String left, String right, String merged) throws IOException {
        this.assertRejectLeft(origin, left, right);
        this.assertRejectRight(origin, left, right);
        this.assertMergedLeftToRight(origin, left, right, merged);
        this.assertMergedRightToLeft(origin, left, right, merged);
    }

    private void assertRejectLeft(String origin, String left, String right) throws IOException {
        ThreeWayAttributeMergeScenario scenario = this.createMergeScenario(origin, left, right);
        Comparison comparison = this.compare(scenario);
        this.rejectLeft(comparison);
        String attributeValue = scenario.getLeftAttributeValue();
        Assert.assertEquals((Object)this.nullIfEmpty(origin), (Object)this.nullIfEmpty(attributeValue));
    }

    private void assertRejectRight(String origin, String left, String right) throws IOException {
        ThreeWayAttributeMergeScenario scenario = this.createMergeScenario(origin, left, right);
        Comparison comparison = this.compare(scenario);
        this.rejectRight(comparison);
        String attributeValue = scenario.getRightAttributeValue();
        Assert.assertEquals((Object)this.nullIfEmpty(origin), (Object)this.nullIfEmpty(attributeValue));
    }

    private void assertMergedLeftToRight(String origin, String left, String right, String merged) throws IOException {
        ThreeWayAttributeMergeScenario scenario = this.createMergeScenario(origin, left, right);
        Comparison comparison = this.compare(scenario);
        this.acceptLeft(comparison);
        String attributeValue = scenario.getRightAttributeValue();
        Assert.assertEquals((Object)this.nullIfEmpty(merged), (Object)this.nullIfEmpty(attributeValue));
    }

    private void assertMergedRightToLeft(String origin, String left, String right, String merged) throws IOException {
        ThreeWayAttributeMergeScenario scenario = this.createMergeScenario(origin, left, right);
        Comparison comparison = this.compare(scenario);
        this.acceptRight(comparison);
        String attributeValue = scenario.getLeftAttributeValue();
        Assert.assertEquals((Object)this.nullIfEmpty(merged), (Object)this.nullIfEmpty(attributeValue));
    }

    private void rejectLeft(Comparison comparison) {
        List<Diff> leftDiffs = this.getDiffsForSource((List<Diff>)comparison.getDifferences(), DifferenceSource.LEFT);
        BatchMerger merger = new BatchMerger(this.mergerRegistry);
        merger.copyAllRightToLeft(leftDiffs, (Monitor)new BasicMonitor());
    }

    private void rejectRight(Comparison comparison) {
        List<Diff> rightDiffs = this.getDiffsForSource((List<Diff>)comparison.getDifferences(), DifferenceSource.RIGHT);
        BatchMerger merger = new BatchMerger(this.mergerRegistry);
        merger.copyAllLeftToRight(rightDiffs, (Monitor)new BasicMonitor());
    }

    private void acceptRight(Comparison comparison) {
        List<Diff> rightDiffs = this.getDiffsForSource((List<Diff>)comparison.getDifferences(), DifferenceSource.RIGHT);
        BatchMerger merger = new BatchMerger(this.mergerRegistry);
        merger.copyAllRightToLeft(rightDiffs, (Monitor)new BasicMonitor());
    }

    private void acceptLeft(Comparison comparison) {
        List<Diff> leftDiffs = this.getDiffsForSource((List<Diff>)comparison.getDifferences(), DifferenceSource.LEFT);
        BatchMerger merger = new BatchMerger(this.mergerRegistry);
        merger.copyAllLeftToRight(leftDiffs, (Monitor)new BasicMonitor());
    }

    private List<Diff> getDiffsForSource(List<Diff> differences, DifferenceSource source) {
        ArrayList<Diff> diffsForSource = new ArrayList<Diff>();
        for (Diff diff : differences) {
            if (!source.equals((Object)diff.getSource())) continue;
            diffsForSource.add(diff);
        }
        return diffsForSource;
    }

    private ThreeWayAttributeMergeScenario createMergeScenario(String origin, String left, String right) throws IOException {
        return new ThreeWayAttributeMergeScenario(origin, left, right);
    }

    private Comparison compare(ThreeWayAttributeMergeScenario scenario) {
        Resource origin = scenario.getOriginResource();
        Resource left = scenario.getLeftResource();
        Resource right = scenario.getRightResource();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        return comparison;
    }

    private String nullIfEmpty(String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        return string;
    }
}

