/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.merge;

import java.util.Set;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.merge.AdditiveMergeCriterion;
import org.eclipse.emf.compare.merge.IMergeCriterion;
import org.eclipse.emf.compare.merge.ReferenceChangeMerger;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class AdditiveReferenceChangeMerger
extends ReferenceChangeMerger {
    public AdditiveReferenceChangeMerger() {
        this.mergeOptions.put("merge.criterion", AdditiveMergeCriterion.INSTANCE);
    }

    @Override
    public boolean apply(IMergeCriterion criterion) {
        return criterion == AdditiveMergeCriterion.INSTANCE;
    }

    @Override
    public void copyRightToLeft(Diff target, Monitor monitor) {
        if (AdditiveReferenceChangeMerger.isInTerminalState(target)) {
            return;
        }
        ReferenceChange rc = (ReferenceChange)target;
        if (rc.getReference().isContainment()) {
            if (rc.getSource() == DifferenceSource.RIGHT) {
                if (rc.getKind() == DifferenceKind.DELETE) {
                    this.markAsMerged(rc);
                } else {
                    super.copyRightToLeft(rc, monitor);
                }
            } else if (rc.getKind() == DifferenceKind.DELETE) {
                super.copyRightToLeft(rc, monitor);
            } else {
                this.markAsMerged(rc);
            }
        } else if (rc.getSource() == DifferenceSource.RIGHT) {
            if (rc.getKind() == DifferenceKind.DELETE || this.isUnsetRelatedToDeletion(rc)) {
                this.markAsMerged(rc);
            } else {
                super.copyRightToLeft(rc, monitor);
            }
        } else if (rc.getKind() == DifferenceKind.DELETE || this.isUnsetRelatedToDeletion(rc)) {
            super.copyRightToLeft(rc, monitor);
        } else {
            this.markAsMerged(rc);
        }
    }

    private boolean isUnsetRelatedToDeletion(ReferenceChange rc) {
        if (rc.getKind() == DifferenceKind.CHANGE && this.isUnsetOfValue(rc)) {
            for (Diff diff : rc.getRequiredBy()) {
                if (diff.getKind() != DifferenceKind.DELETE || !(diff instanceof ReferenceChange) || !((ReferenceChange)diff).getReference().isContainment()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isUnsetOfValue(ReferenceChange difference) {
        boolean isUnset = false;
        EReference reference = difference.getReference();
        if (!reference.isMany()) {
            EObject referrer = null;
            referrer = difference.getSource() == DifferenceSource.LEFT ? difference.getMatch().getLeft() : difference.getMatch().getRight();
            isUnset = referrer == null || !ReferenceUtil.safeEIsSet(referrer, (EStructuralFeature)reference);
        }
        return isUnset;
    }

    private void markAsMerged(Diff diff) {
        diff.setState(DifferenceState.MERGED);
        for (Diff refiningDiff : diff.getRefinedBy()) {
            refiningDiff.setState(DifferenceState.MERGED);
        }
    }

    @Override
    public Set<Diff> getDirectMergeDependencies(Diff diff, boolean mergeRightToLeft) {
        ReferenceChange rc = (ReferenceChange)diff;
        if (rc.getReference().isContainment()) {
            if (rc.getSource() == DifferenceSource.RIGHT) {
                if (rc.getKind() == DifferenceKind.DELETE) {
                    return super.getDirectMergeDependencies(diff, !mergeRightToLeft);
                }
                return super.getDirectMergeDependencies(diff, mergeRightToLeft);
            }
            if (rc.getKind() == DifferenceKind.DELETE) {
                return super.getDirectMergeDependencies(diff, mergeRightToLeft);
            }
            return super.getDirectMergeDependencies(diff, !mergeRightToLeft);
        }
        if (rc.getSource() == DifferenceSource.RIGHT) {
            if (rc.getKind() == DifferenceKind.DELETE || this.isUnsetRelatedToDeletion(rc)) {
                return super.getDirectMergeDependencies(diff, !mergeRightToLeft);
            }
            return super.getDirectMergeDependencies(diff, mergeRightToLeft);
        }
        if (rc.getKind() == DifferenceKind.DELETE || this.isUnsetRelatedToDeletion(rc)) {
            return super.getDirectMergeDependencies(diff, mergeRightToLeft);
        }
        return super.getDirectMergeDependencies(diff, !mergeRightToLeft);
    }

    @Override
    public Set<Diff> getDirectResultingMerges(Diff diff, boolean mergeRightToLeft) {
        ReferenceChange rc = (ReferenceChange)diff;
        if (rc.getReference().isContainment()) {
            if (rc.getSource() == DifferenceSource.RIGHT) {
                if (rc.getKind() == DifferenceKind.DELETE) {
                    return super.getDirectResultingMerges(diff, !mergeRightToLeft);
                }
                return super.getDirectResultingMerges(diff, mergeRightToLeft);
            }
            if (rc.getKind() == DifferenceKind.DELETE) {
                return super.getDirectResultingMerges(diff, mergeRightToLeft);
            }
            return super.getDirectResultingMerges(diff, !mergeRightToLeft);
        }
        if (rc.getSource() == DifferenceSource.RIGHT) {
            if (rc.getKind() == DifferenceKind.DELETE || this.isUnsetRelatedToDeletion(rc)) {
                return super.getDirectResultingMerges(diff, !mergeRightToLeft);
            }
            return super.getDirectResultingMerges(diff, mergeRightToLeft);
        }
        if (rc.getKind() == DifferenceKind.DELETE || this.isUnsetRelatedToDeletion(rc)) {
            return super.getDirectResultingMerges(diff, mergeRightToLeft);
        }
        return super.getDirectResultingMerges(diff, !mergeRightToLeft);
    }
}

