/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.match;

import java.io.IOException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.match.impl.MatchEngineFactoryImpl;
import org.eclipse.emf.compare.match.impl.MatchEngineFactoryRegistryImpl;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.fullcomparison.data.identifier.IdentifierMatchInputData;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.Assert;
import org.junit.Test;

public class MatchEngineFactoryRegistryTest {
    private IdentifierMatchInputData input = new IdentifierMatchInputData();

    @Test
    public void tesMatchEngineFactoryRegistry() throws IOException {
        Resource left = this.input.getExtlibraryLeft();
        Resource right = this.input.getExtlibraryRight();
        IMatchEngine.Factory.Registry registry = MatchEngineFactoryRegistryImpl.createStandaloneInstance();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        IMatchEngine.Factory factory = registry.getHighestRankingMatchEngineFactory((IComparisonScope)scope);
        Assert.assertTrue((boolean)(factory instanceof MatchEngineFactoryImpl));
        Assert.assertEquals((long)1L, (long)registry.getMatchEngineFactories((IComparisonScope)scope).size());
        MatchEngineFactoryTest factoryWithHighestRanking = new MatchEngineFactoryTest();
        factoryWithHighestRanking.setRanking(100);
        registry.add((IMatchEngine.Factory)factoryWithHighestRanking);
        factory = registry.getHighestRankingMatchEngineFactory((IComparisonScope)scope);
        Assert.assertFalse((boolean)(factory instanceof MatchEngineFactoryTest));
        Assert.assertEquals((long)1L, (long)registry.getMatchEngineFactories((IComparisonScope)scope).size());
        MatchEngineFactoryOtherTest factoryWithMiddleRanking = new MatchEngineFactoryOtherTest();
        factoryWithMiddleRanking.setRanking(50);
        registry.add((IMatchEngine.Factory)factoryWithMiddleRanking);
        factory = registry.getHighestRankingMatchEngineFactory((IComparisonScope)scope);
        Assert.assertTrue((boolean)(factory instanceof MatchEngineFactoryOtherTest));
        Assert.assertEquals((long)2L, (long)registry.getMatchEngineFactories((IComparisonScope)scope).size());
    }

    private class MatchEngineFactoryOtherTest
    extends MatchEngineFactoryImpl {
        private MatchEngineFactoryOtherTest() {
        }

        public boolean isMatchEngineFactoryFor(IComparisonScope scope) {
            return true;
        }
    }

    private class MatchEngineFactoryTest
    extends MatchEngineFactoryImpl {
        private MatchEngineFactoryTest() {
        }

        public boolean isMatchEngineFactoryFor(IComparisonScope scope) {
            return false;
        }
    }
}

