/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.jpox.elist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.teneo.jpox.elist.EListWrapper;
import org.jpox.StateManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMapWrapper<K, V>
extends EListWrapper<Map.Entry<K, V>>
implements EMap<K, V> {
    private static final long serialVersionUID = -6719775217240311479L;

    public EMapWrapper(StateManager ownerSM, String fieldName) {
        super(ownerSM, fieldName, new ArrayList());
    }

    public EMapWrapper(StateManager ownerSM, String fieldName, List<Map.Entry<K, V>> list) {
        super(ownerSM, fieldName, list);
    }

    public boolean containsKey(Object arg0) {
        return this.get(arg0) != null;
    }

    public boolean containsValue(Object arg0) {
        for (V v : this.values()) {
            if (!v.equals(arg0)) continue;
            return true;
        }
        return false;
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return new HashSet<Map.Entry<K, V>>(this);
    }

    public V get(Object arg0) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            BasicEMap.Entry entry = (BasicEMap.Entry)it.next();
            if (!arg0.equals(entry.getKey())) continue;
            return (V)entry.getValue();
        }
        return null;
    }

    public int indexOfKey(Object arg0) {
        V entry = this.get(arg0);
        return this.indexOf(entry);
    }

    public Set<K> keySet() {
        TreeSet<K> set = new TreeSet<K>();
        for (Map.Entry<K, V> e : this.entrySet()) {
            set.add(e.getKey());
        }
        return set;
    }

    public Map<K, V> map() {
        return new DelegatingMap();
    }

    public V put(K key, V value) {
        Map.Entry e = (Map.Entry)this.get(this.indexOfKey(key));
        if (e != null) {
            e.setValue(value);
            return value;
        }
        this.add(this.newEntry(key, value));
        return value;
    }

    public void putAll(EMap<? extends K, ? extends V> arg0) {
        this.putAll(arg0.map());
    }

    public void putAll(Map<? extends K, ? extends V> arg0) {
        this.load();
        this.addAll(Arrays.asList(arg0.entrySet().toArray()));
    }

    public V removeKey(Object arg0) {
        this.load();
        for (Map.Entry<K, V> e : this.entrySet()) {
            if (!arg0.equals(e.getKey())) continue;
            this.remove(e);
            return e.getValue();
        }
        return null;
    }

    public Collection<V> values() {
        ArrayList<V> result = new ArrayList<V>();
        for (Map.Entry<K, V> e : this.entrySet()) {
            result.add(e.getValue());
        }
        return result;
    }

    protected Map.Entry<K, V> newEntry(K key, V value) {
        EClass entryEClass = (EClass)this.getEStructuralFeature().getEType();
        BasicEMap.Entry entry = (BasicEMap.Entry)entryEClass.getEPackage().getEFactoryInstance().create(entryEClass);
        entry.setHash(key == null ? 0 : key.hashCode());
        entry.setKey(key);
        entry.setValue(value);
        return entry;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DelegatingMap
    implements EMap.InternalMapView<K, V> {
        public EMap<K, V> eMap() {
            return EMapWrapper.this;
        }

        public int size() {
            return EMapWrapper.this.size();
        }

        public boolean isEmpty() {
            return EMapWrapper.this.isEmpty();
        }

        public boolean containsKey(Object key) {
            return EMapWrapper.this.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return EMapWrapper.this.containsValue(value);
        }

        public V get(Object key) {
            return EMapWrapper.this.get(key);
        }

        public V put(K key, V value) {
            return EMapWrapper.this.put(key, value);
        }

        public V remove(Object o) {
            Map.Entry e = (Map.Entry)EMapWrapper.this.get(EMapWrapper.this.indexOfKey(o));
            if (e != null) {
                return e.getValue();
            }
            return null;
        }

        public V remove(Map.Entry<K, V> o) {
            if (EMapWrapper.this.remove(o)) {
                return o.getValue();
            }
            return null;
        }

        public void putAll(Map<? extends K, ? extends V> map) {
            EMapWrapper.this.putAll(map);
        }

        public void clear() {
            EMapWrapper.this.clear();
        }

        public Set<K> keySet() {
            return EMapWrapper.this.keySet();
        }

        public Collection<V> values() {
            return EMapWrapper.this.values();
        }

        public Set<Map.Entry<K, V>> entrySet() {
            return EMapWrapper.this.entrySet();
        }

        public boolean equals(Object object) {
            return EMapWrapper.this.equals(object);
        }

        public int hashCode() {
            return EMapWrapper.this.hashCode();
        }

        public boolean isLoaded() {
            return EMapWrapper.this.isLoaded();
        }
    }
}

