/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.eclipse.resourcehandler;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.teneo.eclipse.Messages;
import org.eclipse.emf.teneo.eclipse.StoreEclipseUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerGenerator;
import org.eclipse.ui.dialogs.SaveAsDialog;

public abstract class StoreExportXML
implements IObjectActionDelegate {
    private static Log log = LogFactory.getLog(StoreExportXML.class);
    private IStructuredSelection selection = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        try {
            ExportSaveAsDialog saDialog = new ExportSaveAsDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            saDialog.open();
            IPath path = saDialog.getResult();
            if (path == null) {
                return;
            }
            IPath containerPath = path.removeLastSegments(1);
            final ContainerGenerator cg = new ContainerGenerator(containerPath);
            IWorkspaceRunnable operation = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    cg.generateContainer(null);
                }
            };
            ResourcesPlugin.getWorkspace().run(operation, null);
            IFile destFile = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            Properties props = StoreEclipseUtil.readPropFile(this.selection);
            LocalJob wj = new LocalJob(destFile, props);
            wj.schedule();
        }
        catch (CoreException c) {
            StoreEclipseUtil.handleError(c, log);
        }
    }

    protected abstract byte[] doExport(Properties var1);

    protected boolean isXMLExport() {
        return true;
    }

    public void selectionChanged(IAction action, ISelection selected) {
        IStructuredSelection structSelection;
        if (!(selected instanceof IStructuredSelection)) {
            return;
        }
        this.selection = structSelection = (IStructuredSelection)selected;
    }

    private class ExportSaveAsDialog
    extends SaveAsDialog {
        public ExportSaveAsDialog(Shell parentShell) {
            super(parentShell);
        }

        protected Control createContents(Composite parent) {
            Control contents = super.createContents(parent);
            if (StoreExportXML.this.isXMLExport()) {
                this.setTitle(Messages.getString("teneo.export.xml"));
            } else {
                this.setTitle(Messages.getString("teneo.export.xmi"));
            }
            this.setMessage(Messages.getString("teneo.select.parent"));
            return contents;
        }
    }

    private class LocalJob
    extends WorkspaceJob {
        private IFile file;
        private Properties props;

        LocalJob(IFile file, Properties props) {
            super("Import");
            this.file = file;
            this.props = props;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            final byte[] content = StoreExportXML.this.doExport(this.props);
            IWorkspaceRunnable createOperation = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    ResourceAttributes attrs = new ResourceAttributes();
                    attrs.setArchive(false);
                    attrs.setReadOnly(false);
                    if (LocalJob.this.file.exists()) {
                        LocalJob.this.file.setResourceAttributes(attrs);
                        LocalJob.this.file.delete(true, null);
                    }
                    LocalJob.this.file.create((InputStream)new ByteArrayInputStream(content), true, null);
                }
            };
            ResourcesPlugin.getWorkspace().run(createOperation, null);
            return Status.OK_STATUS;
        }
    }
}

