/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.eclipselink.common.ui.wizards.pages;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.teneo.eclipselink.common.ui.Activator;
import org.eclipse.emf.teneo.eclipselink.common.ui.internal.messages.Messages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicModelAndDatabaseAccessParametersPage
extends WizardPage {
    protected static QualifiedName packageNsURIName = new QualifiedName(Activator.getDefault().getBundle().getSymbolicName(), "packageNsURI");
    protected static QualifiedName rootObjectTypeName = new QualifiedName(Activator.getDefault().getBundle().getSymbolicName(), "rootObjectType");
    protected static QualifiedName persistenceUnitNameName = new QualifiedName(Activator.getDefault().getBundle().getSymbolicName(), "persistenceUnitName");
    protected Combo packageNsURIField;
    protected Combo rootObjectTypeField;
    protected Combo persistenceUnitNameField;
    protected Button useLoginFromPersistenceUnitButton;
    protected Button useLoginFromUserPreferencesButton;
    private Label databaseURLLabel;
    protected Combo databaseURLField;
    private Label jdbcDriverLabel;
    protected Combo jdbcDriverField;
    private Label userNameLabel;
    protected Text userNameField;
    private Label passwordLabel;
    protected Text passwordField;

    public BasicModelAndDatabaseAccessParametersPage(String pageName) {
        super(pageName);
    }

    public String getPackageNsURI() {
        return this.packageNsURIField.getText();
    }

    public String getRootObjectTypeName() {
        return this.rootObjectTypeField.getText();
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitNameField.getText();
    }

    public String getUseLoginFrom() {
        String result = this.useLoginFromUserPreferencesButton.getSelection() ? "from_user_preferences" : "from_persistence_unit";
        return result;
    }

    public String getDatabaseURL() {
        return this.databaseURLField.getText();
    }

    public String getJDBCDriver() {
        return this.jdbcDriverField.getText();
    }

    public String getUserName() {
        return this.userNameField.getText();
    }

    public String getPassword() {
        return this.passwordField.getText();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createModelAndPersistenceUnitGroup(composite);
        this.createDatabaseLoginGroup(composite);
        this.setPageComplete(this.validatePage());
        this.setControl((Control)composite);
    }

    private void createModelAndPersistenceUnitGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(768));
        new Label(composite, 16384).setText(Messages.label_packageNamespaceURI);
        this.packageNsURIField = new Combo(composite, 2048);
        this.packageNsURIField.setLayoutData((Object)new GridData(768));
        this.initPackageNsURIField();
        this.packageNsURIField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BasicModelAndDatabaseAccessParametersPage.this.updateRootObjectTypeField();
                BasicModelAndDatabaseAccessParametersPage.this.setPageComplete(BasicModelAndDatabaseAccessParametersPage.this.validatePage());
            }
        });
        new Label(composite, 16384).setText(Messages.label_rootObjectType);
        this.rootObjectTypeField = new Combo(composite, 2048);
        this.rootObjectTypeField.setLayoutData((Object)new GridData(768));
        this.rootObjectTypeField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BasicModelAndDatabaseAccessParametersPage.this.setPageComplete(BasicModelAndDatabaseAccessParametersPage.this.validatePage());
            }
        });
        new Label(composite, 16384).setText(Messages.label_persistenceUnitName);
        this.persistenceUnitNameField = new Combo(composite, 2048);
        this.persistenceUnitNameField.setLayoutData((Object)new GridData(768));
        this.initPersistenceUnitNameField();
        this.persistenceUnitNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BasicModelAndDatabaseAccessParametersPage.this.setPageComplete(BasicModelAndDatabaseAccessParametersPage.this.validatePage());
            }
        });
        this.updateRootObjectTypeField();
    }

    private void createDatabaseLoginGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.group_databaseLogin);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(768));
        this.useLoginFromPersistenceUnitButton = new Button((Composite)group, 16);
        this.useLoginFromPersistenceUnitButton.setText(Messages.button_fromPersistenceUnit);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.useLoginFromPersistenceUnitButton.setLayoutData((Object)gridData);
        this.useLoginFromUserPreferencesButton = new Button((Composite)group, 16);
        this.useLoginFromUserPreferencesButton.setText(Messages.button_fromUserPreferences);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.useLoginFromUserPreferencesButton.setLayoutData((Object)gridData);
        this.initUseLoginFromButtons();
        this.useLoginFromUserPreferencesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BasicModelAndDatabaseAccessParametersPage.this.updateDatabaseLoginFields();
                BasicModelAndDatabaseAccessParametersPage.this.setPageComplete(BasicModelAndDatabaseAccessParametersPage.this.validatePage());
            }
        });
        this.databaseURLLabel = new Label((Composite)group, 16384);
        this.databaseURLLabel.setText(Messages.label_DatabaseURL);
        this.databaseURLField = new Combo((Composite)group, 2048);
        this.databaseURLField.setLayoutData((Object)new GridData(768));
        this.initDatabaseURLField();
        this.databaseURLField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BasicModelAndDatabaseAccessParametersPage.this.setPageComplete(BasicModelAndDatabaseAccessParametersPage.this.validatePage());
            }
        });
        this.jdbcDriverLabel = new Label((Composite)group, 16384);
        this.jdbcDriverLabel.setText(Messages.label_jdbcDriver);
        this.jdbcDriverField = new Combo((Composite)group, 2048);
        this.jdbcDriverField.setLayoutData((Object)new GridData(768));
        this.initJDBCDriverField();
        this.jdbcDriverField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BasicModelAndDatabaseAccessParametersPage.this.setPageComplete(BasicModelAndDatabaseAccessParametersPage.this.validatePage());
            }
        });
        this.userNameLabel = new Label((Composite)group, 16384);
        this.userNameLabel.setText(Messages.label_userName);
        this.userNameField = new Text((Composite)group, 2048);
        this.userNameField.setLayoutData((Object)new GridData(768));
        this.userNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BasicModelAndDatabaseAccessParametersPage.this.setPageComplete(BasicModelAndDatabaseAccessParametersPage.this.validatePage());
            }
        });
        this.passwordLabel = new Label((Composite)group, 16384);
        this.passwordLabel.setText(Messages.label_password);
        this.passwordField = new Text((Composite)group, 2048);
        this.passwordField.setLayoutData((Object)new GridData(768));
        this.passwordField.setEchoChar('*');
        this.passwordField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BasicModelAndDatabaseAccessParametersPage.this.setPageComplete(BasicModelAndDatabaseAccessParametersPage.this.validatePage());
            }
        });
        this.updateDatabaseLoginFields();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.persistWidgets();
        }
    }

    protected void initPackageNsURIField() {
        for (String nsURI : this.getModelNsURIs()) {
            this.packageNsURIField.add(nsURI);
        }
        int index = 0;
        try {
            String lastPackageNsURI = ResourcesPlugin.getWorkspace().getRoot().getPersistentProperty(packageNsURIName);
            index = Arrays.asList(this.packageNsURIField.getItems()).indexOf(lastPackageNsURI);
            index = index != -1 ? index : 0;
        }
        catch (CoreException cex) {
            Activator.getDefault().getLog().log(cex.getStatus());
        }
        this.packageNsURIField.select(index);
    }

    protected void initPersistenceUnitNameField() {
        for (String name : this.getPersistenceUnitNames()) {
            this.persistenceUnitNameField.add(name);
        }
        int index = 0;
        try {
            String lastPersistenceUnitName = ResourcesPlugin.getWorkspace().getRoot().getPersistentProperty(persistenceUnitNameName);
            index = Arrays.asList(this.persistenceUnitNameField.getItems()).indexOf(lastPersistenceUnitName);
            index = index != -1 ? index : 0;
        }
        catch (CoreException cex) {
            Activator.getDefault().getLog().log(cex.getStatus());
        }
        this.persistenceUnitNameField.select(index);
    }

    protected void initUseLoginFromButtons() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String useLoginFrom = store.getString("USE_LOGIN_FROM");
        this.useLoginFromPersistenceUnitButton.setSelection("from_persistence_unit".equals(useLoginFrom));
        this.useLoginFromUserPreferencesButton.setSelection("from_user_preferences".equals(useLoginFrom));
    }

    protected void initDatabaseURLField() {
        this.databaseURLField.add("jdbc:derby://localhost:1527/sample;create=true");
        this.databaseURLField.add("jdbc:oracle:thin:@localhost:1521:XE");
        this.databaseURLField.add("jdbc:oracle:thin:@localhost:1521:ORCL");
    }

    protected void initJDBCDriverField() {
        this.jdbcDriverField.add("org.apache.derby.jdbc.ClientDriver");
        this.jdbcDriverField.add("oracle.jdbc.OracleDriver");
        this.jdbcDriverField.add("com.mysql.jdbc.Driver");
    }

    protected void updateRootObjectTypeField() {
        this.rootObjectTypeField.removeAll();
        for (String name : this.getModelObjectTypeNames(this.packageNsURIField.getText())) {
            this.rootObjectTypeField.add(name);
        }
        int index = 0;
        try {
            String lastRootObjectType = ResourcesPlugin.getWorkspace().getRoot().getPersistentProperty(rootObjectTypeName);
            index = Arrays.asList(this.rootObjectTypeField.getItems()).indexOf(lastRootObjectType);
            index = index != -1 ? index : 0;
        }
        catch (CoreException cex) {
            Activator.getDefault().getLog().log(cex.getStatus());
        }
        this.rootObjectTypeField.select(index);
    }

    protected void updateDatabaseLoginFields() {
        if (this.useLoginFromUserPreferencesButton.getSelection()) {
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            this.databaseURLField.setText(store.getString("DATABASE_URL"));
            this.jdbcDriverField.setText(store.getString("JDBC_DRIVER"));
            this.userNameField.setText(store.getString("USER_NAME"));
            this.passwordField.setText(store.getString("PASSWORD"));
            this.databaseURLLabel.setEnabled(true);
            this.databaseURLField.setEnabled(true);
            this.jdbcDriverLabel.setEnabled(true);
            this.jdbcDriverField.setEnabled(true);
            this.userNameLabel.setEnabled(true);
            this.userNameField.setEnabled(true);
            this.passwordLabel.setEnabled(true);
            this.passwordField.setEnabled(true);
        } else {
            this.updateDatabaseLoginFieldsFromPersistenceUnit();
            this.databaseURLLabel.setEnabled(false);
            this.databaseURLField.setEnabled(false);
            this.jdbcDriverLabel.setEnabled(false);
            this.jdbcDriverField.setEnabled(false);
            this.userNameLabel.setEnabled(false);
            this.userNameField.setEnabled(false);
            this.passwordLabel.setEnabled(false);
            this.passwordField.setEnabled(false);
        }
    }

    protected boolean validatePage() {
        this.setErrorMessage(null);
        if (this.isBlank(this.packageNsURIField.getText())) {
            this.setErrorMessage(Messages.error_packageNamespaceURIMissing);
            return false;
        }
        if (!Arrays.asList(this.packageNsURIField.getItems()).contains(this.packageNsURIField.getText())) {
            this.setErrorMessage(Messages.error_packageNamespaceURIMustIdentifyExistingEcorePackage);
            return false;
        }
        if (this.isBlank(this.rootObjectTypeField.getText())) {
            this.setErrorMessage(Messages.error_rootObjectTypeMissing);
            return false;
        }
        if (!Arrays.asList(this.rootObjectTypeField.getItems()).contains(this.rootObjectTypeField.getText())) {
            this.setErrorMessage(NLS.bind((String)Messages.error_rootObjectMustBeInEcorePackage$0, (Object)this.packageNsURIField.getText()));
            return false;
        }
        if (this.isBlank(this.persistenceUnitNameField.getText())) {
            this.setErrorMessage(Messages.error_persistenceUnitNameMissing);
            return false;
        }
        if (!Arrays.asList(this.persistenceUnitNameField.getItems()).contains(this.persistenceUnitNameField.getText())) {
            this.setErrorMessage(Messages.error_persistenceUnitNameMustIdentifyExistingPersistenceUnit);
            return false;
        }
        if (this.useLoginFromUserPreferencesButton != null && this.useLoginFromUserPreferencesButton.getSelection()) {
            if (this.isBlank(this.databaseURLField.getText())) {
                this.setErrorMessage(Messages.error_databaseURLMissing);
                return false;
            }
            if (this.isBlank(this.jdbcDriverField.getText())) {
                this.setErrorMessage(Messages.error_jdbcDriverMissing);
                return false;
            }
            if (this.isBlank(this.userNameField.getText())) {
                this.setErrorMessage(Messages.error_userNameMissing);
                return false;
            }
            if (this.isBlank(this.passwordField.getText())) {
                this.setErrorMessage(Messages.error_passwordMissing);
                return false;
            }
        }
        return true;
    }

    protected void persistWidgets() {
        try {
            ResourcesPlugin.getWorkspace().getRoot().setPersistentProperty(packageNsURIName, this.packageNsURIField.getText());
            ResourcesPlugin.getWorkspace().getRoot().setPersistentProperty(rootObjectTypeName, this.rootObjectTypeField.getText());
            ResourcesPlugin.getWorkspace().getRoot().setPersistentProperty(persistenceUnitNameName, this.persistenceUnitNameField.getText());
        }
        catch (CoreException cex) {
            Activator.getDefault().getLog().log(cex.getStatus());
        }
    }

    protected Set<String> getPersistenceUnitNames() {
        return Collections.emptySet();
    }

    protected void updateDatabaseLoginFieldsFromPersistenceUnit() {
        this.databaseURLField.setText("");
        this.jdbcDriverField.setText("");
        this.userNameField.setText("");
        this.passwordField.setText("");
    }

    protected boolean isBlank(String string) {
        return string == null || string.trim().length() == 0;
    }

    protected List<String> getModelNsURIs() {
        ArrayList<String> result = new ArrayList<String>(EPackage.Registry.INSTANCE.keySet());
        Collections.sort(result, Collator.getInstance());
        return result;
    }

    protected List<String> getModelObjectTypeNames(String nsURI) {
        ArrayList<String> result = new ArrayList<String>();
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(nsURI);
        if (ePackage != null) {
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                EClass eClass;
                if (!(eClassifier instanceof EClass) || (eClass = (EClass)eClassifier).isAbstract()) continue;
                result.add(eClass.getName());
            }
        }
        Collections.sort(result, Collator.getInstance());
        return result;
    }
}

