/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.samples.emf.sample.forum;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TopicCategory implements Enumerator
{
    ANNOUNCEMENT_LITERAL(0, "Announcement", "Announcement"),
    GUEST_BOOK_LITERAL(1, "GuestBook", "GuestBook"),
    DISCUSSION_LITERAL(2, "Discussion", "Discussion");

    public static final int ANNOUNCEMENT = 0;
    public static final int GUEST_BOOK = 1;
    public static final int DISCUSSION = 2;
    private static final TopicCategory[] VALUES_ARRAY;
    public static final List<TopicCategory> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TopicCategory[]{ANNOUNCEMENT_LITERAL, GUEST_BOOK_LITERAL, DISCUSSION_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TopicCategory get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TopicCategory result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TopicCategory getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TopicCategory result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TopicCategory get(int value) {
        switch (value) {
            case 0: {
                return ANNOUNCEMENT_LITERAL;
            }
            case 1: {
                return GUEST_BOOK_LITERAL;
            }
            case 2: {
                return DISCUSSION_LITERAL;
            }
        }
        return null;
    }

    private TopicCategory(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

