/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.jpa.orm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum GenerationType implements Enumerator
{
    TABLE(0, "TABLE", "TABLE"),
    SEQUENCE(1, "SEQUENCE", "SEQUENCE"),
    IDENTITY(2, "IDENTITY", "IDENTITY"),
    AUTO(3, "AUTO", "AUTO");

    public static final int TABLE_VALUE = 0;
    public static final int SEQUENCE_VALUE = 1;
    public static final int IDENTITY_VALUE = 2;
    public static final int AUTO_VALUE = 3;
    private static final GenerationType[] VALUES_ARRAY;
    public static final List<GenerationType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new GenerationType[]{TABLE, SEQUENCE, IDENTITY, AUTO};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static GenerationType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GenerationType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GenerationType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GenerationType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GenerationType get(int value) {
        switch (value) {
            case 0: {
                return TABLE;
            }
            case 1: {
                return SEQUENCE;
            }
            case 2: {
                return IDENTITY;
            }
            case 3: {
                return AUTO;
            }
        }
        return null;
    }

    private GenerationType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

