/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapping;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Node;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.teneo.hibernate.HbStoreException;
import org.hibernate.EntityMode;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.internal.ForeignKeys;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.metamodel.relational.Size;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.type.AbstractType;
import org.hibernate.type.AssociationType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class AnyEObjectType
extends AbstractType
implements CompositeType,
AssociationType {
    private static final long serialVersionUID = 3857353606004705457L;
    private static final String[] PROPERTY_NAMES = new String[]{"class", "idtype", "idstr"};
    private static final int[] SQL_TYPES = new int[]{12, 12, 12};
    private final HashMap<String, Constructor<?>> constructors = new HashMap();

    public int[] sqlTypes() {
        return SQL_TYPES;
    }

    public Object deepCopy(Object value, EntityMode entityMode, SessionFactoryImplementor factory) throws HibernateException {
        return value;
    }

    public boolean isMethodOf(Method method) {
        return false;
    }

    public boolean isSame(Object x, Object y, EntityMode entityMode) throws HibernateException {
        if (x != null) {
            return x.equals(y);
        }
        return x == y;
    }

    public int compare(Object x, Object y, EntityMode entityMode) {
        return 0;
    }

    public int getColumnSpan(Mapping session) throws MappingException {
        return SQL_TYPES.length;
    }

    public String getName() {
        return "AnyEObject";
    }

    public boolean isMutable() {
        return false;
    }

    public Object nullSafeGet(ResultSet rs, String name, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        throw new UnsupportedOperationException("Type is a multicolumn type");
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        String entityName = rs.getString(names[0]);
        if (rs.wasNull()) {
            return null;
        }
        String idType = rs.getString(names[1]);
        if (rs.wasNull()) {
            return null;
        }
        String idStr = rs.getString(names[2]);
        if (rs.wasNull()) {
            return null;
        }
        return session.internalLoad(entityName, this.getId(idStr, idType), true, false);
    }

    private Serializable getId(String idStr, String idType) {
        try {
            Constructor<?> constructor = this.constructors.get(idType);
            if (constructor == null) {
                Class<?> idClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(idType);
                constructor = idClass.getConstructor(String.class);
                this.constructors.put(idType, constructor);
            }
            return (Serializable)constructor.newInstance(idStr);
        }
        catch (Exception e) {
            throw new HbStoreException("Could not create id type for " + idType + " and id " + idStr, e);
        }
    }

    public Object hydrate(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        String entityName = rs.getString(names[0]);
        if (rs.wasNull()) {
            return null;
        }
        String idType = rs.getString(names[1]);
        if (rs.wasNull()) {
            return null;
        }
        String idStr = rs.getString(names[2]);
        if (rs.wasNull()) {
            return null;
        }
        return new EObjectCacheEntry(entityName, this.getId(idStr, idType));
    }

    public Object resolve(Object value, SessionImplementor session, Object owner) throws HibernateException {
        EObjectCacheEntry entry = (EObjectCacheEntry)value;
        return session.internalLoad(entry.entityName, entry.id, true, false);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        this.nullSafeSet(st, value, index, null, session);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, boolean[] settable, SessionImplementor session) throws HibernateException, SQLException {
        String entityName = null;
        String idStr = null;
        String idType = null;
        if (value != null) {
            entityName = session.bestGuessEntityName(value);
            Serializable id = ForeignKeys.getEntityIdentifierIfNotUnsaved((String)entityName, (Object)value, (SessionImplementor)session);
            idType = id.getClass().getName();
            idStr = id.toString();
            st.setString(index, entityName);
            st.setString(index + 1, idType);
            st.setString(index + 2, idStr);
        } else {
            st.setNull(index, SQL_TYPES[0]);
            st.setNull(index, SQL_TYPES[1]);
            st.setNull(index, SQL_TYPES[2]);
        }
    }

    public Class<?> getReturnedClass() {
        return EObject.class;
    }

    public int[] sqlTypes(Mapping mapping) throws MappingException {
        return SQL_TYPES;
    }

    public void setToXMLNode(Node xml, Object value, SessionFactoryImplementor factory) {
        throw new UnsupportedOperationException("Any types cannot be stringified");
    }

    public String toLoggableString(Object value, SessionFactoryImplementor factory) throws HibernateException {
        return value == null ? "null" : value.getClass().getName();
    }

    public Object fromXMLNode(Node xml, Mapping factory) throws HibernateException {
        throw new UnsupportedOperationException();
    }

    public Object assemble(Serializable cached, SessionImplementor session, Object owner) throws HibernateException {
        EObjectCacheEntry entry = (EObjectCacheEntry)cached;
        return entry == null ? null : session.internalLoad(entry.entityName, entry.id, true, false);
    }

    public Serializable disassemble(Object value, SessionImplementor session, Object owner) throws HibernateException {
        if (value == null) {
            return null;
        }
        String entityName = session.bestGuessEntityName(value);
        Serializable id = ForeignKeys.getEntityIdentifierIfNotUnsaved((String)entityName, (Object)value, (SessionImplementor)session);
        return new EObjectCacheEntry(entityName, id);
    }

    public boolean isAnyType() {
        return true;
    }

    public Object replace(Object original, Object target, SessionImplementor session, Object owner, Map copyCache) throws HibernateException {
        if (original == null) {
            return null;
        }
        String entityName = session.bestGuessEntityName(original);
        Serializable id = ForeignKeys.getEntityIdentifierIfNotUnsaved((String)entityName, (Object)original, (SessionImplementor)session);
        return session.internalLoad(entityName, id, true, false);
    }

    public CascadeStyle getCascadeStyle(int i) {
        return CascadeStyle.NONE;
    }

    public FetchMode getFetchMode(int i) {
        return FetchMode.SELECT;
    }

    public String[] getPropertyNames() {
        return PROPERTY_NAMES;
    }

    public Object getPropertyValue(Object component, int i, SessionImplementor session) throws HibernateException {
        if (component != null) {
            String entityName = session.bestGuessEntityName(component);
            Serializable id = ForeignKeys.getEntityIdentifierIfNotUnsaved((String)entityName, (Object)component, (SessionImplementor)session);
            switch (i) {
                case 0: {
                    return session.bestGuessEntityName(component);
                }
                case 1: {
                    return id.getClass().getName();
                }
                case 2: {
                    return id.toString();
                }
            }
            throw new HbStoreException("Index " + i + "not supported");
        }
        return null;
    }

    public Object[] getPropertyValues(Object component, SessionImplementor session) throws HibernateException {
        if (component != null) {
            String entityName = session.bestGuessEntityName(component);
            Serializable id = ForeignKeys.getEntityIdentifierIfNotUnsaved((String)entityName, (Object)component, (SessionImplementor)session);
            return new Object[]{session.bestGuessEntityName(component), id.getClass().getName(), id.toString()};
        }
        return null;
    }

    public Type[] getSubtypes() {
        return new Type[]{StandardBasicTypes.STRING, StandardBasicTypes.STRING, StandardBasicTypes.STRING};
    }

    public void setPropertyValues(Object component, Object[] values, EntityMode entityMode) throws HibernateException {
        throw new UnsupportedOperationException();
    }

    public Object[] getPropertyValues(Object component, EntityMode entityMode) {
        throw new UnsupportedOperationException();
    }

    public boolean isComponentType() {
        return true;
    }

    public ForeignKeyDirection getForeignKeyDirection() {
        return ForeignKeyDirection.FOREIGN_KEY_FROM_PARENT;
    }

    public boolean isAssociationType() {
        return true;
    }

    public boolean useLHSPrimaryKey() {
        return false;
    }

    public Joinable getAssociatedJoinable(SessionFactoryImplementor factory) {
        throw new UnsupportedOperationException("any types do not have a unique referenced persister");
    }

    public boolean isModified(Object old, Object current, boolean[] checkable, SessionImplementor session) throws HibernateException {
        if (current == null) {
            return old != null;
        }
        if (old == null) {
            return current != null;
        }
        EObjectCacheEntry entry = (EObjectCacheEntry)old;
        String entityName = session.bestGuessEntityName(current);
        Serializable id = ForeignKeys.getEntityIdentifierIfNotUnsaved((String)entityName, (Object)current, (SessionImplementor)session);
        if (checkable[0] && entry.entityName.compareTo(entityName) != 0) {
            return true;
        }
        return (checkable[1] || checkable[2]) && !id.equals(entry.id);
    }

    public String getAssociatedEntityName(SessionFactoryImplementor factory) throws MappingException {
        throw new UnsupportedOperationException("any types do not have a unique referenced persister");
    }

    public boolean[] getPropertyNullability() {
        return null;
    }

    public String getOnCondition(String alias, SessionFactoryImplementor factory, Map enabledFilters) throws MappingException {
        throw new UnsupportedOperationException();
    }

    public boolean isReferenceToPrimaryKey() {
        return true;
    }

    public String getRHSUniqueKeyPropertyName() {
        return null;
    }

    public String getLHSPropertyName() {
        return null;
    }

    public boolean isAlwaysDirtyChecked() {
        return false;
    }

    public boolean isEmbeddedInXML() {
        return false;
    }

    public boolean[] toColumnNullness(Object value, Mapping mapping) {
        boolean[] result = new boolean[this.getColumnSpan(mapping)];
        if (value != null) {
            Arrays.fill(result, true);
        }
        return result;
    }

    public boolean isDirty(Object old, Object current, boolean[] checkable, SessionImplementor session) throws HibernateException {
        return this.isDirty(old, current, session);
    }

    public boolean isEmbedded() {
        return false;
    }

    public Size[] dictatedSizes(Mapping mapping) throws MappingException {
        return new Size[]{new Size(), new Size(), new Size()};
    }

    public Size[] defaultSizes(Mapping mapping) throws MappingException {
        return new Size[]{new Size(), new Size(), new Size()};
    }

    public Object deepCopy(Object value, SessionFactoryImplementor factory) throws HibernateException {
        return value;
    }

    public static final class EObjectCacheEntry
    implements Serializable {
        private static final long serialVersionUID = 1030890286147221359L;
        String entityName;
        Serializable id;

        EObjectCacheEntry(String entityName, Serializable id) {
            this.entityName = entityName;
            this.id = id;
        }
    }
}

