/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapping.elist;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.teneo.EContainerRepairControl;
import org.eclipse.emf.teneo.mapping.strategy.EntityNameStrategy;
import org.eclipse.emf.teneo.util.AssertUtil;
import org.eclipse.emf.teneo.util.StoreUtil;

public class HibernateFeatureMapEntry
implements FeatureMap.Entry.Internal,
Serializable {
    private static final long serialVersionUID = 3946138277481892125L;
    private EStructuralFeature eStructuralFeature;
    private String eFeaturePath;
    private FeatureMap.Internal owningMap;
    private ArrayList<FeatureValue> featureValues = new ArrayList();
    private Object tempValue;
    private String entityName = null;

    public static HibernateFeatureMapEntry replaceEntry(Object obj, FeatureMap.Internal owningMap) {
        HibernateFeatureMapEntry fmEntry;
        if (obj instanceof HibernateFeatureMapEntry && (!(fmEntry = (HibernateFeatureMapEntry)obj).isFeatureMapSet() || fmEntry.belongsToFeatureMap(owningMap))) {
            return fmEntry;
        }
        HibernateFeatureMapEntry entry = new HibernateFeatureMapEntry();
        entry.setEntry((FeatureMap.Entry)obj, owningMap);
        return entry;
    }

    public static Collection<HibernateFeatureMapEntry> replaceEntryAll(Collection<FeatureMap.Entry> c, Class<?> replaceByType, FeatureMap.Internal owningMap) {
        ArrayList<HibernateFeatureMapEntry> newEntries = new ArrayList<HibernateFeatureMapEntry>();
        Iterator<FeatureMap.Entry> it = c.iterator();
        while (it.hasNext()) {
            newEntries.add(HibernateFeatureMapEntry.replaceEntry(it.next(), owningMap));
        }
        return newEntries;
    }

    public static FeatureMap.Entry createEntry(EStructuralFeature feature, Object value, FeatureMap.Internal owningMap) {
        HibernateFeatureMapEntry entry = new HibernateFeatureMapEntry();
        entry.setFeatureValue(feature, value, owningMap);
        return entry;
    }

    public static Collection<FeatureMap.Entry> createEntryAll(EStructuralFeature feature, Collection<?> values, FeatureMap.Internal owningMap) {
        ArrayList<FeatureMap.Entry> entries = new ArrayList<FeatureMap.Entry>();
        Iterator<?> it = values.iterator();
        while (it.hasNext()) {
            entries.add(HibernateFeatureMapEntry.createEntry(feature, it.next(), owningMap));
        }
        return entries;
    }

    public void setFeatureMap(FeatureMap.Internal featureMap) {
        this.owningMap = featureMap;
    }

    public void unsetFeatureMap() {
        this.owningMap = null;
    }

    public boolean isFeatureMapSet() {
        return this.owningMap != null;
    }

    public boolean belongsToFeatureMap(FeatureMap.Internal fm) {
        return this.owningMap == fm;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.eFeaturePath = StoreUtil.structuralFeatureToString((EStructuralFeature)this.eStructuralFeature);
        this.eStructuralFeature = null;
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.eStructuralFeature = StoreUtil.stringToStructureFeature((String)this.eFeaturePath);
    }

    public void setEntry(FeatureMap.Entry entry, FeatureMap.Internal owningMap) {
        this.eStructuralFeature = entry.getEStructuralFeature();
        this.featureValues.add(this.createFeatureValue(this.eStructuralFeature, entry.getValue()));
        this.setFeatureMap(owningMap);
    }

    public EStructuralFeature getEStructuralFeature() {
        return this.eStructuralFeature;
    }

    private void setEStructuralFeature(EStructuralFeature structuralFeature) {
        this.eStructuralFeature = structuralFeature;
        if (this.tempValue != null) {
            Object value = this.doPossibleConversion(this.tempValue);
            this.addFeatureValue(this.eStructuralFeature, value);
            this.tempValue = null;
        }
    }

    public String getFeatureURI() {
        return StoreUtil.structuralFeatureToString((EStructuralFeature)this.getEStructuralFeature());
    }

    public void setEStructuralFeature(String featureURI) {
        this.setEStructuralFeature(StoreUtil.stringToStructureFeature((String)featureURI));
    }

    public Object getValue() {
        return this.getValue(this.getEStructuralFeature());
    }

    public void addFeatureValue(EStructuralFeature feature, Object value) {
        this.featureValues.add(this.createFeatureValue(feature, value));
    }

    public void setValue(Object value) {
        if (this.getEStructuralFeature() != null) {
            this.addFeatureValue(this.getEStructuralFeature(), this.doPossibleConversion(value));
        } else {
            this.tempValue = value;
        }
    }

    private Object doPossibleConversion(Object value) {
        if (this.getEStructuralFeature() instanceof EAttribute) {
            EAttribute eAttribute = (EAttribute)this.getEStructuralFeature();
            EDataType eDataType = eAttribute.getEAttributeType();
            Object realValue = eDataType.getEPackage().getEFactoryInstance().createFromString(eDataType, (String)value);
            return realValue;
        }
        return value;
    }

    public void setFeatureValue(EStructuralFeature feature, Object value, FeatureMap.Internal owningMap) {
        this.featureValues.add(this.createFeatureValue(feature, value));
        this.setEStructuralFeature(feature);
        this.setFeatureMap(owningMap);
    }

    public Object getValue(EStructuralFeature feature) {
        for (FeatureValue fv : this.featureValues) {
            if (!fv.matchesFeature(feature)) continue;
            return fv.getValue();
        }
        return null;
    }

    private FeatureValue getFeatureValue() {
        EStructuralFeature feature = this.getEStructuralFeature();
        AssertUtil.assertTrue((String)"Feature is not set", (feature != null ? 1 : 0) != 0);
        for (FeatureValue fv : this.featureValues) {
            if (!fv.matchesFeature(feature)) continue;
            return fv;
        }
        return null;
    }

    public void setContainer(InternalEObject owner) {
        Object value = this.getValue();
        if (value != null && value instanceof InternalEObject && this.eStructuralFeature instanceof EReference && ((EReference)this.eStructuralFeature).isContainment()) {
            EContainerRepairControl.setContainer((InternalEObject)owner, (InternalEObject)((InternalEObject)value), (EStructuralFeature)this.eStructuralFeature);
        }
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof FeatureMap.Entry)) {
            return false;
        }
        FeatureMap.Entry entry = (FeatureMap.Entry)that;
        Object value = this.getValue();
        return entry.getEStructuralFeature() == this.eStructuralFeature && (value == null ? entry.getValue() == null : value.equals(entry.getValue()));
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        String prefix = this.eStructuralFeature.getEContainingClass().getEPackage().getNsPrefix();
        this.eStructuralFeature.getName();
        return String.valueOf(prefix != null && prefix.length() != 0 ? String.valueOf(prefix) + ":" + this.eStructuralFeature.getName() : this.eStructuralFeature.getName()) + "=" + this.getValue();
    }

    public String getEntityName(EntityNameStrategy entityNameStrategy) {
        if (this.entityName == null && this.owningMap != null) {
            this.entityName = StoreUtil.getEntityName((EntityNameStrategy)entityNameStrategy, (EStructuralFeature)this.owningMap.getEStructuralFeature());
        }
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    private FeatureValue createFeatureValue(EStructuralFeature feature, Object value) {
        if (feature instanceof EReference && ((EReference)feature).getEOpposite() != null) {
            return new InverseFeatureValue(feature, value);
        }
        if (feature instanceof EReference && ((EReference)feature).isContainment()) {
            return new ContainmentFeatureValue(feature, value);
        }
        return new FeatureValue(feature, value, null, null);
    }

    public FeatureMap.Entry.Internal createEntry(InternalEObject value) {
        HibernateFeatureMapEntry hfm = new HibernateFeatureMapEntry();
        hfm.setFeatureValue(this.getEStructuralFeature(), value, this.owningMap);
        return hfm;
    }

    public FeatureMap.Entry.Internal createEntry(Object value) {
        return this.createEntry((InternalEObject)value);
    }

    public final NotificationChain inverseAdd(InternalEObject owner, int featureID, NotificationChain notifications) {
        return this.getFeatureValue().inverseAdd(owner, this.getValue(), featureID, notifications);
    }

    public final NotificationChain inverseRemove(InternalEObject owner, int featureID, NotificationChain notifications) {
        return this.getFeatureValue().inverseRemove(owner, this.getValue(), featureID, notifications);
    }

    public final NotificationChain inverseAdd(InternalEObject owner, Object otherEnd, int featureID, NotificationChain notifications) {
        return this.getFeatureValue().inverseAdd(owner, this.getValue(), featureID, notifications);
    }

    public NotificationChain inverseRemove(InternalEObject owner, Object otherEnd, int featureID, NotificationChain notifications) {
        return this.getFeatureValue().inverseRemove(owner, otherEnd, featureID, notifications);
    }

    public void validate(Object value) {
        this.getFeatureValue().validate(value);
    }

    private class ContainmentFeatureValue
    extends FeatureValue {
        private static final long serialVersionUID = -5915172909939056481L;

        private ContainmentFeatureValue(EStructuralFeature feature, Object value) {
            super(feature, value);
        }

        @Override
        public NotificationChain inverseAdd(InternalEObject owner, Object otherEnd, int featureID, NotificationChain notifications) {
            return this.inverseAdd(owner, (InternalEObject)this.value, featureID, notifications);
        }

        @Override
        public NotificationChain inverseRemove(InternalEObject owner, Object otherEnd, int featureID, NotificationChain notifications) {
            return this.inverseRemove(owner, (InternalEObject)this.value, featureID, notifications);
        }

        private NotificationChain inverseAdd(InternalEObject owner, InternalEObject otherEnd, int featureID, NotificationChain notifications) {
            if (otherEnd != null) {
                int containmentFeatureID = owner.eClass().getFeatureID(HibernateFeatureMapEntry.this.eStructuralFeature);
                notifications = otherEnd.eInverseAdd(owner, -1 - (containmentFeatureID == -1 ? featureID : containmentFeatureID), null, notifications);
            }
            return notifications;
        }

        private NotificationChain inverseRemove(InternalEObject owner, InternalEObject otherEnd, int featureID, NotificationChain notifications) {
            if (otherEnd != null) {
                int containmentFeatureID = owner.eClass().getFeatureID(HibernateFeatureMapEntry.this.eStructuralFeature);
                notifications = otherEnd.eInverseRemove(owner, -1 - (containmentFeatureID == -1 ? featureID : containmentFeatureID), null, notifications);
            }
            return notifications;
        }
    }

    private class FeatureValue
    implements Serializable {
        private static final long serialVersionUID = 3665363921316852811L;
        protected EStructuralFeature feature;
        private String featurePath;
        protected Object value;

        private FeatureValue(EStructuralFeature feature, Object value) {
            this.feature = feature;
            this.value = value;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            this.featurePath = StoreUtil.structuralFeatureToString((EStructuralFeature)this.feature);
            this.feature = null;
            out.defaultWriteObject();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.feature = StoreUtil.stringToStructureFeature((String)this.featurePath);
        }

        private boolean matchesFeature(EStructuralFeature eFeature) {
            if (this.feature.equals(eFeature)) {
                return true;
            }
            if (HibernateFeatureMapEntry.this.owningMap == null) {
                return false;
            }
            EStructuralFeature aff1 = ExtendedMetaData.INSTANCE.getAffiliation(HibernateFeatureMapEntry.this.owningMap.getEObject().eClass(), this.feature);
            EStructuralFeature aff2 = ExtendedMetaData.INSTANCE.getAffiliation(HibernateFeatureMapEntry.this.owningMap.getEObject().eClass(), eFeature);
            return aff1 != null && aff2 != null && aff1 == aff2;
        }

        private Object getValue() {
            return this.value;
        }

        public NotificationChain inverseAdd(InternalEObject owner, Object otherEnd, int featureID, NotificationChain notifications) {
            return notifications;
        }

        public NotificationChain inverseRemove(InternalEObject owner, Object otherEnd, int featureID, NotificationChain notifications) {
            return notifications;
        }

        public void validate(Object value) {
            if (value != null && !HibernateFeatureMapEntry.this.eStructuralFeature.getEType().isInstance(value)) {
                String valueClass = value instanceof EObject ? ((EObject)value).eClass().getName() : value.getClass().getName();
                throw new ClassCastException("The feature '" + HibernateFeatureMapEntry.this.eStructuralFeature.getName() + "'s type '" + HibernateFeatureMapEntry.this.eStructuralFeature.getEType().getName() + "' does not permit a value of type '" + valueClass + "'");
            }
        }

        /* synthetic */ FeatureValue(EStructuralFeature eStructuralFeature, Object object, FeatureValue featureValue, FeatureValue featureValue2) {
            this(eStructuralFeature, object);
        }
    }

    private class InverseFeatureValue
    extends FeatureValue {
        private static final long serialVersionUID = 7207038502480577523L;

        private InverseFeatureValue(EStructuralFeature feature, Object value) {
            super(feature, value);
        }

        @Override
        public NotificationChain inverseAdd(InternalEObject owner, Object otherEnd, int featureID, NotificationChain notifications) {
            return this.inverseAdd(owner, (InternalEObject)this.value, featureID, notifications);
        }

        @Override
        public NotificationChain inverseRemove(InternalEObject owner, Object otherEnd, int featureID, NotificationChain notifications) {
            return this.inverseRemove(owner, (InternalEObject)this.value, featureID, notifications);
        }

        private final NotificationChain inverseAdd(InternalEObject owner, InternalEObject otherEnd, int featureID, NotificationChain notifications) {
            if (otherEnd != null) {
                notifications = otherEnd.eInverseAdd(owner, otherEnd.eClass().getFeatureID((EStructuralFeature)((EReference)HibernateFeatureMapEntry.this.eStructuralFeature).getEOpposite()), null, notifications);
            }
            return notifications;
        }

        private final NotificationChain inverseRemove(InternalEObject owner, InternalEObject otherEnd, int featureID, NotificationChain notifications) {
            if (otherEnd != null) {
                notifications = otherEnd.eInverseRemove(owner, otherEnd.eClass().getFeatureID((EStructuralFeature)((EReference)HibernateFeatureMapEntry.this.eStructuralFeature).getEOpposite()), null, notifications);
            }
            return notifications;
        }
    }
}

