/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.annotations;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.teneo.PersistenceOptions;
import org.eclipse.emf.teneo.annotations.mapper.EClassAnnotator;
import org.eclipse.emf.teneo.annotations.mapper.StoreMappingException;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedModel;
import org.eclipse.emf.teneo.ecore.EModelResolver;
import org.eclipse.emf.teneo.hibernate.hbannotation.Cache;
import org.eclipse.emf.teneo.hibernate.hbannotation.CacheConcurrencyStrategy;
import org.eclipse.emf.teneo.hibernate.hbannotation.HbannotationFactory;
import org.eclipse.emf.teneo.hibernate.hbannotation.Proxy;
import org.eclipse.emf.teneo.hibernate.hbmodel.HbAnnotatedEClass;

public class HbEClassAnnotator
extends EClassAnnotator {
    protected static final Log log = LogFactory.getLog(HbEClassAnnotator.class);
    private String defaultCacheStrategy = CacheConcurrencyStrategy.NONE.getName();
    private boolean optionSetProxy = false;

    protected boolean annotate(PAnnotatedEClass aClass) {
        boolean hasCache;
        Proxy proxy;
        boolean res = super.annotate(aClass);
        HbAnnotatedEClass hbClass = (HbAnnotatedEClass)aClass;
        EClass eclass = aClass.getModelEClass();
        Class<DynamicEObjectImpl> concreteClass = EModelResolver.instance().getJavaClass((EClassifier)eclass);
        if ((this.optionSetProxy || this.getPersistenceOptions().isForceLazy()) && hbClass.getHbProxy() == null) {
            if (concreteClass == null) {
                concreteClass = DynamicEObjectImpl.class;
            }
            if (concreteClass != null || this.getPersistenceOptions().isForceLazy()) {
                proxy = HbannotationFactory.eINSTANCE.createProxy();
                proxy.setLazy(true);
                ((HbAnnotatedEClass)aClass).setHbProxy(proxy);
                log.debug((Object)("Set proxy to true (" + proxy.getProxyClass() + ") for eclass " + aClass.getModelEClass().getName()));
            }
        }
        if (hbClass.getHbProxy() != null && concreteClass != null) {
            aClass.setOnlyMapAsEntity(false);
            if (!this.getPersistenceOptions().isForceLazy()) {
                proxy = hbClass.getHbProxy();
                Class interfaceClass = EModelResolver.instance().getJavaInterfaceClass(eclass);
                if (interfaceClass != null) {
                    proxy.setProxyClass(interfaceClass.getName());
                } else {
                    proxy.setProxyClass(concreteClass.getName());
                }
            }
        }
        boolean bl = hasCache = ((HbAnnotatedEClass)aClass).getHbCache() != null;
        if (aClass.getPaSuperEntity() != null && hasCache) {
            log.warn((Object)("EClass: " + aClass.getModelEClass().getName() + " has a cache strategy defined while it has a superclass, this strategy is ignored."));
            return res;
        }
        if (!hasCache && this.defaultCacheStrategy.compareToIgnoreCase(CacheConcurrencyStrategy.NONE.getName()) != 0) {
            CacheConcurrencyStrategy ccs = CacheConcurrencyStrategy.getByName(this.defaultCacheStrategy);
            if (ccs == null) {
                throw new StoreMappingException("The default cache strategy: " + this.defaultCacheStrategy + " is not one of the allowed values (uppercase) " + "as defined in the JPA Hibernate Annotation Extensions.");
            }
            log.debug((Object)("Setting cache strategy " + this.defaultCacheStrategy + " on " + aClass.getModelEClass().getName()));
            Cache cache = HbannotationFactory.eINSTANCE.createCache();
            cache.setUsage(ccs);
            ((HbAnnotatedEClass)aClass).setHbCache(cache);
        }
        return res;
    }

    protected boolean addDiscriminator(PAnnotatedEClass aClass) {
        HbAnnotatedEClass hbClass = (HbAnnotatedEClass)aClass;
        return hbClass.getDiscriminatorFormula() == null && (hbClass.getImmutable() == null || this.getPersistenceOptions().isDiscriminatorVersionOnImmutableEClass() != false);
    }

    public void setPersistenceOptions(PersistenceOptions persistenceOptions) {
        super.setPersistenceOptions(persistenceOptions);
        this.defaultCacheStrategy = persistenceOptions.getDefaultCacheStrategy();
        this.optionSetProxy = persistenceOptions.isSetProxy();
    }

    protected void setSuperEntity(PAnnotatedEClass aClass) {
        assert (aClass.getPaSuperEntity() == null);
        if (aClass.getEntity() != null && aClass.getEntity().getExtends() != null) {
            super.setSuperEntity(aClass);
            return;
        }
        EClass eclass = aClass.getModelEClass();
        if (eclass.getESuperTypes().size() == 0) {
            aClass.setPaSuperEntity(null);
            return;
        }
        PAnnotatedEClass superAClass = this.getPaSuperEntity(aClass, false);
        if (superAClass == null) {
            superAClass = this.getPaSuperEntity(aClass, true);
        }
        aClass.setPaSuperEntity(superAClass);
    }

    private PAnnotatedEClass getPaSuperEntity(PAnnotatedEClass aClass, boolean allowInterfaces) {
        PAnnotatedModel model = aClass.getPaModel();
        for (EClass superEClass : aClass.getModelEClass().getESuperTypes()) {
            PAnnotatedEClass x = model.getPAnnotated(superEClass);
            if (x.getEntity() == null || x.getMappedSuperclass() != null || !allowInterfaces && x.getModelEClass().isInterface()) continue;
            return x;
        }
        return null;
    }

    protected boolean mapInterfaceEClass() {
        return true;
    }

    protected boolean mapMappedSuperEClass() {
        return true;
    }
}

