/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.annotations.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.teneo.PersistenceOptions;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEModelElement;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEPackage;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedModel;
import org.eclipse.emf.teneo.annotations.pannotation.PannotationPackage;
import org.eclipse.emf.teneo.annotations.parser.AnnotationParser;
import org.eclipse.emf.teneo.annotations.parser.AnnotationParserException;
import org.eclipse.emf.teneo.annotations.parser.ComplexNode;
import org.eclipse.emf.teneo.annotations.parser.EClassResolver;
import org.eclipse.emf.teneo.annotations.parser.NamedParserNode;
import org.eclipse.emf.teneo.annotations.parser.ParserUtil;
import org.eclipse.emf.teneo.extension.ExtensionPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EAnnotationParserImporter
implements EClassResolver,
ExtensionPoint {
    private static final Log log = LogFactory.getLog(EAnnotationParserImporter.class);
    private AnnotationParser annotationParser = new AnnotationParser();
    private static final String JPA_PREFIX = "jpa:";
    private String[] extraAnnotationsSources = new String[0];
    private PersistenceOptions persistenceOptions = null;

    public void process(PAnnotatedModel paModel) {
        for (PAnnotatedEPackage pap : paModel.getPaEPackages()) {
            log.debug((Object)("Processing package " + pap.getModelEPackage().getName()));
            this.processAnnotatedModelElement((PAnnotatedEModelElement)pap, pap.eClass().getEPackage());
            this.process(pap);
        }
    }

    protected void process(PAnnotatedEPackage pap) {
        for (PAnnotatedEClass pac : pap.getPaEClasses()) {
            this.processAnnotatedModelElement((PAnnotatedEModelElement)pac, pac.getModelEClass().getEPackage());
            this.process(pac);
        }
        for (PAnnotatedEClass pac : pap.getPaEDataTypes()) {
            this.processAnnotatedModelElement((PAnnotatedEModelElement)pac, pac.getModelEDataType().getEPackage());
        }
    }

    protected void process(PAnnotatedEClass pac) {
        log.debug((Object)("Processing eclass " + pac.getModelEClass().getName()));
        for (PAnnotatedEStructuralFeature paf : pac.getPaEStructuralFeatures()) {
            this.processAnnotatedModelElement((PAnnotatedEModelElement)paf, paf.getModelEStructuralFeature().eClass().getEPackage());
        }
    }

    protected void processAnnotatedModelElement(PAnnotatedEModelElement pee, EPackage epack) {
        log.debug((Object)("Processing " + pee.getModelElement().getName()));
        ArrayList<NamedParserNode> parsedNodes = new ArrayList<NamedParserNode>();
        for (EAnnotation annotation : pee.getModelElement().getEAnnotations()) {
            parsedNodes.addAll(this.process(annotation, pee.getModelElement()));
        }
        log.debug((Object)("Number of parsed typename annotations " + parsedNodes.size()));
        for (NamedParserNode namedParserNode : parsedNodes) {
            ComplexNode cn = (ComplexNode)namedParserNode;
            if (cn.isList()) {
                EStructuralFeature ef = this.getEStructuralFeature(pee.eClass(), cn.getName());
                pee.eSet(ef, cn.convert(this));
                continue;
            }
            EObject eobj = (EObject)cn.convert(this);
            boolean found = false;
            for (EReference eref : pee.eClass().getEAllReferences()) {
                if (eref.getEReferenceType() != eobj.eClass()) continue;
                log.debug((Object)("Found EReference " + eref.getName() + " for " + eobj.eClass().getName()));
                if (eref.isMany()) {
                    ((List)pee.eGet((EStructuralFeature)eref)).add(eobj);
                } else {
                    pee.eSet((EStructuralFeature)eref, (Object)eobj);
                }
                found = true;
                break;
            }
            if (!found) {
                for (EReference eref : pee.eClass().getEAllReferences()) {
                    if (!eref.getEReferenceType().isInstance((Object)eobj)) continue;
                    log.debug((Object)("Found EReference " + eref.getName() + " for " + eobj.eClass().getName()));
                    if (eref.isMany()) {
                        ((List)pee.eGet((EStructuralFeature)eref)).add(eobj);
                    } else {
                        pee.eSet((EStructuralFeature)eref, (Object)eobj);
                    }
                    found = true;
                    break;
                }
            }
            if (found) continue;
            throw new AnnotationParserException("The eclass: " + pee.eClass().getName() + " does not have an efeature for " + eobj.eClass().getName());
        }
    }

    private ArrayList<NamedParserNode> process(EAnnotation ea, ENamedElement ene) {
        ArrayList<NamedParserNode> result = new ArrayList<NamedParserNode>();
        if (!this.isValidSource(ea.getSource(), (EList<EAnnotation>)ene.getEAnnotations())) {
            return result;
        }
        log.debug((Object)"Processing annotations ");
        for (Map.Entry pAnnotationDetails : ea.getDetails().entrySet()) {
            String fName = (String)pAnnotationDetails.getKey();
            if (fName.compareToIgnoreCase("appinfo") != 0 && fName.compareToIgnoreCase("value") != 0) continue;
            log.debug((Object)("Annotation content: \n " + (String)pAnnotationDetails.getValue()));
            String content = this.removeCommentLines((String)pAnnotationDetails.getValue());
            result.addAll(this.annotationParser.parse(ene, content));
        }
        return result;
    }

    private String removeCommentLines(String content) {
        if (content.indexOf("//") == -1) {
            return content;
        }
        String[] lines = content.split("\n");
        StringBuilder sb = new StringBuilder();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (!line.trim().startsWith("//")) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(line);
            }
            ++n2;
        }
        return sb.toString();
    }

    @Override
    public EClass getEClass(String name) {
        if (name.startsWith(JPA_PREFIX)) {
            return this.getEClass(name.substring(JPA_PREFIX.length()));
        }
        return (EClass)PannotationPackage.eINSTANCE.getEClassifier(name);
    }

    protected boolean isValidSource(String source, EList<EAnnotation> eAnnotations) {
        if (source == null) {
            return false;
        }
        if (this.extraAnnotationsSources.length > 0) {
            String[] stringArray = this.extraAnnotationsSources;
            int n = this.extraAnnotationsSources.length;
            int n2 = 0;
            while (n2 < n) {
                String annotationSource = stringArray[n2];
                if (source.equals(annotationSource)) {
                    return true;
                }
                ++n2;
            }
            if (this.persistenceOptions != null && this.persistenceOptions.isExtraAnnotationsOverridesDefault()) {
                for (EAnnotation eAnnotation : eAnnotations) {
                    String[] stringArray2 = this.extraAnnotationsSources;
                    int n3 = this.extraAnnotationsSources.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String annotationSource = stringArray2[n4];
                        if (eAnnotation.getSource().equals(annotationSource)) {
                            return false;
                        }
                        ++n4;
                    }
                }
            }
        }
        if (source.equals("teneo.jpa.auditing")) {
            return false;
        }
        return source.startsWith("teneo.jpa") || source.startsWith("teneo.mapping");
    }

    @Override
    public EStructuralFeature getEStructuralFeature(EClass eClass, String name) {
        return ParserUtil.getEStructuralFeature(eClass, name);
    }

    public void setExtraAnnotationSources(PersistenceOptions po) {
        this.persistenceOptions = po;
        if (po.getExtraAnnotationSources() != null && po.getExtraAnnotationSources().trim().length() > 0) {
            this.extraAnnotationsSources = po.getExtraAnnotationSources().split(",");
            int i = 0;
            while (i < this.extraAnnotationsSources.length) {
                this.extraAnnotationsSources[i] = this.extraAnnotationsSources[i].trim();
                if (this.extraAnnotationsSources[i].startsWith("teneo.jpa") || this.extraAnnotationsSources[i].startsWith("teneo.mapping")) {
                    log.warn((Object)("Extra annotation source (" + this.extraAnnotationsSources[i] + ") starts with the default Teneo annotation source: " + "teneo.jpa" + " or " + "teneo.mapping" + ". Annotations which should sometimes be " + "ignored or disabled should not start with these values as they are always considered by Teneo"));
                }
                ++i;
            }
        }
    }
}

