/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapper;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEAttribute;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEReference;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pannotation.CascadeType;
import org.eclipse.emf.teneo.annotations.pannotation.Column;
import org.eclipse.emf.teneo.annotations.pannotation.FetchType;
import org.eclipse.emf.teneo.annotations.pannotation.JoinColumn;
import org.eclipse.emf.teneo.annotations.pannotation.JoinTable;
import org.eclipse.emf.teneo.annotations.pannotation.MapKey;
import org.eclipse.emf.teneo.annotations.pannotation.PAnnotation;
import org.eclipse.emf.teneo.hibernate.hbannotation.Cascade;
import org.eclipse.emf.teneo.hibernate.hbannotation.HbCascadeType;
import org.eclipse.emf.teneo.hibernate.hbannotation.HbMapKey;
import org.eclipse.emf.teneo.hibernate.hbannotation.IdBag;
import org.eclipse.emf.teneo.hibernate.hbannotation.Index;
import org.eclipse.emf.teneo.hibernate.hbannotation.MapKeyManyToMany;
import org.eclipse.emf.teneo.hibernate.hbannotation.Parameter;
import org.eclipse.emf.teneo.hibernate.hbannotation.Type;
import org.eclipse.emf.teneo.hibernate.hbmodel.HbAnnotatedEClass;
import org.eclipse.emf.teneo.hibernate.hbmodel.HbAnnotatedEReference;
import org.eclipse.emf.teneo.hibernate.hbmodel.HbAnnotatedETypeElement;
import org.eclipse.emf.teneo.hibernate.mapper.AbstractMapper;
import org.eclipse.emf.teneo.hibernate.mapper.MappingException;
import org.eclipse.emf.teneo.mapping.strategy.SQLNameStrategy;
import org.eclipse.emf.teneo.mapping.strategy.impl.ClassicSQLNameStrategy;
import org.eclipse.emf.teneo.simpledom.Element;
import org.eclipse.emf.teneo.util.StoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAssociationMapper
extends AbstractMapper {
    private static final Log log = LogFactory.getLog(AbstractAssociationMapper.class);

    protected Element addOneToOne(PAnnotatedEReference aReference, String assocName, String targetEntity) {
        HbAnnotatedEReference hae;
        PAnnotatedEClass referedToAClass = aReference.getAReferenceType();
        Element element = referedToAClass.isOnlyMapAsEntity() || !this.getHbmContext().forceUseOfInstance(referedToAClass) ? this.getHbmContext().getCurrent().addElement("one-to-one").addAttribute("name", assocName).addAttribute("entity-name", targetEntity) : this.getHbmContext().getCurrent().addElement("one-to-one").addAttribute("name", assocName).addAttribute("class", this.getHbmContext().getInstanceClassName(referedToAClass.getModelEClass()));
        if (aReference instanceof HbAnnotatedEReference && (hae = (HbAnnotatedEReference)aReference).getHbFetch() != null) {
            element.addAttribute("fetch", hae.getHbFetch().getValue().getName().toLowerCase());
        }
        return element;
    }

    protected List<HbCascadeType> getCascades(Cascade cascade, List<CascadeType> cascades) {
        if (cascade != null) {
            return cascade.getValue();
        }
        return this.convertCascade(cascades);
    }

    protected List<HbCascadeType> convertCascade(List<CascadeType> cascades) {
        ArrayList<HbCascadeType> res = new ArrayList<HbCascadeType>();
        for (CascadeType ct : cascades) {
            if (ct == CascadeType.ALL) {
                res.add(HbCascadeType.ALL);
                continue;
            }
            if (ct == CascadeType.MERGE) {
                res.add(HbCascadeType.MERGE);
                continue;
            }
            if (ct == CascadeType.PERSIST) {
                res.add(HbCascadeType.PERSIST);
                res.add(HbCascadeType.SAVE_UPDATE);
                res.add(HbCascadeType.LOCK);
                continue;
            }
            if (ct == CascadeType.REFRESH) {
                res.add(HbCascadeType.REFRESH);
                continue;
            }
            if (ct == CascadeType.REMOVE) {
                res.add(HbCascadeType.REMOVE);
                continue;
            }
            if (ct != CascadeType.NONE) continue;
            return new ArrayList<HbCascadeType>();
        }
        return res;
    }

    protected Element addManyToOne(Element currentParent, PAnnotatedEReference aReference, String referedTo, boolean isPartOfKey) {
        HbAnnotatedEReference hae;
        String assocName = this.getHbmContext().getPropertyName((EStructuralFeature)aReference.getModelEReference());
        log.debug((Object)("addManyToOne " + assocName + "/" + referedTo));
        if (((HbAnnotatedEReference)aReference).getHbType() != null) {
            String tagName = "property";
            Element element = currentParent.addElement(tagName).addAttribute("name", assocName);
            Type hbType = ((HbAnnotatedEReference)aReference).getHbType();
            EList<Parameter> params = hbType.getParameters();
            if (params == null || params.isEmpty()) {
                element.addAttribute("type", hbType.getType());
            } else {
                Element typeElement = element.addElement("type").addAttribute("name", hbType.getType());
                for (Parameter param : params) {
                    typeElement.addElement("param").addAttribute("name", param.getName()).addText(param.getValue());
                }
            }
            return element;
        }
        String tagName = isPartOfKey ? "key-many-to-one" : "many-to-one";
        EClass referedToEClass = aReference.getModelEReference().getEReferenceType();
        PAnnotatedEClass referedToAClass = aReference.getPaModel().getPAnnotated(referedToEClass);
        Element element = referedToAClass.isOnlyMapAsEntity() || !this.getHbmContext().forceUseOfInstance(referedToAClass) ? currentParent.addElement(tagName).addAttribute("name", assocName).addAttribute("entity-name", referedTo) : currentParent.addElement(tagName).addAttribute("name", assocName).addAttribute("class", this.getHbmContext().getInstanceClassName(referedToEClass));
        if (aReference instanceof HbAnnotatedEReference && (hae = (HbAnnotatedEReference)aReference).getHbFetch() != null) {
            element.addAttribute("fetch", hae.getHbFetch().getValue().getName().toLowerCase());
        }
        return element;
    }

    protected void addJoinColumns(PAnnotatedEReference per, Element associationElement, List<JoinColumn> joinColumns, boolean forceNullable) {
        log.debug((Object)("addJoinColumns " + associationElement.getName() + "/ no of joincolumns" + joinColumns.size()));
        boolean insertable = true;
        boolean updatable = true;
        for (JoinColumn joinColumn : joinColumns) {
            Index index;
            log.debug((Object)("JoinColumn " + joinColumn.getName()));
            Element columnElement = associationElement.addElement("column").addAttribute("not-null", joinColumn.isNullable() && joinColumn.isSetNullable() || forceNullable ? "false" : "true").addAttribute("unique", joinColumn.isUnique() ? "true" : "false");
            if (joinColumn.getName() != null) {
                columnElement.addAttribute("name", this.getHbmContext().trunc(joinColumn.getName()));
                String uc = this.getHbmContext().getUniqueConstraintKey(joinColumn.getName());
                if (uc != null) {
                    columnElement.addAttribute("unique-key", uc);
                }
            }
            if ((index = ((HbAnnotatedETypeElement)per).getHbIndex()) != null) {
                columnElement.addAttribute("index", index.getName());
            }
            insertable &= joinColumn.isInsertable();
            updatable &= joinColumn.isUpdatable();
            this.addCommentElement((EModelElement)per.getModelEReference(), columnElement);
            if (joinColumn.getReferencedColumnName() == null) continue;
            String propName = null;
            String colName = joinColumn.getReferencedColumnName();
            for (PAnnotatedEStructuralFeature pef : per.getPaEClass().getPaEStructuralFeatures()) {
                if (!(pef instanceof PAnnotatedEReference)) continue;
                PAnnotatedEReference paEreference = (PAnnotatedEReference)pef;
                if (pef.getModelElement().getName().equals(colName) && propName == null) {
                    propName = this.getHbmContext().getPropertyName((EStructuralFeature)paEreference.getModelEReference());
                }
                if (paEreference.getColumn() == null || !paEreference.getColumn().getName().equals(colName)) continue;
                propName = this.getHbmContext().getPropertyName((EStructuralFeature)paEreference.getModelEReference());
            }
            if (propName != null) {
                associationElement.addAttribute("property-ref", propName);
                continue;
            }
            log.warn((Object)("No property found for the referencedColumnName  " + colName + " and EReference " + per.getModelElement().getName()));
        }
        if (associationElement.getName().compareTo("map-key-many-to-many") != 0 && associationElement.getName().compareTo("join") != 0 && associationElement.getName().compareTo("key-many-to-one") != 0) {
            associationElement.addAttribute("insert", Boolean.toString(insertable));
            associationElement.addAttribute("update", Boolean.toString(updatable));
        }
    }

    protected void addCascadesForSingle(Element associationElement, List<HbCascadeType> cascades) {
        this.addCascades(associationElement, cascades, false);
    }

    protected void addForeignKeyAttribute(Element manyElement, PAnnotatedEStructuralFeature aFeature) {
        if (aFeature.getForeignKey() != null) {
            manyElement.addAttribute("foreign-key", aFeature.getForeignKey().getName());
        }
    }

    protected void addCascadesForMany(Element associationElement, List<HbCascadeType> cascades) {
        this.addCascades(associationElement, cascades, true);
    }

    protected void addFetchType(Element associationElement, FetchType fetch) {
        if (fetch == null) {
            return;
        }
        if (FetchType.EXTRA.equals((Object)fetch)) {
            associationElement.addAttribute("lazy", "extra");
        } else {
            associationElement.addAttribute("lazy", FetchType.LAZY.equals((Object)fetch) ? "true" : "false");
        }
    }

    protected void addLazyProxy(Element element, FetchType fetch, PAnnotatedEReference paReference) {
        boolean doProxy;
        HbAnnotatedEClass haClass = (HbAnnotatedEClass)paReference.getAReferenceType();
        boolean lazyFetch = fetch == null || fetch == FetchType.LAZY;
        boolean bl = doProxy = lazyFetch && haClass.getHbProxy() != null && haClass.getHbProxy().isLazy();
        if (doProxy && lazyFetch) {
            element.addAttribute("lazy", "proxy");
        } else {
            element.addAttribute("lazy", "false");
        }
    }

    protected void addListIndex(Element collElement, PAnnotatedEStructuralFeature aFeature) {
        String name = this.getIndexColumnName(aFeature);
        log.debug((Object)("Add list index " + name + " to " + aFeature.getModelEStructuralFeature().getName()));
        collElement.addElement("list-index").addAttribute("column", this.getHbmContext().trunc(name));
    }

    protected String getIndexColumnName(PAnnotatedEStructuralFeature aFeature) {
        SQLNameStrategy sqlNameStrategy = (SQLNameStrategy)this.getHbmContext().getExtensionManager().getExtension(SQLNameStrategy.class);
        if (aFeature.getListIndexColumn() != null) {
            return aFeature.getListIndexColumn().getName();
        }
        if (sqlNameStrategy instanceof ClassicSQLNameStrategy) {
            return ((ClassicSQLNameStrategy)sqlNameStrategy).getIndexColumnName(aFeature);
        }
        return String.valueOf(this.getHbmContext().getPersistenceOptions().getSQLColumnNamePrefix()) + (String.valueOf(aFeature.getPaEClass().getModelEClass().getName()) + "_" + aFeature.getModelEStructuralFeature().getName() + "_IDX").toUpperCase();
    }

    protected void addMapKey(Element collElement, PAnnotatedEReference aref) {
        EReference eref = aref.getModelEReference();
        HbAnnotatedEReference hbRef = (HbAnnotatedEReference)aref;
        EStructuralFeature keyFeature = eref.getEReferenceType().getEStructuralFeature("key");
        if (hbRef.getHbMapKey() != null && hbRef.getMapKey() != null) {
            log.warn((Object)("The EReference " + aref.getModelElement().getName() + " has both a javax.persistence.MapKey as well as a hibernate MapKey annotation this is not correct, only one of the two should be used."));
        }
        if (keyFeature == null) {
            throw new IllegalArgumentException("The EFeature " + eref.getName() + " of EClass " + eref.getEContainingClass().getName() + " does not have a keyfeature. " + "Are you sure that this feature is an EMap");
        }
        if (hbRef.getHbMapKey() != null) {
            HbMapKey mapKey = hbRef.getHbMapKey();
            PAnnotatedEAttribute paAttribute = (PAnnotatedEAttribute)aref.getPaModel().getPAnnotated(keyFeature);
            Element mapKeyElement = collElement.addElement("map-key");
            if (mapKey.getColumns() != null && mapKey.getColumns().size() > 0) {
                this.addColumnsAndFormula(mapKeyElement, (PAnnotatedEStructuralFeature)aref, (List<Column>)mapKey.getColumns(), false, false, false, false);
            }
            this.setType(paAttribute, mapKeyElement);
        } else if (hbRef.getMapKey() != null) {
            MapKey mapKey = hbRef.getMapKey();
            PAnnotatedEAttribute paAttribute = (PAnnotatedEAttribute)aref.getPaModel().getPAnnotated(keyFeature);
            Element mapKeyElement = collElement.addElement("map-key").addAttribute("column", this.getHbmContext().trunc(mapKey.getName()));
            this.setType(paAttribute, mapKeyElement);
        } else if (hbRef.getMapKeyManyToMany() != null) {
            MapKeyManyToMany mkm = hbRef.getMapKeyManyToMany();
            PAnnotatedEClass referedAClass = aref.getPaModel().getPAnnotated(((EReference)keyFeature).getEReferenceType());
            Element mkmElement = collElement.addElement("map-key-many-to-many");
            if (referedAClass.isOnlyMapAsEntity() || !this.getHbmContext().forceUseOfInstance(referedAClass)) {
                String entityName = mkm.getTargetEntity() != null ? mkm.getTargetEntity() : this.hbmContext.getEntityName(((EReference)keyFeature).getEReferenceType());
                mkmElement.addAttribute("entity-name", entityName);
            } else {
                mkmElement.addAttribute("class", this.getHbmContext().getInstanceClassName(referedAClass.getModelEClass()));
            }
            if (mkm.getJoinColumns() != null && mkm.getJoinColumns().size() > 0) {
                this.addJoinColumns(hbRef, mkmElement, (List<JoinColumn>)mkm.getJoinColumns(), false);
            }
        } else if (keyFeature instanceof EReference) {
            PAnnotatedEClass referedAClass = aref.getPaModel().getPAnnotated(((EReference)keyFeature).getEReferenceType());
            if (referedAClass.isOnlyMapAsEntity() || !this.getHbmContext().forceUseOfInstance(referedAClass)) {
                String entityName = this.hbmContext.getEntityName(((EReference)keyFeature).getEReferenceType());
                collElement.addElement("map-key-many-to-many").addAttribute("entity-name", entityName);
            } else {
                collElement.addElement("map-key-many-to-many").addAttribute("class", this.getHbmContext().getInstanceClassName(referedAClass.getModelEClass()));
            }
        } else {
            Element mapKey = collElement.addElement("map-key");
            PAnnotatedEAttribute paAttribute = aref.getPaModel().getPAnnotated((EAttribute)keyFeature);
            this.setType(paAttribute, mapKey);
        }
    }

    protected Element addCollectionElement(PAnnotatedEStructuralFeature paFeature) {
        boolean hasBatchSize;
        HbAnnotatedEReference hae;
        Element collectionElement;
        boolean hasWhereClause;
        HbAnnotatedETypeElement hbFeature = (HbAnnotatedETypeElement)paFeature;
        IdBag idBag = hbFeature.getHbIdBag();
        EStructuralFeature estruct = paFeature.getModelEStructuralFeature();
        boolean isArray = estruct instanceof EAttribute && estruct.getEType().getInstanceClass() != null && estruct.getEType().getInstanceClass().isArray();
        boolean isMap = StoreUtil.isMap((EStructuralFeature)estruct) && this.getHbmContext().isMapEMapAsTrueMap();
        boolean hasOrderBy = paFeature instanceof PAnnotatedEReference && ((PAnnotatedEReference)paFeature).getOrderBy() != null;
        boolean bl = hasWhereClause = paFeature instanceof PAnnotatedEReference && ((HbAnnotatedEReference)paFeature).getHbWhere() != null;
        if (isArray) {
            collectionElement = this.getHbmContext().getCurrent().addElement("array");
        } else if (isMap) {
            collectionElement = this.getHbmContext().getCurrent().addElement("map");
        } else if (idBag != null) {
            collectionElement = this.getHbmContext().getCurrent().addElement("idbag");
        } else if (this.getHbmContext().isGeneratedByEMF() && hbFeature.getOneToMany() != null && hbFeature.getOneToMany().isList()) {
            if (hasOrderBy && hbFeature.getOneToMany().isIndexed()) {
                log.warn((Object)("One to many ereference has indexed=true and has orderby set. Ignoring indexed and using orderby, assuming set " + hbFeature));
            }
            collectionElement = hasOrderBy || !hbFeature.getOneToMany().isIndexed() ? this.getHbmContext().getCurrent().addElement("bag") : this.getHbmContext().getCurrent().addElement("list");
        } else if (!this.getHbmContext().isGeneratedByEMF() && hbFeature.getOneToMany() != null) {
            if (hasOrderBy && hbFeature.getOneToMany().isIndexed()) {
                log.warn((Object)("One to many ereference has indexed=true and has orderby set. Ignoring indexed and using orderby, assuming set " + hbFeature));
            }
            collectionElement = !hbFeature.getOneToMany().isList() || hasOrderBy ? this.getHbmContext().getCurrent().addElement("set") : (hbFeature.getOneToMany().isList() && !hbFeature.getOneToMany().isIndexed() ? this.getHbmContext().getCurrent().addElement("bag") : this.getHbmContext().getCurrent().addElement("list"));
        } else {
            collectionElement = hbFeature instanceof PAnnotatedEReference && ((PAnnotatedEReference)hbFeature).getManyToMany() != null && ((PAnnotatedEReference)hbFeature).getManyToMany().isList() ? this.getHbmContext().getCurrent().addElement("list") : this.getHbmContext().getCurrent().addElement("bag");
        }
        collectionElement.addAttribute("name", this.getHbmContext().getPropertyName(hbFeature.getModelEStructuralFeature()));
        if (idBag != null) {
            String generator = idBag.getGenerator() == null ? "increment" : idBag.getGenerator();
            String type = idBag.getType() == null ? "long" : idBag.getType();
            Element collectionIdElement = collectionElement.addElement("collection-id");
            collectionIdElement.addAttribute("column", this.hbmContext.getIdbagIDColumnName());
            collectionIdElement.addAttribute("type", type);
            collectionIdElement.addElement("generator").addAttribute("class", generator);
        }
        if (hbFeature instanceof HbAnnotatedEReference && (hae = (HbAnnotatedEReference)hbFeature).getHbFetch() != null) {
            collectionElement.addAttribute("fetch", hae.getHbFetch().getValue().getName().toLowerCase());
        }
        if (hasOrderBy) {
            PAnnotatedEClass aClass = ((PAnnotatedEReference)paFeature).getAReferenceType();
            String name = this.getColumnNameForOrderBy(aClass, ((PAnnotatedEReference)paFeature).getOrderBy().getValue());
            collectionElement.addAttribute("order-by", name);
        }
        if (hasWhereClause) {
            collectionElement.addAttribute("where", ((HbAnnotatedEReference)paFeature).getHbWhere().getClause());
        }
        boolean bl2 = hasBatchSize = paFeature instanceof HbAnnotatedEReference && ((HbAnnotatedEReference)paFeature).getBatchSize() != null;
        if (hasBatchSize) {
            collectionElement.addAttribute("batch-size", "" + ((HbAnnotatedEReference)paFeature).getBatchSize().getSize());
        }
        return collectionElement;
    }

    protected String getColumnNameForOrderBy(PAnnotatedEClass aClass, String orderBy) {
        String[] orderBys;
        StringBuilder sb = new StringBuilder();
        String[] stringArray = orderBys = orderBy.split(",");
        int n = orderBys.length;
        int n2 = 0;
        while (n2 < n) {
            String ob = stringArray[n2];
            ob = ob.trim();
            String direction = " asc";
            if (ob.indexOf(" ") != -1) {
                int index = ob.lastIndexOf(" ");
                direction = ob.substring(index);
                if ((ob = ob.substring(0, index).trim()).trim().startsWith(this.getHbmContext().getEscapeCharacter())) {
                    ob = ob.trim().substring(this.getHbmContext().getEscapeCharacter().length());
                }
                if (ob.trim().endsWith(this.getHbmContext().getEscapeCharacter())) {
                    ob = ob.trim().substring(0, ob.trim().length() - this.getHbmContext().getEscapeCharacter().length());
                }
            }
            boolean found = false;
            for (PAnnotatedEStructuralFeature aFeature : this.getAllFeatures(aClass)) {
                if (aFeature.getModelElement().getName().compareTo(ob) != 0) continue;
                if (aFeature instanceof PAnnotatedEReference) {
                    throw new MappingException("Feature " + ob + " is an ereference, onle eattribute is supported");
                }
                found = true;
                PAnnotatedEAttribute attr = (PAnnotatedEAttribute)aFeature;
                List<Column> cs = this.getColumns((PAnnotatedEStructuralFeature)attr);
                if (cs.isEmpty()) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(String.valueOf(this.escapeName(this.getColumnName((PAnnotatedEStructuralFeature)attr))) + direction);
                    continue;
                }
                for (Column c : cs) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(String.valueOf(this.escapeName(c.getName())) + direction);
                }
            }
            if (!found) {
                throw new MappingException("Feature " + ob + " not found in eclass " + aClass.getModelEClass().getName());
            }
            ++n2;
        }
        return sb.toString();
    }

    private String escapeName(String name) {
        if (name.startsWith(this.getHbmContext().getEscapeCharacter())) {
            return name;
        }
        return String.valueOf(this.getHbmContext().getEscapeCharacter()) + name + this.getHbmContext().getEscapeCharacter();
    }

    protected Element addElementElement(Element collElement, PAnnotatedEStructuralFeature paFeature, List<Column> columns, String targetEntity) {
        Element elElement = collElement.addElement("element");
        this.setType(paFeature, elElement);
        if (columns != null && columns.size() > 0) {
            this.addColumnsAndFormula(elElement, paFeature, columns, this.getHbmContext().isCurrentElementFeatureMap(), true);
        }
        return elElement;
    }

    protected void addKeyColumns(HbAnnotatedETypeElement per, Element keyElement, List<JoinColumn> joinColumns) {
        log.debug((Object)"Adding key columns");
        boolean setUpdatable = false;
        boolean isUpdatable = false;
        for (JoinColumn joinColumn : joinColumns) {
            log.debug((Object)("Column " + joinColumn.getName()));
            if (!setUpdatable && keyElement.getName().compareTo("key") == 0) {
                isUpdatable = joinColumn.isUpdatable();
                keyElement.addAttribute("update", isUpdatable ? "true" : "false");
                setUpdatable = true;
            }
            if (!joinColumn.isInsertable()) {
                log.error((Object)("Unsupported non insertable join column in " + joinColumn));
                throw new MappingException("Unsupported non insertable join column", (PAnnotation)joinColumn);
            }
            if (setUpdatable && joinColumn.isUpdatable() != isUpdatable) {
                log.error((Object)("Unsupported join column updatable in " + joinColumn));
                throw new MappingException("Unsupported join column updatable", (PAnnotation)joinColumn);
            }
            Element ce = keyElement.addElement("column").addAttribute("name", this.getHbmContext().trunc(joinColumn.getName())).addAttribute("not-null", joinColumn.isNullable() ? "false" : "true").addAttribute("unique", joinColumn.isUnique() ? "true" : "false");
            this.addCommentElement((EModelElement)per.getModelElement(), ce);
            Index index = per.getHbIndex();
            if (index != null) {
                ce.addAttribute("index", index.getName());
            }
            if (joinColumn.getReferencedColumnName() != null) {
                String propName = null;
                String colName = joinColumn.getReferencedColumnName();
                for (PAnnotatedEStructuralFeature pef : per.getPaEClass().getPaEStructuralFeatures()) {
                    if (pef.getModelElement().getName().equals(colName) && propName == null) {
                        propName = this.getHbmContext().getPropertyName(pef.getModelEStructuralFeature());
                    }
                    if (pef.getColumn() == null || !pef.getColumn().getName().equals(colName)) continue;
                    propName = this.getHbmContext().getPropertyName(pef.getModelEStructuralFeature());
                }
                if (propName != null) {
                    keyElement.addAttribute("property-ref", propName);
                } else {
                    log.warn((Object)("No property found for the referencedColumnName  " + colName + " and EReference " + per.getModelElement().getName()));
                }
            }
            if (joinColumn.getColumnDefinition() == null) continue;
            log.error((Object)("Unsupported column definition in " + joinColumn));
            throw new MappingException("Unsupported column definition", (PAnnotation)joinColumn);
        }
    }

    protected void addJoinTable(HbAnnotatedETypeElement hbAnnotatedElement, Element collElement, Element keyElement, JoinTable joinTable) {
        if (joinTable == null) {
            log.debug((Object)"No joinTable");
            return;
        }
        if (joinTable.getCatalog() != null) {
            collElement.addAttribute("catalog", joinTable.getCatalog());
        }
        if (joinTable.getSchema() != null) {
            collElement.addAttribute("schema", joinTable.getSchema());
        }
        if (joinTable.getName() != null) {
            collElement.addAttribute("table", this.getHbmContext().trunc(joinTable.getName()));
        }
        if (joinTable.getUniqueConstraints().size() > 0) {
            log.error((Object)("Unsupported unique constraints in " + joinTable));
            throw new MappingException("Unsupported unique constraints", (PAnnotation)joinTable);
        }
        this.addKeyColumns(hbAnnotatedElement, keyElement, (List<JoinColumn>)joinTable.getJoinColumns());
    }
}

