/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.workspace.examples.extlibrary.presentation;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.MarkerHelper;
import org.eclipse.emf.common.ui.ViewerPane;
import org.eclipse.emf.common.ui.editor.ProblemEditorPart;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.emf.examples.extlibrary.provider.EXTLibraryItemProviderAdapterFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.ui.provider.TransactionalAdapterFactoryContentProvider;
import org.eclipse.emf.transaction.ui.provider.TransactionalAdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.ui.view.ExtendedPropertySheetPage;
import org.eclipse.emf.workspace.EMFCommandOperation;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.emf.workspace.ResourceUndoContext;
import org.eclipse.emf.workspace.examples.extlibrary.presentation.EXTLibraryEditorPlugin;
import org.eclipse.emf.workspace.examples.extlibrary.presentation.ResourceLoadedListener;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EXTLibraryEditor
extends MultiPageEditorPart
implements IEditingDomainProvider,
ISelectionProvider,
IMenuListener,
IViewerProvider,
IGotoMarker {
    protected AdapterFactoryEditingDomain editingDomain;
    protected IUndoContext undoContext;
    protected Resource resource;
    protected ComposedAdapterFactory adapterFactory;
    protected IContentOutlinePage contentOutlinePage;
    protected IStatusLineManager contentOutlineStatusLineManager;
    protected TreeViewer contentOutlineViewer;
    protected PropertySheetPage propertySheetPage;
    protected TreeViewer selectionViewer;
    protected ViewerPane currentViewerPane;
    protected Viewer currentViewer;
    protected ISelectionChangedListener selectionChangedListener;
    protected Collection<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    protected ISelection editorSelection = StructuredSelection.EMPTY;
    protected MarkerHelper markerHelper = new EditUIMarkerHelper();
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart p) {
            if (p instanceof ContentOutline) {
                if (((ContentOutline)p).getCurrentPage() == EXTLibraryEditor.this.contentOutlinePage) {
                    EXTLibraryEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)EXTLibraryEditor.this);
                    EXTLibraryEditor.this.setCurrentViewer((Viewer)EXTLibraryEditor.this.contentOutlineViewer);
                }
            } else if (p instanceof PropertySheet) {
                if (((PropertySheet)p).getCurrentPage() == EXTLibraryEditor.this.propertySheetPage) {
                    EXTLibraryEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)EXTLibraryEditor.this);
                    EXTLibraryEditor.this.handleActivate();
                }
            } else if (p == EXTLibraryEditor.this) {
                EXTLibraryEditor.this.handleActivate();
            }
        }

        public void partBroughtToTop(IWorkbenchPart p) {
        }

        public void partClosed(IWorkbenchPart p) {
        }

        public void partDeactivated(IWorkbenchPart p) {
        }

        public void partOpened(IWorkbenchPart p) {
        }
    };
    protected Collection<Resource> removedResources = new ArrayList<Resource>();
    protected Collection<Resource> changedResources = new ArrayList<Resource>();
    protected Map<Resource, URI> movedResources = new HashMap<Resource, URI>();
    protected Collection<Resource> savedResources = new ArrayList<Resource>();
    protected Map<Resource, Diagnostic> resourceToDiagnosticMap = new LinkedHashMap<Resource, Diagnostic>();
    protected boolean updateProblemIndication = true;
    protected EContentAdapter problemIndicationAdapter = new EContentAdapter(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() instanceof Resource) {
                switch (notification.getFeatureID(Resource.class)) {
                    case 4: 
                    case 6: 
                    case 7: {
                        Resource resource = (Resource)notification.getNotifier();
                        Diagnostic diagnostic = EXTLibraryEditor.this.analyzeResourceProblems(resource, null);
                        if (diagnostic.getSeverity() != 0) {
                            EXTLibraryEditor.this.resourceToDiagnosticMap.put(resource, diagnostic);
                        } else {
                            EXTLibraryEditor.this.resourceToDiagnosticMap.remove(resource);
                        }
                        if (!EXTLibraryEditor.this.updateProblemIndication) return;
                        EXTLibraryEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                EXTLibraryEditor.this.updateProblemIndication();
                            }
                        });
                    }
                    default: {
                        return;
                    }
                }
            } else {
                super.notifyChanged(notification);
            }
        }

        protected void setTarget(Resource target) {
            this.basicSetTarget((Notifier)target);
        }

        protected void unsetTarget(Resource target) {
            this.basicUnsetTarget((Notifier)target);
        }
    };
    private IUndoableOperation savedOperation;
    private final IOperationHistoryListener historyListener = new IOperationHistoryListener(){

        public void historyNotification(OperationHistoryEvent event) {
            Set affectedResources = ResourceUndoContext.getAffectedResources((IUndoableOperation)event.getOperation());
            switch (event.getEventType()) {
                case 4: {
                    if (!affectedResources.contains(EXTLibraryEditor.this.getResource())) break;
                    final IUndoableOperation operation = event.getOperation();
                    operation.removeContext(((IWorkspaceCommandStack)EXTLibraryEditor.this.getEditingDomain().getCommandStack()).getDefaultUndoContext());
                    operation.addContext(EXTLibraryEditor.this.getUndoContext());
                    EXTLibraryEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            Command command;
                            EXTLibraryEditor.this.firePropertyChange(257);
                            if (operation instanceof EMFCommandOperation && (command = ((EMFCommandOperation)operation).getCommand()) != null) {
                                EXTLibraryEditor.this.setSelectionToViewer(command.getAffectedObjects());
                            }
                            if ((this).EXTLibraryEditor.this.propertySheetPage != null) {
                                (this).EXTLibraryEditor.this.propertySheetPage.refresh();
                            }
                        }
                    });
                    break;
                }
                case 9: 
                case 10: {
                    if (!affectedResources.contains(EXTLibraryEditor.this.getResource())) break;
                    final IUndoableOperation operation = event.getOperation();
                    EXTLibraryEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            Command command;
                            EXTLibraryEditor.this.firePropertyChange(257);
                            if (operation instanceof EMFCommandOperation && (command = ((EMFCommandOperation)operation).getCommand()) != null) {
                                EXTLibraryEditor.this.setSelectionToViewer(command.getAffectedObjects());
                            }
                            if ((this).EXTLibraryEditor.this.propertySheetPage != null) {
                                (this).EXTLibraryEditor.this.propertySheetPage.refresh();
                            }
                        }
                    });
                }
            }
        }
    };
    protected WorkspaceSynchronizer workspaceSynchronizer;

    protected void handleActivate() {
        this.setCurrentViewer((Viewer)this.selectionViewer);
        if (this.editingDomain.getResourceToReadOnlyMap() != null) {
            this.editingDomain.getResourceToReadOnlyMap().clear();
            this.setSelection(this.getSelection());
        }
        try {
            Resource res = this.getResource();
            if (this.removedResources.contains(res)) {
                if (this.handleDirtyConflict()) {
                    this.getSite().getPage().closeEditor((IEditorPart)this, false);
                }
            } else if (this.movedResources.containsKey(res)) {
                if (this.savedResources.contains(res)) {
                    this.getOperationHistory().dispose(this.undoContext, true, true, true);
                    res.setURI(this.movedResources.remove(res));
                    FileEditorInput newInput = new FileEditorInput(WorkspaceSynchronizer.getFile((Resource)res));
                    this.setInputWithNotify((IEditorInput)newInput);
                    this.setPartName(newInput.getName());
                } else {
                    this.handleMovedResource();
                }
            } else if (this.changedResources.contains(res)) {
                this.changedResources.removeAll(this.savedResources);
                this.handleChangedResource();
            }
        }
        finally {
            this.removedResources.clear();
            this.changedResources.clear();
            this.movedResources.clear();
            this.savedResources.clear();
        }
    }

    private WorkspaceSynchronizer.Delegate createSynchronizationDelegate() {
        return new WorkspaceSynchronizer.Delegate(){

            public boolean handleResourceDeleted(Resource resource) {
                if (resource == EXTLibraryEditor.this.getResource() && !EXTLibraryEditor.this.isDirty()) {
                    EXTLibraryEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            EXTLibraryEditor.this.getSite().getPage().closeEditor((IEditorPart)EXTLibraryEditor.this, false);
                        }
                    });
                } else {
                    EXTLibraryEditor.this.removedResources.add(resource);
                }
                return true;
            }

            public boolean handleResourceChanged(Resource resource) {
                if (EXTLibraryEditor.this.savedResources.contains(resource)) {
                    EXTLibraryEditor.this.savedResources.remove(resource);
                } else {
                    EXTLibraryEditor.this.changedResources.add(resource);
                }
                return true;
            }

            public boolean handleResourceMoved(Resource resource, URI newURI) {
                EXTLibraryEditor.this.movedResources.put(resource, newURI);
                return true;
            }

            public void dispose() {
                EXTLibraryEditor.this.removedResources.clear();
                EXTLibraryEditor.this.changedResources.clear();
                EXTLibraryEditor.this.movedResources.clear();
            }
        };
    }

    protected void handleChangedResource() {
        Resource res = this.getResource();
        if (this.changedResources.contains(res) && (!this.isDirty() || this.handleDirtyConflict())) {
            this.changedResources.remove(res);
            this.getOperationHistory().dispose(this.undoContext, true, true, true);
            this.firePropertyChange(257);
            ResourceLoadedListener listener = ResourceLoadedListener.getDefault();
            listener.ignore(res);
            try {
                if (res.isLoaded()) {
                    res.unload();
                    try {
                        res.load(Collections.EMPTY_MAP);
                    }
                    catch (IOException exception) {
                        EXTLibraryEditorPlugin.INSTANCE.log(exception);
                    }
                }
                this.selectionViewer.setInput((Object)this.getResource());
            }
            finally {
                listener.watch(res);
            }
            this.updateProblemIndication = true;
            this.updateProblemIndication();
        }
    }

    protected void handleMovedResource() {
        if (!this.isDirty() || this.handleDirtyConflict()) {
            Resource res = this.getResource();
            URI newURI = this.movedResources.get(res);
            if (newURI != null) {
                if (res.isLoaded()) {
                    res.unload();
                }
                res.getResourceSet().getResource(newURI, true);
            }
            this.updateProblemIndication = true;
            this.updateProblemIndication();
        }
    }

    protected void updateProblemIndication() {
        if (this.updateProblemIndication) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(0, "org.eclipse.emf.examples.library.editor", 0, null, new Object[]{this.editingDomain.getResourceSet()});
            for (Diagnostic childDiagnostic : this.resourceToDiagnosticMap.values()) {
                if (childDiagnostic.getSeverity() == 0) continue;
                diagnostic.add(childDiagnostic);
            }
            int lastEditorPage = this.getPageCount() - 1;
            if (lastEditorPage >= 0 && this.getEditor(lastEditorPage) instanceof ProblemEditorPart) {
                ((ProblemEditorPart)this.getEditor(lastEditorPage)).setDiagnostic((Diagnostic)diagnostic);
                if (diagnostic.getSeverity() != 0) {
                    this.setActivePage(lastEditorPage);
                }
            } else if (diagnostic.getSeverity() != 0) {
                ProblemEditorPart problemEditorPart = new ProblemEditorPart();
                problemEditorPart.setDiagnostic((Diagnostic)diagnostic);
                problemEditorPart.setMarkerHelper(this.markerHelper);
                try {
                    this.addPage(++lastEditorPage, (IEditorPart)problemEditorPart, this.getEditorInput());
                    this.setPageText(lastEditorPage, problemEditorPart.getPartName());
                    this.setActivePage(lastEditorPage);
                    this.showTabs();
                }
                catch (PartInitException exception) {
                    EXTLibraryEditorPlugin.INSTANCE.log((Object)exception);
                }
            }
            if (this.markerHelper.hasMarkers((Object)this.editingDomain.getResourceSet())) {
                this.markerHelper.deleteMarkers((Object)this.editingDomain.getResourceSet());
                if (diagnostic.getSeverity() != 0) {
                    try {
                        this.markerHelper.createMarkers((Diagnostic)diagnostic);
                    }
                    catch (CoreException exception) {
                        EXTLibraryEditorPlugin.INSTANCE.log((Object)exception);
                    }
                }
            }
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)EXTLibraryEditor.getString("_UI_FileConflict_label"), (String)EXTLibraryEditor.getString("_WARN_FileConflict"));
    }

    public EXTLibraryEditor() {
        this.initializeEditingDomain();
    }

    protected void initializeEditingDomain() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new EXTLibraryItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this.editingDomain = (AdapterFactoryEditingDomain)TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain("org.eclipse.emf.workspace.examples.LibraryEditingDomain");
        this.undoContext = new ObjectUndoContext((Object)this, EXTLibraryEditorPlugin.getPlugin().getString("_UI_EXTLibraryEditor_label"));
        this.getOperationHistory().addOperationHistoryListener(this.historyListener);
    }

    protected void firePropertyChange(int action) {
        super.firePropertyChange(action);
    }

    public void setSelectionToViewer(Collection<?> collection) {
        final Collection<?> theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    if (EXTLibraryEditor.this.currentViewer != null) {
                        EXTLibraryEditor.this.currentViewer.setSelection((ISelection)new StructuredSelection(theSelection.toArray()), true);
                    }
                }
            };
            runnable.run();
        }
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void setCurrentViewerPane(ViewerPane viewerPane) {
        if (this.currentViewerPane != viewerPane) {
            if (this.currentViewerPane != null) {
                this.currentViewerPane.showFocus(false);
            }
            this.currentViewerPane = viewerPane;
        }
        this.setCurrentViewer(this.currentViewerPane.getViewer());
    }

    public void setCurrentViewer(Viewer viewer) {
        if (this.currentViewer != viewer) {
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                        EXTLibraryEditor.this.setSelection(selectionChangedEvent.getSelection());
                    }
                };
            }
            if (this.currentViewer != null) {
                this.currentViewer.removeSelectionChangedListener(this.selectionChangedListener);
            }
            if (viewer != null) {
                viewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.currentViewer = viewer;
            this.setSelection((ISelection)(this.currentViewer == null ? StructuredSelection.EMPTY : this.currentViewer.getSelection()));
        }
    }

    public Viewer getViewer() {
        return this.currentViewer;
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter((EditingDomain)this.editingDomain, (Viewer)viewer));
    }

    public void createModel() {
        URI resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput());
        Exception exception = null;
        this.resource = null;
        try {
            this.resource = this.editingDomain.getResourceSet().getResource(resourceURI, true);
        }
        catch (Exception e) {
            exception = e;
            this.resource = this.editingDomain.getResourceSet().getResource(resourceURI, false);
        }
        Diagnostic diagnostic = this.analyzeResourceProblems(this.resource, exception);
        if (diagnostic.getSeverity() != 0) {
            this.resourceToDiagnosticMap.put(this.resource, this.analyzeResourceProblems(this.resource, exception));
        }
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.problemIndicationAdapter);
    }

    public Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
        if (!resource.getErrors().isEmpty() || !resource.getWarnings().isEmpty()) {
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "org.eclipse.emf.workspace.examples.library.editor", 0, EXTLibraryEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception == null ? resource : exception});
            basicDiagnostic.merge(EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true));
            return basicDiagnostic;
        }
        if (exception != null) {
            return new BasicDiagnostic(4, "org.eclipse.emf.workspace.examples.library.editor", 0, EXTLibraryEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception});
        }
        return Diagnostic.OK_INSTANCE;
    }

    protected Resource getResource() {
        return this.resource;
    }

    public IUndoContext getUndoContext() {
        return this.undoContext;
    }

    public void createPages() {
        this.createModel();
        if (this.getResource() != null && !this.getResource().getContents().isEmpty()) {
            ViewerPane viewerPane = new ViewerPane(this.getSite().getPage(), (IWorkbenchPart)this){

                public Viewer createViewer(Composite composite) {
                    Tree tree = new Tree(composite, 2);
                    TreeViewer newTreeViewer = new TreeViewer(tree);
                    return newTreeViewer;
                }

                public void requestActivation() {
                    super.requestActivation();
                    EXTLibraryEditor.this.setCurrentViewerPane(this);
                }
            };
            viewerPane.createControl(this.getContainer());
            this.selectionViewer = (TreeViewer)viewerPane.getViewer();
            this.selectionViewer.setContentProvider((IContentProvider)new TransactionalAdapterFactoryContentProvider((TransactionalEditingDomain)this.getEditingDomain(), (AdapterFactory)this.adapterFactory));
            this.selectionViewer.setLabelProvider((IBaseLabelProvider)new TransactionalAdapterFactoryLabelProvider((TransactionalEditingDomain)this.getEditingDomain(), (AdapterFactory)this.adapterFactory));
            this.selectionViewer.setInput((Object)this.getResource());
            this.selectionViewer.setSelection((ISelection)new StructuredSelection((Object)this.getResource()), true);
            viewerPane.setTitle((Object)this.getResource());
            new AdapterFactoryTreeEditor(this.selectionViewer.getTree(), (AdapterFactory)this.adapterFactory);
            this.createContextMenuFor((StructuredViewer)this.selectionViewer);
            int pageIndex = this.addPage(viewerPane.getControl());
            this.setPageText(pageIndex, EXTLibraryEditor.getString("_UI_SelectionPage_label"));
        }
        this.getContainer().addControlListener((ControlListener)new ControlAdapter(){
            boolean guard = false;

            public void controlResized(ControlEvent event) {
                if (!this.guard) {
                    this.guard = true;
                    EXTLibraryEditor.this.hideTabs();
                    this.guard = false;
                }
            }
        });
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                EXTLibraryEditor.this.updateProblemIndication();
            }
        });
    }

    protected void hideTabs() {
        if (this.getPageCount() <= 1) {
            this.setPageText(0, "");
            if (this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y + 6);
            }
        }
    }

    protected void showTabs() {
        if (this.getPageCount() > 1) {
            this.setPageText(0, EXTLibraryEditor.getString("_UI_SelectionPage_label"));
            if (this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(-1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y - 6);
            }
        }
    }

    public Object getAdapter(Class key) {
        if (key.equals(IContentOutlinePage.class)) {
            return this.showOutlineView() ? this.getContentOutlinePage() : null;
        }
        if (key.equals(IPropertySheetPage.class)) {
            return this.getPropertySheetPage();
        }
        if (key.equals(IGotoMarker.class)) {
            return this;
        }
        if (key.equals(IUndoContext.class)) {
            return this.undoContext;
        }
        return super.getAdapter(key);
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            class MyContentOutlinePage
            extends ContentOutlinePage {
                MyContentOutlinePage() {
                }

                public void createControl(Composite parent) {
                    super.createControl(parent);
                    EXTLibraryEditor.this.contentOutlineViewer = this.getTreeViewer();
                    EXTLibraryEditor.this.contentOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                    EXTLibraryEditor.this.contentOutlineViewer.setContentProvider((IContentProvider)new TransactionalAdapterFactoryContentProvider((TransactionalEditingDomain)EXTLibraryEditor.this.getEditingDomain(), (AdapterFactory)EXTLibraryEditor.this.adapterFactory));
                    EXTLibraryEditor.this.contentOutlineViewer.setLabelProvider((IBaseLabelProvider)new TransactionalAdapterFactoryLabelProvider((TransactionalEditingDomain)EXTLibraryEditor.this.getEditingDomain(), (AdapterFactory)EXTLibraryEditor.this.adapterFactory));
                    EXTLibraryEditor.this.contentOutlineViewer.setInput((Object)EXTLibraryEditor.this.getResource());
                    EXTLibraryEditor.this.createContextMenuFor((StructuredViewer)EXTLibraryEditor.this.contentOutlineViewer);
                    if (!EXTLibraryEditor.this.editingDomain.getResourceSet().getResources().isEmpty()) {
                        ArrayList<Resource> selection = new ArrayList<Resource>();
                        selection.add(EXTLibraryEditor.this.getResource());
                        EXTLibraryEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(selection), true);
                    }
                }

                public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
                    super.makeContributions(menuManager, toolBarManager, statusLineManager);
                    EXTLibraryEditor.this.contentOutlineStatusLineManager = statusLineManager;
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    EXTLibraryEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            }
            this.contentOutlinePage = new MyContentOutlinePage();
            this.contentOutlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    EXTLibraryEditor.this.handleContentOutlineSelection(event.getSelection());
                }
            });
        }
        return this.contentOutlinePage;
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new ExtendedPropertySheetPage(this.editingDomain){

                public void setSelectionToViewer(List<?> selection) {
                    EXTLibraryEditor.this.setSelectionToViewer(selection);
                    EXTLibraryEditor.this.setFocus();
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    EXTLibraryEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            };
            this.propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new TransactionalAdapterFactoryContentProvider((TransactionalEditingDomain)this.getEditingDomain(), (AdapterFactory)this.adapterFactory));
        }
        return this.propertySheetPage;
    }

    public void handleContentOutlineSelection(ISelection selection) {
        Iterator selectedElements;
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (selectedElements = ((IStructuredSelection)selection).iterator()).hasNext()) {
            Object selectedElement = selectedElements.next();
            ArrayList selectionList = new ArrayList();
            selectionList.add(selectedElement);
            while (selectedElements.hasNext()) {
                selectionList.add(selectedElements.next());
            }
            this.selectionViewer.setSelection((ISelection)new StructuredSelection(selectionList));
        }
    }

    public boolean isDirty() {
        IUndoableOperation op = this.getOperationHistory().getUndoOperation(this.getUndoContext());
        return op != this.savedOperation;
    }

    public void doSave(IProgressMonitor progressMonitor) {
        final HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                try {
                    ((TransactionalEditingDomain)EXTLibraryEditor.this.getEditingDomain()).runExclusive(new Runnable(){

                        public void run() {
                            try {
                                Resource savedResource = EXTLibraryEditor.this.getResource();
                                (this).EXTLibraryEditor.this.savedResources.add(savedResource);
                                savedResource.save(saveOptions);
                            }
                            catch (Exception exception) {
                                (this).EXTLibraryEditor.this.resourceToDiagnosticMap.put((this).EXTLibraryEditor.this.resource, EXTLibraryEditor.this.analyzeResourceProblems((this).EXTLibraryEditor.this.resource, exception));
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    EXTLibraryEditorPlugin.INSTANCE.log(exception);
                }
            }
        };
        this.updateProblemIndication = false;
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
            this.savedOperation = this.getOperationHistory().getUndoOperation(this.getUndoContext());
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            EXTLibraryEditorPlugin.INSTANCE.log(exception);
        }
        this.updateProblemIndication = true;
        this.updateProblemIndication();
    }

    protected boolean isPersisted(Resource resource) {
        boolean result = false;
        try {
            InputStream stream = this.editingDomain.getResourceSet().getURIConverter().createInputStream(resource.getURI());
            if (stream != null) {
                result = true;
                stream.close();
            }
        }
        catch (IOException iOException) {}
        return result;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            this.doSaveAs(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), (IEditorInput)new FileEditorInput(file));
        }
    }

    protected void doSaveAs(final URI uri, final IEditorInput editorInput) {
        try {
            ((TransactionalEditingDomain)this.getEditingDomain()).runExclusive(new Runnable(){

                public void run() {
                    EXTLibraryEditor.this.getResource().setURI(uri);
                    EXTLibraryEditor.this.setInputWithNotify(editorInput);
                    EXTLibraryEditor.this.setPartName(editorInput.getName());
                }
            });
        }
        catch (InterruptedException e) {
            EXTLibraryEditorPlugin.INSTANCE.log(e);
            return;
        }
        NullProgressMonitor progressMonitor = this.getActionBars().getStatusLineManager() != null ? this.getActionBars().getStatusLineManager().getProgressMonitor() : new NullProgressMonitor();
        this.doSave((IProgressMonitor)progressMonitor);
    }

    public void gotoMarker(IMarker marker) {
        try {
            String uriAttribute;
            if (marker.getType().equals("org.eclipse.emf.ecore.diagnostic") && (uriAttribute = marker.getAttribute("uri", null)) != null) {
                try {
                    ((TransactionalEditingDomain)this.getEditingDomain()).runExclusive(new Runnable(){

                        public void run() {
                            URI uri = URI.createURI((String)uriAttribute);
                            EObject eObject = EXTLibraryEditor.this.editingDomain.getResourceSet().getEObject(uri, true);
                            if (eObject != null) {
                                EXTLibraryEditor.this.setSelectionToViewer((Collection)Collections.singleton(EXTLibraryEditor.this.editingDomain.getWrapper((Object)eObject)));
                            }
                        }
                    });
                }
                catch (InterruptedException e) {
                    EXTLibraryEditorPlugin.INSTANCE.log(e);
                }
            }
        }
        catch (CoreException exception) {
            EXTLibraryEditorPlugin.INSTANCE.log((Object)exception);
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        site.setSelectionProvider((ISelectionProvider)this);
        site.getPage().addPartListener(this.partListener);
        this.workspaceSynchronizer = new WorkspaceSynchronizer((TransactionalEditingDomain)this.editingDomain, this.createSynchronizationDelegate());
    }

    public void setFocus() {
        this.selectionViewer.getControl().setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public void setSelection(ISelection selection) {
        this.editorSelection = selection;
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
        this.setStatusLineManager(selection);
    }

    public void setStatusLineManager(ISelection selection) {
        IStatusLineManager statusLineManager;
        IStatusLineManager iStatusLineManager = statusLineManager = this.currentViewer != null && this.currentViewer == this.contentOutlineViewer ? this.contentOutlineStatusLineManager : this.getActionBars().getStatusLineManager();
        if (statusLineManager != null) {
            if (selection instanceof IStructuredSelection) {
                List collection = ((IStructuredSelection)selection).toList();
                switch (collection.size()) {
                    case 0: {
                        statusLineManager.setMessage(EXTLibraryEditor.getString("_UI_NoObjectSelected"));
                        break;
                    }
                    case 1: {
                        String text = new AdapterFactoryItemDelegator((AdapterFactory)this.adapterFactory).getText(collection.iterator().next());
                        statusLineManager.setMessage(EXTLibraryEditor.getString("_UI_SingleObjectSelected", text));
                        break;
                    }
                    default: {
                        statusLineManager.setMessage(EXTLibraryEditor.getString("_UI_MultiObjectSelected", Integer.toString(collection.size())));
                        break;
                    }
                }
            } else {
                statusLineManager.setMessage("");
            }
        }
    }

    private static String getString(String key) {
        return EXTLibraryEditorPlugin.INSTANCE.getString(key);
    }

    private static String getString(String key, Object s1) {
        return EXTLibraryEditorPlugin.INSTANCE.getString(key, new Object[]{s1});
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    private IOperationHistory getOperationHistory() {
        return ((IWorkspaceCommandStack)this.editingDomain.getCommandStack()).getOperationHistory();
    }

    public void dispose() {
        this.updateProblemIndication = false;
        this.workspaceSynchronizer.dispose();
        this.getOperationHistory().removeOperationHistoryListener(this.historyListener);
        this.getOperationHistory().dispose(this.getUndoContext(), true, true, true);
        this.getResource().unload();
        this.editingDomain.getResourceSet().getResources().remove((Object)this.getResource());
        this.editingDomain.getResourceSet().eAdapters().remove((Object)this.problemIndicationAdapter);
        this.getSite().getPage().removePartListener(this.partListener);
        this.adapterFactory.dispose();
        if (this.getActionBarContributor().getActiveEditor() == this) {
            this.getActionBarContributor().setActiveEditor(null);
        }
        if (this.propertySheetPage != null) {
            this.propertySheetPage.dispose();
        }
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.dispose();
        }
        super.dispose();
    }

    protected boolean showOutlineView() {
        return true;
    }

    public class ReverseAdapterFactoryContentProvider
    extends TransactionalAdapterFactoryContentProvider {
        public ReverseAdapterFactoryContentProvider(AdapterFactory adapterFactory) {
            super((TransactionalEditingDomain)EXTLibraryEditor.this.getEditingDomain(), adapterFactory);
        }

        public Object[] getElements(Object object) {
            Object parent = super.getParent(object);
            return (parent == null ? Collections.EMPTY_SET : Collections.singleton(parent)).toArray();
        }

        public Object[] getChildren(Object object) {
            Object parent = super.getParent(object);
            return (parent == null ? Collections.EMPTY_SET : Collections.singleton(parent)).toArray();
        }

        public boolean hasChildren(Object object) {
            Object parent = super.getParent(object);
            return parent != null;
        }

        public Object getParent(Object object) {
            return null;
        }
    }
}

