/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.workspace.tests;

import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.examples.extlibrary.Book;
import org.eclipse.emf.examples.extlibrary.EXTLibraryFactory;
import org.eclipse.emf.examples.extlibrary.EXTLibraryPackage;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.workspace.tests.AbstractTest;
import org.eclipse.emf.workspace.tests.fixtures.TestListener;

public class BasicWorkbenchTest
extends AbstractTest {
    public BasicWorkbenchTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(BasicWorkbenchTest.class, "Basic Workbench Integration Tests");
    }

    public void test_read() {
        try {
            BasicWorkbenchTest.assertNotNull((Object)this.find("root/Root Book"));
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void test_read_readOnlyTransaction() {
        this.startReading();
        BasicWorkbenchTest.assertNotNull((Object)this.find("root/Root Book"));
        this.commit();
    }

    public void test_read_readWriteTransaction() {
        this.startWriting();
        BasicWorkbenchTest.assertNotNull((Object)this.find("root/Root Book"));
        this.commit();
    }

    public void test_read_exclusive() {
        try {
            final Book[] book = new Book[1];
            this.domain.runExclusive(new Runnable(){

                @Override
                public void run() {
                    book[0] = (Book)BasicWorkbenchTest.this.find("root/Root Book");
                }
            });
            BasicWorkbenchTest.assertNotNull((Object)book[0]);
        }
        catch (InterruptedException e) {
            BasicWorkbenchTest.fail((String)"Should not be interrupted");
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void test_write() {
        this.startReading();
        Book book = (Book)this.find("root/Root Book");
        this.commit();
        try {
            book.setTitle("New Title");
            BasicWorkbenchTest.fail((String)"Should have thrown IllegalStateException");
        }
        catch (IllegalStateException e) {
            BasicWorkbenchTest.trace("Got expected exception: " + e.getLocalizedMessage());
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void test_write_readOnlytransaction() {
        try {
            try {
                this.startReading();
                Book book = (Book)this.find("root/Root Book");
                book.setTitle("New Title");
                BasicWorkbenchTest.fail((String)"Should have thrown IllegalStateException");
            }
            catch (IllegalStateException e) {
                BasicWorkbenchTest.trace("Got expected exception: " + e.getLocalizedMessage());
                this.rollback();
            }
            catch (Exception e) {
                this.fail(e);
                this.rollback();
            }
        }
        finally {
            this.rollback();
        }
    }

    public void test_write_readWritetransaction() {
        try {
            try {
                this.startWriting();
                Book book = (Book)this.find("root/Root Book");
                book.setTitle("New Title");
                this.commit();
                BasicWorkbenchTest.assertEquals((String)"New Title", (String)book.getTitle());
            }
            catch (Exception e) {
                this.fail(e);
                if (this.getActiveTransaction() != null) {
                    this.rollback();
                }
            }
        }
        finally {
            if (this.getActiveTransaction() != null) {
                this.rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_write_wrongThread() {
        block21: {
            final Object monitor = new Object();
            Thread t = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    InternalTransaction xa = null;
                    try {
                        try {
                            Object object = monitor;
                            synchronized (object) {
                                xa = ((InternalTransactionalEditingDomain)BasicWorkbenchTest.this.domain).startTransaction(true, null);
                                monitor.notifyAll();
                                monitor.wait();
                            }
                        }
                        catch (Exception e) {
                            BasicWorkbenchTest.this.fail(e);
                            if (xa != null) {
                                xa.rollback();
                            }
                        }
                    }
                    finally {
                        if (xa != null) {
                            xa.rollback();
                        }
                    }
                }
            });
            try {
                Object object = monitor;
                synchronized (object) {
                    t.start();
                    monitor.wait();
                }
                Book book = (Book)this.find("root/Root Book");
                book.setTitle("New Title");
                BasicWorkbenchTest.fail((String)"Should have thrown IllegalStateException");
            }
            catch (IllegalStateException e) {
                BasicWorkbenchTest.trace("Got expected exception: " + e.getLocalizedMessage());
                Object object = monitor;
                synchronized (object) {
                    monitor.notifyAll();
                    break block21;
                }
            }
            catch (Exception e) {
                Object object;
                try {
                    this.fail(e);
                    object = monitor;
                }
                catch (Throwable throwable) {
                    Object object2 = monitor;
                    synchronized (object2) {
                        monitor.notifyAll();
                    }
                    throw throwable;
                }
                synchronized (object) {
                    monitor.notifyAll();
                    break block21;
                }
            }
            Object object = monitor;
            synchronized (object) {
                monitor.notifyAll();
            }
        }
    }

    public void test_write_command() {
        this.startReading();
        Book book = (Book)this.find("root/Root Book");
        this.commit();
        try {
            SetCommand cmd = new SetCommand((EditingDomain)this.domain, (EObject)book, (EStructuralFeature)EXTLibraryPackage.eINSTANCE.getBook_Title(), (Object)"New Title");
            ((TransactionalCommandStack)this.domain.getCommandStack()).execute((Command)cmd, null);
            this.startReading();
            BasicWorkbenchTest.assertEquals((String)"New Title", (String)book.getTitle());
            this.commit();
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void test_loadUnloadDuringRead() throws Exception {
        this.doTearDown();
        ResourceSetImpl rset = new ResourceSetImpl();
        this.domain = this.createEditingDomain((ResourceSet)rset);
        TestListener listener = new TestListener();
        this.domain.addResourceSetListener((ResourceSetListener)listener);
        this.startReading();
        Resource res = rset.createResource(URI.createURI((String)EmfWorkbenchTestsBundle.getEntry("/test_models/test_model.extlibrary").toString()));
        res.load(Collections.EMPTY_MAP);
        this.commit();
        BasicWorkbenchTest.assertNotNull((Object)listener.postcommit);
        List notifications = listener.postcommit.getNotifications();
        BasicWorkbenchTest.assertFalse((boolean)notifications.isEmpty());
        Notification rootAdded = null;
        Notification resLoaded = null;
        for (Notification next : notifications) {
            if (next.getNotifier() != res) continue;
            if (next.getFeatureID(null) == 4) {
                if (!next.getNewBooleanValue()) continue;
                BasicWorkbenchTest.assertNotNull(rootAdded);
                resLoaded = next;
                continue;
            }
            if (next.getFeatureID(null) != 2 || next.getEventType() != 3) continue;
            rootAdded = next;
        }
        BasicWorkbenchTest.assertNotNull(rootAdded);
        BasicWorkbenchTest.assertNotNull(resLoaded);
        listener.reset();
        this.startReading();
        res.unload();
        this.commit();
        BasicWorkbenchTest.assertNotNull((Object)listener.postcommit);
        notifications = listener.postcommit.getNotifications();
        BasicWorkbenchTest.assertFalse((boolean)notifications.isEmpty());
        Notification rootRemoved = null;
        Notification resUnloaded = null;
        for (Notification next : notifications) {
            if (next.getNotifier() != res) continue;
            if (next.getFeatureID(null) == 4) {
                if (next.getNewBooleanValue()) continue;
                BasicWorkbenchTest.assertNotNull(rootRemoved);
                resUnloaded = next;
                continue;
            }
            if (next.getFeatureID(null) != 2 || next.getEventType() != 4) continue;
            rootRemoved = next;
        }
        BasicWorkbenchTest.assertNotNull(rootRemoved);
        BasicWorkbenchTest.assertNotNull(resUnloaded);
    }

    public void test_resourceContentsChanges_read() {
        try {
            try {
                this.startReading();
                this.testResource.getContents().add((Object)EXTLibraryFactory.eINSTANCE.createLibrary());
                BasicWorkbenchTest.fail((String)"Should have thrown IllegalStateException");
            }
            catch (IllegalStateException e) {
                BasicWorkbenchTest.trace("Got expected exception: " + e.getLocalizedMessage());
                this.rollback();
            }
            catch (Exception e) {
                this.fail(e);
                this.rollback();
            }
        }
        finally {
            this.rollback();
        }
    }

    public void test_resourceContentsChanges_write() {
        try {
            try {
                this.startWriting();
                this.testResource.getContents().add((Object)EXTLibraryFactory.eINSTANCE.createLibrary());
            }
            catch (Exception e) {
                this.fail(e);
                this.rollback();
            }
        }
        finally {
            this.rollback();
        }
    }

    public void test_newResourceContentsChanges_read() {
        try {
            try {
                this.startReading();
                Resource res = this.domain.getResourceSet().createResource(URI.createFileURI((String)"/tmp/foo.extlibrary"));
                BasicWorkbenchTest.assertFalse((boolean)res.isLoaded());
                res.getContents().add((Object)EXTLibraryFactory.eINSTANCE.createLibrary());
                BasicWorkbenchTest.fail((String)"Should have thrown IllegalStateException");
            }
            catch (IllegalStateException e) {
                BasicWorkbenchTest.trace("Got expected exception: " + e.getLocalizedMessage());
                this.rollback();
            }
            catch (Exception e) {
                this.fail(e);
                this.rollback();
            }
        }
        finally {
            this.rollback();
        }
    }

    public void test_newResourceContentsChanges_write() {
        try {
            try {
                this.startWriting();
                Resource res = this.domain.getResourceSet().createResource(URI.createFileURI((String)"/tmp/foo.extlibrary"));
                BasicWorkbenchTest.assertFalse((boolean)res.isLoaded());
                res.getContents().add((Object)EXTLibraryFactory.eINSTANCE.createLibrary());
            }
            catch (Exception e) {
                this.fail(e);
                this.rollback();
            }
        }
        finally {
            this.rollback();
        }
    }
}

