/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDPlugin;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.impl.XSDSchemaContentImpl;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.eclipse.xsd.util.XSDSchemaLocationResolver;
import org.eclipse.xsd.util.XSDSchemaLocator;
import org.w3c.dom.Element;

public abstract class XSDSchemaDirectiveImpl
extends XSDSchemaContentImpl
implements XSDSchemaDirective {
    protected static final String SCHEMA_LOCATION_EDEFAULT = null;
    protected String schemaLocation = SCHEMA_LOCATION_EDEFAULT;
    protected XSDSchema resolvedSchema;
    protected boolean resolved;

    protected XSDSchemaDirectiveImpl() {
    }

    public void reset() {
        super.reset();
        this.resolved = false;
        this.setResolvedSchema(null);
    }

    protected EClass eStaticClass() {
        return XSDPackage.Literals.XSD_SCHEMA_DIRECTIVE;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String newSchemaLocation) {
        String oldSchemaLocation = this.schemaLocation;
        this.schemaLocation = newSchemaLocation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldSchemaLocation, (Object)this.schemaLocation));
        }
    }

    public XSDSchema getResolvedSchema() {
        return this.resolvedSchema;
    }

    public void setResolvedSchema(XSDSchema newResolvedSchema) {
        XSDSchema oldResolvedSchema = this.resolvedSchema;
        this.resolvedSchema = newResolvedSchema;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldResolvedSchema, (Object)this.resolvedSchema));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 5: {
                return this.getSchemaLocation();
            }
            case 6: {
                return this.getResolvedSchema();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 5: {
                this.setSchemaLocation((String)newValue);
                return;
            }
            case 6: {
                this.setResolvedSchema((XSDSchema)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 5: {
                this.setSchemaLocation(SCHEMA_LOCATION_EDEFAULT);
                return;
            }
            case 6: {
                this.setResolvedSchema(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 5: {
                return SCHEMA_LOCATION_EDEFAULT == null ? this.schemaLocation != null : !SCHEMA_LOCATION_EDEFAULT.equals(this.schemaLocation);
            }
            case 6: {
                return this.resolvedSchema != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (schemaLocation: ");
        result.append(this.schemaLocation);
        result.append(')');
        return result.toString();
    }

    protected void reconcileAttributes(Element changedElement) {
        super.reconcileAttributes(changedElement);
        String newSchemaLocation = null;
        if (changedElement.hasAttributeNS(null, "schemaLocation")) {
            newSchemaLocation = changedElement.getAttributeNS(null, "schemaLocation");
        }
        if (newSchemaLocation == null ? this.getSchemaLocation() != null : !newSchemaLocation.equals(this.getSchemaLocation())) {
            this.setSchemaLocation(newSchemaLocation);
        }
    }

    protected void changeAttribute(EAttribute eAttribute) {
        if (this.resolved && this.getResolvedSchema() == null && eAttribute == XSDPackage.Literals.XSD_SCHEMA_DIRECTIVE__SCHEMA_LOCATION) {
            this.resolved = false;
        }
        if (!this.isReconciling) {
            Element theElement;
            super.changeAttribute(eAttribute);
            if ((eAttribute == null || eAttribute == XSDPackage.Literals.XSD_SCHEMA_DIRECTIVE__SCHEMA_LOCATION) && (theElement = this.getElement()) != null) {
                this.niceSetAttribute(theElement, "schemaLocation", this.getSchemaLocation());
            }
        }
        if (eAttribute == XSDPackage.Literals.XSD_SCHEMA_DIRECTIVE__SCHEMA_LOCATION && this.getResolvedSchema() != null && this.getSchema().isIncrementalUpdate()) {
            this.getSchema().reset();
        }
    }

    protected void orphanBy(XSDSchema xsdSchema) {
        super.orphanBy(xsdSchema);
        if (this.resolved && xsdSchema.isIncrementalUpdate()) {
            xsdSchema.reset();
        }
    }

    protected void resolve(String namespace, String schemaLocation) {
        ResourceSet resourceSet;
        Resource resource;
        XSDSchema xsdSchema;
        if (!(this.resolved || (xsdSchema = this.getSchema()) == null || xsdSchema.getSchemaLocation() == null && ((XSDSchemaImpl)xsdSchema).getPendingSchemaLocation() == null || (resource = xsdSchema.eResource()) == null || (resourceSet = resource.getResourceSet()) == null)) {
            XSDSchema resolvedSchema;
            if ("".equals(namespace)) {
                namespace = xsdSchema.getTargetNamespace();
            }
            String resolvedSchemaLocation = this.resolveSchemaLocation(xsdSchema, namespace, schemaLocation);
            if (schemaLocation == null) {
                if (XSDConstants.isXMLNamespace(resolvedSchemaLocation)) {
                    resolvedSchemaLocation = String.valueOf(XSDPlugin.INSTANCE.getBaseURL().toString()) + "cache/www.w3.org/2001/xml.xsd";
                } else if ("http://www.w3.org/2001/XMLSchema".equals(resolvedSchemaLocation)) {
                    resolvedSchemaLocation = String.valueOf(XSDPlugin.INSTANCE.getBaseURL().toString()) + "cache/www.w3.org/2001/XMLSchema.xsd";
                }
            }
            if ((resolvedSchema = this.locateSchema(xsdSchema, namespace, schemaLocation, resolvedSchemaLocation)) == null) {
                URI uri = URI.createURI((String)(resolvedSchemaLocation == null ? "" : resolvedSchemaLocation));
                Resource resolvedResource = resourceSet.getResource(uri, false);
                if (resolvedResource == null) {
                    try {
                        InputStream inputStream = resourceSet.getURIConverter().createInputStream(uri);
                        resolvedResource = resourceSet.createResource(URI.createURI((String)"*.xsd"));
                        resolvedResource.setURI(uri);
                        resolvedResource.load(inputStream, resourceSet.getLoadOptions());
                    }
                    catch (IOException iOException) {}
                } else if (!resolvedResource.isLoaded()) {
                    try {
                        resolvedResource.load(resourceSet.getLoadOptions());
                    }
                    catch (IOException iOException) {}
                }
                if (resolvedResource != null) {
                    resolvedSchema = resolvedResource instanceof XSDResourceImpl ? ((XSDResourceImpl)resolvedResource).getSchema() : XSDFactory.eINSTANCE.createXSDSchema();
                }
            }
            this.resolved = true;
            this.handleResolvedSchema(resolvedSchema);
        }
    }

    protected XSDSchema locateSchema(XSDSchema xsdSchema, String namespace, String rawSchemaLocation, String resolvedSchemaLocation) {
        XSDSchemaLocator xsdSchemaLocator = (XSDSchemaLocator)EcoreUtil.getRegisteredAdapter((Resource)xsdSchema.eResource(), XSDSchemaLocator.class);
        return xsdSchemaLocator == null ? null : xsdSchemaLocator.locateSchema(xsdSchema, namespace, rawSchemaLocation, resolvedSchemaLocation);
    }

    protected String resolveSchemaLocation(XSDSchema xsdSchema, String namespace, String schemaLocation) {
        while (true) {
            XSDSchema containingXSDSchema;
            XSDSchemaLocationResolver xsdSchemaLocationResolver;
            if ((xsdSchemaLocationResolver = (XSDSchemaLocationResolver)EcoreUtil.getRegisteredAdapter((EObject)xsdSchema, XSDSchemaLocationResolver.class)) != null) {
                return xsdSchemaLocationResolver.resolveSchemaLocation(xsdSchema, namespace, schemaLocation);
            }
            XSDConcreteComponent container = xsdSchema.getContainer();
            if (container == null || (containingXSDSchema = container.getSchema()) == null) break;
            xsdSchema = containingXSDSchema;
        }
        return XSDConstants.resolveSchemaLocation(xsdSchema.getSchemaLocation(), namespace, schemaLocation);
    }

    protected void handleResolvedSchema(XSDSchema xsdSchema) {
    }
}

