/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.model;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.model.CDOClassProxy;
import org.eclipse.emf.cdo.common.model.CDOClassRef;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackage;
import org.eclipse.emf.cdo.common.model.CDOPackageManager;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.internal.common.model.CDOModelElementImpl;
import org.eclipse.emf.cdo.spi.common.InternalCDOClass;
import org.eclipse.emf.cdo.spi.common.InternalCDOFeature;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOClassImpl
extends CDOModelElementImpl
implements InternalCDOClass {
    private static final ContextTracer MODEL = new ContextTracer(OM.DEBUG_MODEL, CDOClassImpl.class);
    private static final ContextTracer PROTOCOL = new ContextTracer(OM.DEBUG_PROTOCOL, CDOClassImpl.class);
    private CDOPackage containingPackage;
    private int classifierID;
    private boolean isAbstract;
    private List<CDOClassProxy> superTypes = new ArrayList<CDOClassProxy>(0);
    private List<CDOFeature> features = new ArrayList<CDOFeature>(0);
    private transient List<Integer> indices;
    private transient CDOClass[] allSuperTypes;
    private transient CDOFeature[] allFeatures;

    public CDOClassImpl() {
    }

    public CDOClassImpl(CDOPackage containingPackage, int classifierID, String name, boolean isAbstract) {
        super(name);
        this.containingPackage = containingPackage;
        this.classifierID = classifierID;
        this.isAbstract = isAbstract;
        if (MODEL.isEnabled()) {
            MODEL.format("Created {0}", new Object[]{this});
        }
    }

    public CDOClassImpl(CDOPackage containingPackage, ExtendedDataInput in) throws IOException {
        this.containingPackage = containingPackage;
        this.read(in);
    }

    @Override
    public void read(ExtendedDataInput in) throws IOException {
        super.read(in);
        this.classifierID = in.readInt();
        this.isAbstract = in.readBoolean();
        this.readSuperTypes(in);
        this.readFeatures(in);
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Read class: ID={0}, name={1}, abstract={2}", new Object[]{this.classifierID, this.getName(), this.isAbstract});
        }
    }

    @Override
    public void write(ExtendedDataOutput out) throws IOException {
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Writing class: ID={0}, name={1}, abstract={2}", new Object[]{this.classifierID, this.getName(), this.isAbstract});
        }
        super.write(out);
        out.writeInt(this.classifierID);
        out.writeBoolean(this.isAbstract);
        this.writeSuperTypes(out);
        this.writeFeatures(out);
    }

    @Override
    public int getFeatureID(CDOFeature feature) {
        int index = feature.getFeatureIndex();
        if (index != -1) {
            CDOFeature[] features = this.getAllFeatures();
            while (index < features.length) {
                if (features[index] == feature) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    @Override
    public CDOPackageManager getPackageManager() {
        return this.containingPackage.getPackageManager();
    }

    @Override
    public CDOPackage getContainingPackage() {
        return this.containingPackage;
    }

    @Override
    public void setContainingPackage(CDOPackage containingPackage) {
        this.containingPackage = containingPackage;
    }

    @Override
    public int getClassifierID() {
        return this.classifierID;
    }

    public void setClassifierID(int classifierID) {
        this.classifierID = classifierID;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    @Override
    public boolean isResource() {
        return false;
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public int getSuperTypeCount() {
        return this.superTypes.size();
    }

    @Override
    public CDOClass[] getSuperTypes() {
        int size = this.superTypes.size();
        CDOClass[] result = new CDOClass[size];
        int i = 0;
        while (i < size) {
            result[i] = this.getSuperType(i);
            ++i;
        }
        return result;
    }

    public void setSuperTypes(List<CDOClass> superTypes) {
        this.superTypes = new ArrayList<CDOClassProxy>(superTypes.size());
        for (CDOClass cdoClass : superTypes) {
            this.superTypes.add(new CDOClassProxy(cdoClass));
        }
    }

    @Override
    public CDOClass getSuperType(int index) {
        return this.superTypes.get(index).getCdoClass();
    }

    @Override
    public List<CDOClassProxy> getSuperTypeProxies() {
        return Collections.unmodifiableList(this.superTypes);
    }

    @Override
    public int getFeatureCount() {
        return this.features.size();
    }

    @Override
    public CDOFeature[] getFeatures() {
        return this.features.toArray(new CDOFeature[this.features.size()]);
    }

    public void setFeatures(List<CDOFeature> features) {
        this.features = features;
        for (CDOFeature feature : features) {
            ((InternalCDOFeature)feature).setContainingClass(this);
        }
    }

    @Override
    public CDOFeature lookupFeature(int featureID) {
        int i = this.getFeatureIndex(featureID);
        return this.getAllFeatures()[i];
    }

    @Override
    public CDOFeature lookupFeature(String name) {
        CDOFeature[] cDOFeatureArray = this.getAllFeatures();
        int n = cDOFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOFeature feature = cDOFeatureArray[n2];
            if (ObjectUtil.equals((Object)feature.getName(), (Object)name)) {
                return feature;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public CDOClassRef createClassRef() {
        return CDOModelUtil.createClassRef(this.containingPackage.getPackageURI(), this.classifierID);
    }

    @Override
    public CDOClass[] getAllSuperTypes() {
        if (this.allSuperTypes == null) {
            ArrayList result = new ArrayList(0);
            CDOClass[] cDOClassArray = this.getSuperTypes();
            int n = cDOClassArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDOClass[] higherSupers;
                CDOClass superType = cDOClassArray[n2];
                CDOClass[] cDOClassArray2 = higherSupers = superType.getAllSuperTypes();
                int n3 = higherSupers.length;
                int n4 = 0;
                while (n4 < n3) {
                    CDOClass higherSuper = cDOClassArray2[n4];
                    CDOClassImpl.addUnique(higherSuper, result);
                    ++n4;
                }
                CDOClassImpl.addUnique(superType, result);
                ++n2;
            }
            this.allSuperTypes = result.toArray(new CDOClass[result.size()]);
        }
        return this.allSuperTypes;
    }

    @Override
    public int getFeatureIndex(int featureID) {
        if (this.indices == null) {
            CDOFeature[] features = this.getAllFeatures();
            this.indices = new ArrayList<Integer>(features.length);
            int index = 0;
            CDOFeature[] cDOFeatureArray = features;
            int n = features.length;
            int n2 = 0;
            while (n2 < n) {
                CDOFeature feature = cDOFeatureArray[n2];
                if (feature.getContainingClass() == this) {
                    ((InternalCDOFeature)feature).setFeatureIndex(index);
                }
                this.setIndex(feature.getFeatureID(), index);
                ++index;
                ++n2;
            }
        }
        return this.indices.get(featureID);
    }

    @Override
    public CDOFeature[] getAllFeatures() {
        if (this.allFeatures == null) {
            ArrayList<CDOFeature> result = new ArrayList<CDOFeature>(0);
            CDOClass[] cDOClassArray = this.getSuperTypes();
            int n = cDOClassArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDOClass superType = cDOClassArray[n2];
                CDOFeature[] features = superType.getAllFeatures();
                CDOClassImpl.addAllFeatures(features, result);
                ++n2;
            }
            CDOClassImpl.addAllFeatures(this.getFeatures(), result);
            this.allFeatures = result.toArray(new CDOFeature[result.size()]);
        }
        return this.allFeatures;
    }

    @Override
    public void addSuperType(CDOClassRef classRef) {
        if (MODEL.isEnabled()) {
            MODEL.format("Adding super type: {0}", new Object[]{classRef});
        }
        this.superTypes.add(new CDOClassProxy(classRef, this.containingPackage.getPackageManager()));
    }

    @Override
    public void addFeature(CDOFeature cdoFeature) {
        if (MODEL.isEnabled()) {
            MODEL.format("Adding feature: {0}", new Object[]{cdoFeature});
        }
        this.features.add(cdoFeature);
    }

    @Override
    public int compareTo(CDOClass that) {
        return this.getName().compareTo(that.getName());
    }

    public String toString() {
        return MessageFormat.format("CDOClass(ID={0}, name={1})", this.classifierID, this.getName());
    }

    @Override
    protected void onInitialize() {
        for (CDOFeature cdoFeature : this.features) {
            ((InternalCDOFeature)cdoFeature).initialize();
        }
    }

    private void setIndex(int featureID, int index) {
        while (this.indices.size() <= featureID) {
            this.indices.add(null);
        }
        this.indices.set(featureID, index);
    }

    private void readSuperTypes(ExtendedDataInput in) throws IOException {
        int size = in.readInt();
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Reading {0} super types", new Object[]{size});
        }
        int i = 0;
        while (i < size) {
            CDOClassRef classRef = CDOModelUtil.readClassRef(in, this.containingPackage.getPackageURI());
            if (PROTOCOL.isEnabled()) {
                PROTOCOL.format("Read super type: classRef={0}", new Object[]{classRef, this.classifierID});
            }
            this.superTypes.add(new CDOClassProxy(classRef, this.containingPackage.getPackageManager()));
            ++i;
        }
    }

    private void readFeatures(ExtendedDataInput in) throws IOException {
        int size = in.readInt();
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Reading {0} features", new Object[]{size});
        }
        int i = 0;
        while (i < size) {
            CDOFeature cdoFeature = CDOModelUtil.readFeature(this, in);
            this.addFeature(cdoFeature);
            ++i;
        }
    }

    private void writeSuperTypes(ExtendedDataOutput out) throws IOException {
        int size = this.superTypes.size();
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Writing {0} super types", new Object[]{size});
        }
        out.writeInt(size);
        for (CDOClassProxy proxy : this.superTypes) {
            CDOClassRef classRef = proxy.getClassRef();
            if (PROTOCOL.isEnabled()) {
                PROTOCOL.format("Writing super type: classRef={0}", new Object[]{classRef});
            }
            CDOModelUtil.writeClassRef(out, classRef, this.containingPackage.getPackageURI());
        }
    }

    private void writeFeatures(ExtendedDataOutput out) throws IOException {
        int size = this.features.size();
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Writing {0} features", new Object[]{size});
        }
        out.writeInt(size);
        for (CDOFeature cdoFeature : this.features) {
            CDOModelUtil.writeFeature(out, cdoFeature);
        }
    }

    private static void addAllFeatures(CDOFeature[] features, List<CDOFeature> result) {
        CDOFeature[] cDOFeatureArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            CDOFeature feature = cDOFeatureArray[n2];
            CDOClassImpl.addUnique(feature, result);
            ++n2;
        }
    }

    private static void addUnique(Object object, List result) {
        if (!result.contains(object)) {
            result.add(object);
        }
    }
}

