/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.model;

import java.util.Map;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.net4j.util.concurrent.Worker;

public class CDOPackageRegistryPopulator
extends Worker {
    public static final int DEFAULT_SOURCE_POLL_INTERVAL = 5000;
    private long sourcePollInterval = 5000L;
    private EPackage.Registry source;
    private CDOPackageRegistry target;

    public CDOPackageRegistryPopulator(CDOPackageRegistry target) {
        this(EPackage.Registry.INSTANCE, target);
    }

    public CDOPackageRegistryPopulator(EPackage.Registry source, CDOPackageRegistry target) {
        this.source = source;
        this.target = target;
    }

    public EPackage.Registry getSource() {
        return this.source;
    }

    public CDOPackageRegistry getTarget() {
        return this.target;
    }

    public long getSourcePollInterval() {
        return this.sourcePollInterval;
    }

    public void setSourcePollInterval(long sourcePollInterval) {
        this.sourcePollInterval = sourcePollInterval;
    }

    protected void work(Worker.WorkContext context) throws Exception {
        this.doWork();
        context.nextWork(this.getSourcePollInterval());
    }

    protected void doWork() {
        CDOPackageRegistryPopulator.populate(this.getSource(), this.getTarget());
    }

    protected void doActivate() throws Exception {
        this.doWork();
        super.doActivate();
    }

    public static boolean populate(CDOPackageRegistry target) {
        return CDOPackageRegistryPopulator.populate(EPackage.Registry.INSTANCE, target);
    }

    public static boolean populate(EPackage.Registry source, CDOPackageRegistry target) {
        boolean populated = false;
        while (CDOPackageRegistryPopulator.populateFirstMatch(source, target)) {
            populated = true;
        }
        return populated;
    }

    private static boolean populateFirstMatch(EPackage.Registry source, CDOPackageRegistry target) {
        for (Map.Entry entry : source.entrySet()) {
            String nsURI = (String)entry.getKey();
            if (target.containsKey(nsURI)) continue;
            target.put(nsURI, new Descriptor(source, nsURI));
            return true;
        }
        return false;
    }

    public static class Descriptor
    implements EPackage.Descriptor {
        private EPackage.Registry source;
        private String nsURI;

        public Descriptor(EPackage.Registry source, String nsURI) {
            this.source = source;
            this.nsURI = nsURI;
        }

        public EPackage.Registry getSource() {
            return this.source;
        }

        public String getNsURI() {
            return this.nsURI;
        }

        public EFactory getEFactory() {
            return this.source.getEFactory(this.nsURI);
        }

        public EPackage getEPackage() {
            return this.source.getEPackage(this.nsURI);
        }
    }
}

