/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.io;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.id.CDOIDMetaRange;
import org.eclipse.emf.cdo.common.id.CDOIDObject;
import org.eclipse.emf.cdo.common.id.CDOIDObjectFactory;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageInfo;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDOListFactory;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionResolver;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.internal.common.id.CDOIDAndVersionImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDExternalImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDExternalTempImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDMetaImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDMetaRangeImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDTempMetaImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDTempObjectImpl;
import org.eclipse.emf.cdo.internal.common.messages.Messages;
import org.eclipse.emf.cdo.internal.common.revision.CDORevisionImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOAddFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOClearFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOContainerFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOListFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOMoveFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDORemoveFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDORevisionDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOSetFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOUnsetFeatureDeltaImpl;
import org.eclipse.emf.cdo.spi.common.id.AbstractCDOID;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOList;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.concurrent.RWLockManager;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.StringIO;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public abstract class CDODataInputImpl
extends ExtendedDataInput.Delegating
implements CDODataInput {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, CDODataInputImpl.class);
    private static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$emf$cdo$common$id$CDOID$Type;

    public CDODataInputImpl(ExtendedDataInput delegate) {
        super(delegate);
    }

    public CDOPackageUnit readCDOPackageUnit(CDOPackageRegistry packageRegistry) throws IOException {
        InternalCDOPackageUnit packageUnit = (InternalCDOPackageUnit)CDOModelUtil.createPackageUnit();
        packageUnit.read(this, (InternalCDOPackageRegistry)packageRegistry);
        return packageUnit;
    }

    public CDOPackageUnit[] readCDOPackageUnits(CDOPackageRegistry packageRegistry) throws IOException {
        int size = this.readInt();
        if (TRACER.isEnabled()) {
            TRACER.format("Reading {0} package units", new Object[]{size});
        }
        CDOPackageUnit[] packageUnits = new CDOPackageUnit[size];
        int i = 0;
        while (i < size) {
            packageUnits[i] = this.readCDOPackageUnit(packageRegistry);
            ++i;
        }
        return packageUnits;
    }

    public CDOPackageUnit.Type readCDOPackageUnitType() throws IOException {
        return CDOPackageUnit.Type.values()[this.readByte()];
    }

    public CDOPackageInfo readCDOPackageInfo() throws IOException {
        InternalCDOPackageInfo packageInfo = (InternalCDOPackageInfo)CDOModelUtil.createPackageInfo();
        packageInfo.read(this);
        return packageInfo;
    }

    public String readCDOPackageURI() throws IOException {
        return this.getPackageURICompressor().read((ExtendedDataInput)this);
    }

    public CDOClassifierRef readCDOClassifierRef() throws IOException {
        return new CDOClassifierRef(this);
    }

    public EClassifier readCDOClassifierRefAndResolve() throws IOException {
        CDOClassifierRef classRef = this.readCDOClassifierRef();
        return classRef.resolve(this.getPackageRegistry());
    }

    public CDOType readCDOType() throws IOException {
        int typeID = this.readInt();
        return CDOModelUtil.getType(typeID);
    }

    public CDOID readCDOID() throws IOException {
        Object type;
        byte ordinal = this.readByte();
        if (TRACER.isEnabled()) {
            try {
                type = CDOID.Type.values()[ordinal].toString();
            }
            catch (RuntimeException ex) {
                type = ex.getMessage();
            }
            TRACER.format("Reading CDOID of type {0} ({1})", new Object[]{ordinal, type});
        }
        type = CDOID.Type.values()[ordinal];
        switch (CDODataInputImpl.$SWITCH_TABLE$org$eclipse$emf$cdo$common$id$CDOID$Type()[((Enum)type).ordinal()]) {
            case 1: {
                return CDOID.NULL;
            }
            case 5: {
                return new CDOIDTempObjectImpl(this.readInt());
            }
            case 7: {
                return new CDOIDTempMetaImpl(this.readInt());
            }
            case 6: {
                return new CDOIDMetaImpl(this.readLong());
            }
            case 3: {
                return new CDOIDExternalImpl(this.readString());
            }
            case 4: {
                return new CDOIDExternalTempImpl(this.readString());
            }
            case 2: {
                CDOIDObject id = this.getIDFactory().createCDOIDObject(this);
                ((AbstractCDOID)((Object)id)).read(this);
                return id;
            }
        }
        throw new ImplementationError();
    }

    public CDOIDAndVersion readCDOIDAndVersion() throws IOException {
        return new CDOIDAndVersionImpl(this);
    }

    public CDOIDMetaRange readCDOIDMetaRange() throws IOException {
        boolean exist = this.readBoolean();
        if (exist) {
            return new CDOIDMetaRangeImpl(this.readCDOID(), this.readInt());
        }
        return null;
    }

    public CDORevision readCDORevision() throws IOException {
        boolean notNull = this.readBoolean();
        if (notNull) {
            return new CDORevisionImpl(this);
        }
        return null;
    }

    public CDOList readCDOList(EClass owner, EStructuralFeature feature) throws IOException {
        int referenceChunk;
        int size = this.readInt();
        if (size < 0) {
            size = -size;
            referenceChunk = this.readInt();
            if (TRACER.isEnabled()) {
                TRACER.format("Read feature {0}: size={1}, referenceChunk={2}", new Object[]{feature.getName(), size, referenceChunk});
            }
        } else {
            referenceChunk = size;
            if (TRACER.isEnabled()) {
                TRACER.format("Read feature {0}: size={1}", new Object[]{feature.getName(), size});
            }
        }
        Object value = null;
        CDOType type = null;
        boolean isFeatureMap = FeatureMapUtil.isFeatureMap((EStructuralFeature)feature);
        if (!isFeatureMap) {
            type = CDOModelUtil.getType(feature.getEType());
        }
        InternalCDOList list = (InternalCDOList)this.getListFactory().createList(size, size, referenceChunk);
        int j = 0;
        while (j < referenceChunk) {
            if (isFeatureMap) {
                int featureID = this.readInt();
                EStructuralFeature innerFeature = owner.getEStructuralFeature(featureID);
                type = CDOModelUtil.getType(innerFeature.getEType());
                value = type.readValue(this);
                value = CDORevisionUtil.createFeatureMapEntry(innerFeature, value);
            } else {
                value = type.readValue(this);
            }
            list.set(j, value);
            if (TRACER.isEnabled()) {
                TRACER.trace("    " + value);
            }
            ++j;
        }
        return list;
    }

    public Object readCDOFeatureValue(EStructuralFeature feature) throws IOException {
        CDOType type = CDOModelUtil.getType(feature);
        if (type.canBeNull() && !feature.isMany() && this.readBoolean()) {
            return InternalCDORevision.NIL;
        }
        return type.readValue(this);
    }

    public CDORevisionDelta readCDORevisionDelta() throws IOException {
        return new CDORevisionDeltaImpl(this);
    }

    public CDOFeatureDelta readCDOFeatureDelta(EClass owner) throws IOException {
        int typeOrdinal = this.readInt();
        CDOFeatureDelta.Type type = CDOFeatureDelta.Type.values()[typeOrdinal];
        switch (type) {
            case ADD: {
                return new CDOAddFeatureDeltaImpl(this, owner);
            }
            case SET: {
                return new CDOSetFeatureDeltaImpl(this, owner);
            }
            case LIST: {
                return new CDOListFeatureDeltaImpl(this, owner);
            }
            case MOVE: {
                return new CDOMoveFeatureDeltaImpl(this, owner);
            }
            case CLEAR: {
                return new CDOClearFeatureDeltaImpl(this, owner);
            }
            case REMOVE: {
                return new CDORemoveFeatureDeltaImpl(this, owner);
            }
            case CONTAINER: {
                return new CDOContainerFeatureDeltaImpl(this, owner);
            }
            case UNSET: {
                return new CDOUnsetFeatureDeltaImpl(this, owner);
            }
        }
        throw new IOException(MessageFormat.format(Messages.getString("CDODataInputImpl.5"), typeOrdinal));
    }

    public Object readCDORevisionOrPrimitive() throws IOException {
        CDOType type = this.readCDOType();
        return type.readValue(this);
    }

    public Object readCDORevisionOrPrimitiveOrClassifier() throws IOException {
        boolean isClassifier = this.readBoolean();
        if (isClassifier) {
            return this.readCDOClassifierRefAndResolve();
        }
        return this.readCDORevisionOrPrimitive();
    }

    public RWLockManager.LockType readCDOLockType() throws IOException {
        return this.readBoolean() ? RWLockManager.LockType.WRITE : RWLockManager.LockType.READ;
    }

    protected StringIO getPackageURICompressor() {
        return StringIO.DIRECT;
    }

    protected abstract CDOPackageRegistry getPackageRegistry();

    protected abstract CDORevisionResolver getRevisionResolver();

    protected abstract CDOIDObjectFactory getIDFactory();

    protected abstract CDOListFactory getListFactory();

    static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$emf$cdo$common$id$CDOID$Type() {
        if ($SWITCH_TABLE$org$eclipse$emf$cdo$common$id$CDOID$Type != null) {
            return $SWITCH_TABLE$org$eclipse$emf$cdo$common$id$CDOID$Type;
        }
        int[] nArray = new int[CDOID.Type.values().length];
        try {
            nArray[CDOID.Type.EXTERNAL_OBJECT.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CDOID.Type.EXTERNAL_TEMP_OBJECT.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CDOID.Type.META.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CDOID.Type.NULL.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CDOID.Type.OBJECT.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CDOID.Type.TEMP_META.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CDOID.Type.TEMP_OBJECT.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$eclipse$emf$cdo$common$id$CDOID$Type = nArray;
        return nArray;
    }
}

