/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.hibernate.teneo;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.eclipse.emf.cdo.common.model.CDOPackage;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.hibernate.IHibernateMappingProvider;
import org.eclipse.emf.cdo.server.hibernate.IHibernateStore;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateUtil;
import org.eclipse.emf.cdo.server.internal.hibernate.bundle.OM;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.teneo.hibernate.cdo.CDOHelper;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.hibernate.cfg.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeneoHibernateMappingProvider
implements IHibernateMappingProvider {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, TeneoHibernateMappingProvider.class);
    private IHibernateStore hibernateStore;

    public void addMapping(Configuration configuration) {
        String mapping = this.generateMapping();
        if (TRACER.isEnabled()) {
            TRACER.trace("Generated hibernate mapping:");
            TRACER.trace(mapping);
        }
        configuration.addXML(mapping);
        if (TRACER.isEnabled()) {
            TRACER.trace("Added mapping to configuration");
        }
    }

    public String generateMapping() {
        if (TRACER.isEnabled()) {
            TRACER.trace("Generating Hibernate Mapping");
        }
        Properties properties = HibernateUtil.getInstance().getPropertiesFromStore((IStore)this.getHibernateStore());
        ArrayList<EPackage> epacks = new ArrayList<EPackage>();
        ResourceSetImpl rs = new ResourceSetImpl();
        rs.getPackageRegistry().put((Object)"http://www.eclipse.org/emf/2002/Ecore", (Object)EcorePackage.eINSTANCE);
        rs.getPackageRegistry().put((Object)"http://www.eclipse.org/emf/2003/XMLType", (Object)XMLTypePackage.eINSTANCE);
        rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new EcoreResourceFactoryImpl());
        for (CDOPackage cdoPackage : this.getHibernateStore().getPackageHandler().getCDOPackages()) {
            String ecoreStr;
            if (TRACER.isEnabled()) {
                TRACER.trace("Using cdoPackage : " + cdoPackage.getName() + " - " + cdoPackage.getPackageURI());
            }
            if ((ecoreStr = cdoPackage.getEcore()) == null) continue;
            ByteArrayInputStream bis = new ByteArrayInputStream(ecoreStr.getBytes());
            URI epackageURI = URI.createURI((String)cdoPackage.getPackageURI());
            Resource resource = rs.createResource(epackageURI);
            try {
                resource.load((InputStream)bis, Collections.EMPTY_MAP);
                for (Object contentObject : resource.getContents()) {
                    epacks.addAll(this.resolveSubPackages((EPackage)contentObject));
                }
            }
            catch (Exception e) {
                throw WrappedException.wrap((Exception)e);
            }
        }
        EPackage[] ePackageArray = epacks.toArray(new EPackage[epacks.size()]);
        properties.put("teneo.mapping.also_map_as_class", "false");
        return CDOHelper.getInstance().generateMapping(ePackageArray, properties);
    }

    protected List<EPackage> resolveSubPackages(EPackage ePackage) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        this.resolveSubPackages(ePackage, result);
        return result;
    }

    private void resolveSubPackages(EPackage ePackage, List<EPackage> result) {
        EPackage globalPackage = EPackage.Registry.INSTANCE.getEPackage(ePackage.getNsURI());
        if (globalPackage != null) {
            ePackage = globalPackage;
        }
        result.add(ePackage);
        for (EPackage subEPackage : ePackage.getESubpackages()) {
            this.resolveSubPackages(subEPackage, result);
        }
    }

    public IHibernateStore getHibernateStore() {
        return this.hibernateStore;
    }

    public void setHibernateStore(IHibernateStore hibernateStore) {
        this.hibernateStore = hibernateStore;
    }
}

