/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.io.CDODataOutput;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.internal.server.Repository;
import org.eclipse.emf.cdo.internal.server.Session;
import org.eclipse.emf.cdo.internal.server.SessionManager;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.internal.server.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.internal.server.protocol.RepositoryTimeIndication;
import org.eclipse.emf.cdo.server.IRepositoryProvider;
import org.eclipse.emf.cdo.server.RepositoryNotFoundException;
import org.eclipse.emf.cdo.server.SessionCreationException;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class OpenSessionIndication
extends RepositoryTimeIndication {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, OpenSessionIndication.class);
    private String repositoryName;
    private boolean passiveUpdateEnabled;
    private Repository repository;
    private Session session;

    public OpenSessionIndication(CDOServerProtocol protocol) {
        super(protocol, (short)1);
    }

    protected Repository getRepository() {
        return this.repository;
    }

    protected Session getSession() {
        return this.session;
    }

    protected void indicating(CDODataInput in) throws IOException {
        super.indicating(in);
        this.repositoryName = in.readString();
        if (TRACER.isEnabled()) {
            TRACER.format("Read repositoryName: {0}", new Object[]{this.repositoryName});
        }
        this.passiveUpdateEnabled = in.readBoolean();
        if (TRACER.isEnabled()) {
            TRACER.format("Read passiveUpdateEnabled: {0}", new Object[]{this.passiveUpdateEnabled});
        }
    }

    protected void responding(CDODataOutput out) throws IOException {
        try {
            CDOServerProtocol protocol = this.getProtocol();
            IRepositoryProvider repositoryProvider = protocol.getRepositoryProvider();
            this.repository = (Repository)repositoryProvider.getRepository(this.repositoryName);
            if (this.repository == null) {
                throw new RepositoryNotFoundException(this.repositoryName);
            }
            SessionManager sessionManager = this.repository.getSessionManager();
            this.session = sessionManager.openSession(protocol);
            this.session.setPassiveUpdateEnabled(this.passiveUpdateEnabled);
            protocol.setInfraStructure(this.session);
            if (TRACER.isEnabled()) {
                TRACER.format("Writing sessionID: {0}", new Object[]{this.session.getSessionID()});
            }
            out.writeInt(this.session.getSessionID());
            if (TRACER.isEnabled()) {
                TRACER.format("Writing repositoryUUID: {0}", new Object[]{this.repository.getUUID()});
            }
            out.writeString(this.repository.getUUID());
            out.writeLong(this.repository.getCreationTime());
            out.writeBoolean(this.repository.isSupportingAudits());
            this.repository.getStore().getCDOIDLibraryDescriptor().write((ExtendedDataOutput)out);
            InternalCDOPackageUnit[] packageUnits = this.repository.getPackageRegistry().getPackageUnits();
            out.writeCDOPackageUnits((CDOPackageUnit[])packageUnits);
        }
        catch (RepositoryNotFoundException repositoryNotFoundException) {
            if (TRACER.isEnabled()) {
                TRACER.format("Repository {0} not found", new Object[]{this.repositoryName});
            }
            out.writeInt(-1);
        }
        catch (SessionCreationException sessionCreationException) {
            if (TRACER.isEnabled()) {
                TRACER.format("Failed to open session for repository {0}", new Object[]{this.repositoryName});
            }
            out.writeInt(-2);
            return;
        }
        super.responding(out);
    }
}

