/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo;

import java.util.Collection;
import org.eclipse.emf.cdo.CDOSessionPackageManager;
import org.eclipse.emf.cdo.common.id.CDOIDMetaRange;
import org.eclipse.emf.cdo.common.id.CDOIDObjectFactory;
import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackage;
import org.eclipse.emf.cdo.common.model.CDOPackageInfo;
import org.eclipse.emf.cdo.common.model.CDOPackageManager;
import org.eclipse.emf.cdo.common.util.TransportException;
import org.eclipse.emf.cdo.internal.common.model.CDOPackageManagerImpl;
import org.eclipse.emf.cdo.util.EMFUtil;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.internal.cdo.CDOSessionImpl;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.protocol.LoadPackageRequest;
import org.eclipse.emf.internal.cdo.util.ModelUtil;
import org.eclipse.net4j.signal.RequestWithConfirmation;
import org.eclipse.net4j.signal.failover.IFailOverStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOSessionPackageManagerImpl
extends CDOPackageManagerImpl
implements CDOSessionPackageManager {
    private CDOSessionImpl session;

    public CDOSessionPackageManagerImpl(CDOSessionImpl session) {
        this.session = session;
        ModelUtil.addModelInfos(this);
    }

    public CDOSessionImpl getSession() {
        return this.session;
    }

    public CDOIDObjectFactory getCDOIDObjectFactory() {
        return this.session;
    }

    @Override
    public CDOPackage convert(EPackage ePackage) {
        return ModelUtil.getCDOPackage(ePackage, this);
    }

    @Override
    public CDOClass convert(EClass eClass) {
        return ModelUtil.getCDOClass(eClass, this);
    }

    @Override
    public CDOFeature convert(EStructuralFeature eFeature) {
        return ModelUtil.getCDOFeature(eFeature, this);
    }

    @Override
    public EPackage convert(CDOPackage cdoPackage) {
        return ModelUtil.getEPackage(cdoPackage, this.session.getPackageRegistry());
    }

    @Override
    public EClass convert(CDOClass cdoClass) {
        return ModelUtil.getEClass(cdoClass, this.session.getPackageRegistry());
    }

    @Override
    public EStructuralFeature convert(CDOFeature cdoFeature) {
        return ModelUtil.getEFeature(cdoFeature, this.session.getPackageRegistry());
    }

    public void addPackageProxies(Collection<CDOPackageInfo> packageInfos) {
        for (CDOPackageInfo info : packageInfos) {
            String packageURI = info.getPackageURI();
            boolean dynamic = info.isDynamic();
            CDOIDMetaRange metaIDRange = info.getMetaIDRange();
            String parentURI = info.getParentURI();
            CDOPackage proxy = CDOModelUtil.createProxyPackage((CDOPackageManager)this, (String)packageURI, (boolean)dynamic, (CDOIDMetaRange)metaIDRange, (String)parentURI);
            this.addPackage(proxy);
            this.session.getPackageRegistry().putPackageDescriptor(proxy);
        }
    }

    protected void resolve(CDOPackage cdoPackage) {
        if (!cdoPackage.isDynamic()) {
            String uri = cdoPackage.getPackageURI();
            EPackage ePackage = this.session.getPackageRegistry().getEPackage(uri);
            if (ePackage != null) {
                ModelUtil.initializeCDOPackage(ePackage, cdoPackage);
                return;
            }
        }
        try {
            IFailOverStrategy failOverStrategy = this.session.getFailOverStrategy();
            LoadPackageRequest request = new LoadPackageRequest(this.session.getChannel(), cdoPackage);
            failOverStrategy.send((RequestWithConfirmation)request);
            if (!cdoPackage.isDynamic()) {
                OM.LOG.info("Dynamic package created for " + cdoPackage.getPackageURI());
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new TransportException((Throwable)ex);
        }
    }

    protected String provideEcore(CDOPackage cdoPackage) {
        EPackage ePackage = ModelUtil.getEPackage(cdoPackage, this.session.getPackageRegistry());
        return EMFUtil.ePackageToString(ePackage, this.session.getPackageRegistry());
    }
}

