/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.util.bundle;

import org.eclipse.net4j.internal.util.bundle.AbstractPlatform;
import org.eclipse.net4j.internal.util.container.PluginContainer;
import org.eclipse.net4j.internal.util.om.OSGiBundle;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.om.OMBundle;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.log.EclipseLoggingBridge;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.net4j.util.om.log.PrintLogHandler;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.om.trace.OMTracer;
import org.eclipse.net4j.util.om.trace.PrintTraceHandler;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public abstract class OM {
    public static final String BUNDLE_ID = "org.eclipse.net4j.util";
    public static final OMBundle BUNDLE = OMPlatform.INSTANCE.bundle("org.eclipse.net4j.util", OM.class);
    public static final OMTracer DEBUG = BUNDLE.tracer("debug");
    public static final OMTracer DEBUG_LIFECYCLE = DEBUG.tracer("lifecycle");
    public static final OMTracer DEBUG_LIFECYCLE_DUMP = DEBUG_LIFECYCLE.tracer("dump");
    public static final OMTracer DEBUG_CONCURRENCY = DEBUG.tracer("concurrency");
    public static final OMTracer DEBUG_REGISTRY = DEBUG.tracer("registry");
    public static final OMTracer DEBUG_OM = DEBUG.tracer("om");
    public static final OMLogger LOG = BUNDLE.logger();
    private static final ContextTracer TRACER = new ContextTracer(DEBUG_OM, OM.class);

    static void stop() throws Exception {
        PluginContainer.dispose();
    }

    public static final class Activator
    implements BundleActivator {
        public void start(BundleContext context) throws Exception {
            AbstractPlatform.systemContext = context;
            BUNDLE.setBundleContext(context);
            ((OSGiBundle)BUNDLE).start();
            PrintTraceHandler.CONSOLE.setPattern("{6} [{0}] {5}");
            AbstractPlatform.INSTANCE.addTraceHandler(PrintTraceHandler.CONSOLE);
            AbstractPlatform.INSTANCE.addLogHandler(PrintLogHandler.CONSOLE);
            try {
                AbstractPlatform.INSTANCE.addLogHandler(EclipseLoggingBridge.INSTANCE);
            }
            catch (Exception exception) {}
            Activator.traceStart(context);
            IPluginContainer container = IPluginContainer.INSTANCE;
            if (TRACER.isEnabled()) {
                TRACER.format("Plugin container created: {0}", container);
            }
        }

        public void stop(BundleContext context) throws Exception {
            Activator.traceStop(context);
            ((OSGiBundle)BUNDLE).stop();
            BUNDLE.setBundleContext(null);
            AbstractPlatform.systemContext = null;
        }

        public static void traceStart(BundleContext context) {
            try {
                if (TRACER.isEnabled()) {
                    TRACER.format("Starting bundle {0}", context.getBundle().getSymbolicName());
                }
            }
            catch (RuntimeException runtimeException) {}
        }

        public static void traceStop(BundleContext context) {
            try {
                if (TRACER.isEnabled()) {
                    TRACER.format("Stopping bundle {0}", context.getBundle().getSymbolicName());
                }
            }
            catch (RuntimeException runtimeException) {}
        }
    }
}

