/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.lifecycle;

import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.event.Notifier;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.ILifecycleEvent;
import org.eclipse.net4j.util.lifecycle.ILifecycleState;
import org.eclipse.net4j.util.lifecycle.LifecycleEvent;
import org.eclipse.net4j.util.lifecycle.LifecycleException;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class Lifecycle
extends Notifier
implements ILifecycle.Introspection {
    public static boolean USE_LABEL = true;
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_LIFECYCLE, Lifecycle.class);
    private static final ContextTracer DUMPER = new ContextTracer(OM.DEBUG_LIFECYCLE_DUMP, Lifecycle.class);
    private static final boolean TRACE_IGNORING = false;
    private ILifecycleState lifecycleState = ILifecycleState.INACTIVE;

    protected Lifecycle() {
    }

    public final void activate() throws LifecycleException {
        if (this.lifecycleState == ILifecycleState.INACTIVE) {
            if (TRACER.isEnabled()) {
                TRACER.trace("Activating " + this);
            }
            this.lifecycleState = ILifecycleState.ACTIVATING;
            this.fireEvent(new LifecycleEvent(this, ILifecycleEvent.Kind.ABOUT_TO_ACTIVATE));
            try {
                this.doBeforeActivate();
                this.doActivate();
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new LifecycleException(ex);
            }
            if (!this.isDeferredActivation()) {
                this.deferredActivate();
            }
        }
    }

    public final Exception deactivate() {
        if (this.lifecycleState == ILifecycleState.ACTIVE || this.lifecycleState == ILifecycleState.ACTIVATING) {
            if (TRACER.isEnabled()) {
                TRACER.trace("Deactivating " + this);
            }
            try {
                this.lifecycleState = ILifecycleState.DEACTIVATING;
                this.doBeforeDeactivate();
                this.fireEvent(new LifecycleEvent(this, ILifecycleEvent.Kind.ABOUT_TO_DEACTIVATE));
                if (!this.isDeferredDeactivation()) {
                    this.deferredDeactivate();
                }
            }
            catch (Exception ex) {
                OM.LOG.error(ex);
                return ex;
            }
        }
        return null;
    }

    public final ILifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public final boolean isActive() {
        return this.lifecycleState == ILifecycleState.ACTIVE;
    }

    public String toString() {
        if (USE_LABEL) {
            return ReflectUtil.getLabel(this);
        }
        return super.toString();
    }

    protected final void dump() {
        if (DUMPER.isEnabled()) {
            DUMPER.trace("DUMP" + ReflectUtil.toString(this));
        }
    }

    protected final void checkActive() {
        if (this.lifecycleState != ILifecycleState.ACTIVE) {
            throw new IllegalStateException("Not active: " + this);
        }
    }

    protected final void checkInactive() {
        if (this.lifecycleState != ILifecycleState.INACTIVE) {
            throw new IllegalStateException("Not inactive: " + this);
        }
    }

    protected final void checkNull(Object handle, String msg) throws NullPointerException {
        CheckUtil.checkNull(handle, msg);
    }

    protected final void checkArg(boolean expr, String msg) throws IllegalArgumentException {
        CheckUtil.checkArg(expr, msg);
    }

    protected final void checkArg(Object handle, String handleName) throws IllegalArgumentException {
        CheckUtil.checkState(handle, handleName);
    }

    protected final void checkState(boolean expr, String msg) throws IllegalStateException {
        CheckUtil.checkState(expr, msg);
    }

    protected final void checkState(Object handle, String handleName) throws IllegalStateException {
        CheckUtil.checkState(handle, handleName);
    }

    protected final void deferredActivate() {
        this.lifecycleState = ILifecycleState.ACTIVE;
        this.fireEvent(new LifecycleEvent(this, ILifecycleEvent.Kind.ACTIVATED));
        this.dump();
    }

    protected final void deferredDeactivate() throws Exception {
        this.doDeactivate();
        this.lifecycleState = ILifecycleState.INACTIVE;
        this.fireEvent(new LifecycleEvent(this, ILifecycleEvent.Kind.DEACTIVATED));
    }

    protected boolean isDeferredActivation() {
        return false;
    }

    protected boolean isDeferredDeactivation() {
        return false;
    }

    protected void doBeforeActivate() throws Exception {
    }

    protected void doActivate() throws Exception {
    }

    protected void doBeforeDeactivate() throws Exception {
    }

    protected void doDeactivate() throws Exception {
    }
}

