/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.om.monitor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.internal.util.om.monitor.EclipseMonitor;
import org.eclipse.net4j.internal.util.om.monitor.LegacyMonitor;
import org.eclipse.net4j.internal.util.om.monitor.MON;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.monitor.OMMonitorHandler;

public final class MonitorUtil {
    private MonitorUtil() {
    }

    public static boolean isCanceled() {
        return MON.isCanceled();
    }

    public static OMMonitor begin() {
        return MON.begin(-1, null);
    }

    public static OMMonitor begin(int totalWork) {
        return MON.begin(totalWork, null);
    }

    public static OMMonitor begin(String task) {
        return MON.begin(-1, task);
    }

    public static OMMonitor begin(int totalWork, String task) {
        return MON.begin(totalWork, task);
    }

    static void handleTrace(OMMonitorHandler messageHandler, String msg, int level, boolean isTask) {
        if (messageHandler != null) {
            try {
                if (isTask) {
                    messageHandler.handleTask(msg, level);
                } else {
                    messageHandler.handleMessage(msg, level);
                }
            }
            catch (RuntimeException ex) {
                OM.LOG.error(ex);
            }
        }
    }

    public static final class Eclipse {
        public static void startMonitoring(IProgressMonitor progressMonitor, final OMMonitorHandler messageHandler) {
            MON.startMonitoring(new EclipseMonitor(progressMonitor){

                protected void trace(String msg, int level, boolean isTask) {
                    super.trace(msg, level, isTask);
                    MonitorUtil.handleTrace(messageHandler, msg, level, isTask);
                }
            });
        }

        public static void startMonitoring(IProgressMonitor progressMonitor) {
            Eclipse.startMonitoring(progressMonitor, null);
        }

        public static void stopMonitoring() {
            MON.stopMonitoring();
        }
    }

    public static final class Legacy {
        public static void startMonitoring(final OMMonitorHandler messageHandler) {
            MON.startMonitoring(new LegacyMonitor(){

                protected void trace(String msg, int level, boolean isTask) {
                    super.trace(msg, level, isTask);
                    MonitorUtil.handleTrace(messageHandler, msg, level, isTask);
                }
            });
        }

        public static void startMonitoring() {
            Legacy.startMonitoring(null);
        }

        public static void stopMonitoring() {
            MON.stopMonitoring();
        }
    }
}

