/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.transaction;

import org.eclipse.emf.cdo.transaction.CDOSavepoint;
import org.eclipse.emf.cdo.transaction.CDOUserTransaction;

public abstract class AbstractSavepoint
implements CDOSavepoint {
    private CDOUserTransaction userTransaction;
    private AbstractSavepoint previousSavepoint;
    private AbstractSavepoint nextSavepoint;

    public AbstractSavepoint(CDOUserTransaction transaction, AbstractSavepoint lastSavepoint) {
        this.userTransaction = transaction;
        this.previousSavepoint = lastSavepoint;
        if (this.previousSavepoint != null) {
            this.previousSavepoint.setNextSavepoint(this);
        }
    }

    public void setPreviousSavepoint(AbstractSavepoint previousSavepoint) {
        this.previousSavepoint = previousSavepoint;
    }

    public void setNextSavepoint(AbstractSavepoint nextSavepoint) {
        this.nextSavepoint = nextSavepoint;
    }

    public CDOSavepoint getNextSavepoint() {
        return this.nextSavepoint;
    }

    public CDOSavepoint getPreviousSavepoint() {
        return this.previousSavepoint;
    }

    public AbstractSavepoint getFirstSavePoint() {
        return this.previousSavepoint != null ? this.previousSavepoint.getFirstSavePoint() : this;
    }

    public CDOUserTransaction getUserTransaction() {
        return this.userTransaction;
    }

    public boolean isValid() {
        CDOSavepoint lastSavepoint;
        CDOSavepoint savepoint = lastSavepoint = this.getUserTransaction().getLastSavepoint();
        while (savepoint != null) {
            if (savepoint == this) {
                return true;
            }
            savepoint = savepoint.getPreviousSavepoint();
        }
        return false;
    }

    public void rollback() {
        this.getUserTransaction().rollback(this);
    }
}

