/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.codegen.extended.ui.launcher;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.eef.EEFGen.EEFGenModel;
import org.eclipse.emf.eef.codegen.EEFCodegenPlugin;
import org.eclipse.emf.eef.codegen.extended.flow.OverrideEMFEditorCode;
import org.eclipse.emf.eef.codegen.flow.Step;
import org.eclipse.emf.eef.codegen.flow.Workflow;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateEEFEditorAction
implements IObjectActionDelegate {
    private static final String GENERATE_EEF_EDITOR = "Generate EEF Editor for ";
    private Shell shell;
    protected Set<IFile> selectedFiles = new LinkedHashSet<IFile>();
    protected List<EEFGenModel> eefGenModels = new ArrayList<EEFGenModel>();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        try {
            if (this.selectedFiles != null) {
                this.eefGenModels = this.initEEFGenModel();
                if (this.eefGenModels != null) {
                    final Workflow flow = new Workflow("Generate EEF Editors", this.shell);
                    for (EEFGenModel eefGenModel : this.eefGenModels) {
                        String key = GENERATE_EEF_EDITOR + eefGenModel.eResource().getURI().toString();
                        OverrideEMFEditorCode eefEditorCode = new OverrideEMFEditorCode(key, eefGenModel);
                        flow.addStep(key, (Step)eefEditorCode);
                    }
                    flow.prepare();
                    IRunnableWithProgress runnable = new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            flow.execute(monitor);
                            monitor.done();
                            GenerateEEFEditorAction.this.selectedFiles.clear();
                            GenerateEEFEditorAction.this.eefGenModels.clear();
                        }
                    };
                    new ProgressMonitorDialog(this.shell).run(true, true, runnable);
                }
            }
        }
        catch (InvocationTargetException e) {
            EEFCodegenPlugin.getDefault().logError((Exception)e);
        }
        catch (InterruptedException e) {
            EEFCodegenPlugin.getDefault().logWarning((Exception)e);
        }
        catch (IOException e) {
            EEFCodegenPlugin.getDefault().logError((Exception)e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof StructuredSelection) {
            StructuredSelection sSelection = (StructuredSelection)selection;
            this.selectedFiles.clear();
            for (Object selectedElement : sSelection.toList()) {
                if (!(selectedElement instanceof IFile)) continue;
                this.selectedFiles.add((IFile)selectedElement);
            }
        }
    }

    protected List<EEFGenModel> initEEFGenModel() throws IOException {
        if (!this.selectedFiles.isEmpty()) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            for (IFile selectedFile : this.selectedFiles) {
                EObject object;
                Resource.Factory.Registry registry;
                Object resourceFactory;
                URI modelURI = URI.createPlatformResourceURI((String)selectedFile.getFullPath().toString(), (boolean)true);
                String fileExtension = modelURI.fileExtension();
                if (fileExtension == null || fileExtension.length() == 0) {
                    fileExtension = "*";
                }
                if ((resourceFactory = (registry = Resource.Factory.Registry.INSTANCE).getExtensionToFactoryMap().get(fileExtension)) != null) {
                    resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(fileExtension, resourceFactory);
                } else {
                    resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(fileExtension, new XMIResourceFactoryImpl());
                }
                Resource res = resourceSet.createResource(modelURI);
                res.load(Collections.EMPTY_MAP);
                EcoreUtil.resolveAll((ResourceSet)resourceSet);
                if (res.getContents().size() <= 0 || !((object = (EObject)res.getContents().get(0)) instanceof EEFGenModel)) continue;
                this.eefGenModels.add((EEFGenModel)object);
            }
        }
        return this.eefGenModels;
    }
}

