/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.codegen.flow.impl;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.eef.codegen.core.util.EMFHelper;
import org.eclipse.emf.eef.codegen.flow.Step;
import org.eclipse.emf.eef.codegen.flow.util.GenmodelHelper;
import org.eclipse.emf.eef.codegen.flow.var.WorkflowVariable;
import org.eclipse.emf.importer.ModelImporter;
import org.eclipse.emf.importer.ecore.EcoreImporter;

public class InitializeGenModel
extends Step {
    private WorkflowVariable genmodelVar;
    private WorkflowVariable genmodelURIVar;
    private IFile modelFile;
    private IContainer targetFolder;
    private String genmodelFileName;

    public InitializeGenModel(String name, IFile modelFile, IContainer targetFolder, String genmodelFileName) {
        super(name);
        this.modelFile = modelFile;
        this.targetFolder = targetFolder;
        this.genmodelFileName = genmodelFileName;
    }

    public IStatus execute(IProgressMonitor monitor) {
        try {
            BasicMonitor emfMonitor = new BasicMonitor();
            ModelImporter importer = this.initializeConverter(this.genmodelFileName, (Monitor)emfMonitor);
            this.initializeGenModel(importer, (Monitor)emfMonitor);
            this.targetFolder.refreshLocal(2, monitor);
            URI genmodelURI = GenmodelHelper.computeGenmodelURI(this.targetFolder, this.genmodelFileName);
            ((WorkflowVariable)this.getGenModelURI()).setValue((Object)genmodelURI);
            ((WorkflowVariable)this.genmodel()).setValue((Object)EMFHelper.load(genmodelURI, this.resourceSet));
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.emf.eef.codegen", "An error occured during genmodel initialization", (Throwable)e);
        }
    }

    private final String genmodelVarName() {
        return "INIT_GENMODEL_" + this.name + "_GENMODEL";
    }

    private final String genmodelURIVarName() {
        return "INIT_GENMODEL_" + this.name + "_GENMODEL_URI";
    }

    public Object genmodel() {
        if (this.genmodelVar == null) {
            this.genmodelVar = new WorkflowVariable(this.genmodelVarName());
            this.getContext().add(this.genmodelVar);
        }
        return this.genmodelVar;
    }

    public Object getGenModelURI() {
        if (this.genmodelURIVar == null) {
            this.genmodelURIVar = new WorkflowVariable(this.genmodelURIVarName());
        }
        return this.genmodelURIVar;
    }

    private ModelImporter initializeConverter(String genmodelFileName, Monitor monitor) throws Exception {
        EcoreImporter converter = new EcoreImporter();
        converter.setGenModelContainerPath(this.targetFolder.getFullPath());
        converter.setGenModelFileName(genmodelFileName);
        converter.setModelFile(this.modelFile);
        converter.computeEPackages(monitor);
        converter.adjustEPackages(monitor);
        return converter;
    }

    protected void initializeGenModel(ModelImporter importer, Monitor monitor) throws Exception {
        importer.prepareGenModelAndEPackages(monitor);
        this.configureGenModel(importer.getGenModel());
        importer.saveGenModelAndEPackages(monitor);
    }

    protected void configureGenModel(GenModel genModel) {
    }
}

