/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.internal.widgets;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.core.api.controllers.IEEFHyperlinkController;
import org.eclipse.eef.ide.ui.internal.EEFIdeUiPlugin;
import org.eclipse.eef.ide.ui.internal.widgets.EEFHyperlinkLifecycleManager;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;

public class EEFHyperlinkListener
implements MouseListener {
    private EEFHyperlinkLifecycleManager lifecycleManager;
    private StyledText hyperlink;
    private IEEFFormContainer container;
    private IEEFHyperlinkController controller;

    public EEFHyperlinkListener(EEFHyperlinkLifecycleManager lifecycleManager, StyledText hyperlink, IEEFFormContainer container, IEEFHyperlinkController controller) {
        this.lifecycleManager = lifecycleManager;
        this.hyperlink = hyperlink;
        this.container = container;
        this.controller = controller;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        try {
            int offset = this.hyperlink.getOffsetAtLocation(new Point(e.x, e.y));
            StyleRange stylerange = this.hyperlink.getStyleRangeAtOffset(offset);
            if (stylerange != null && !this.container.isRenderingInProgress()) {
                IStatus result = this.controller.onClick(this.hyperlink.getData());
                if (result != null && result.getSeverity() == 4) {
                    EEFIdeUiPlugin.INSTANCE.log(result);
                } else {
                    this.lifecycleManager.refresh();
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void mouseUp(MouseEvent e) {
    }
}

