/*******************************************************************************
 * Copyright (c) 2009 itemis AG (http://www.itemis.eu) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package org.eclipse.emf.emfindex.event;

/**
 * @author koehnlein - Initial contribution and API
 */
public class IndexChangeEventImpl implements IndexChangeEvent {

	private Type type;
	private Object oldDescriptor;
	private Object newDescriptor;

	public IndexChangeEventImpl(Type type, Object oldDescriptor, Object newDescriptor) {
		super();
		this.type = type;
		this.oldDescriptor = oldDescriptor;
		this.newDescriptor = newDescriptor;
	}
	
	public Object getNewDescriptor() {
		return newDescriptor;
	}

	public Object getOldDescriptor() {
		return oldDescriptor;
	}

	public Type getType() {
		return type;
	}

}
