/*******************************************************************************
 * Copyright (c) 2009 itemis AG (http://www.itemis.eu) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package org.eclipse.emf.emfindex.store;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.emfindex.ContainerDescriptor;
import org.eclipse.emf.emfindex.MemoryIndexImpl;
import org.eclipse.emf.emfindex.ResourceDescriptor;
import org.eclipse.emf.emfindex.URI2ResourceCache;

import com.google.inject.Inject;

/**
 * @author koehnlein
 * 
 */
public class IndexUpdaterImpl implements IndexUpdater {

	private MemoryIndexImpl index;

	private DescriptorFactory descriptorFactory;

	@Inject
	public IndexUpdaterImpl(MemoryIndexImpl index) {
		this.index = index;
		index.addIndexAdapter(new URI2ResourceCache());
		descriptorFactory = new DescriptorFactoryImpl();
	}

	public void add(ContainerDescriptor containerContainerDescriptor, ContainerDescriptor newContainerDescriptor) {
		// TODO Auto-generated method stub
	}

	public void update(ContainerDescriptor rootContainerDescriptor) {
		// TODO Auto-generated method stub
	}

	public void deleteContainerDescriptor(String name) {
		// TODO Auto-generated method stub
	}

	public void deleteResourceDescriptor(URI resourceURI) {
		ResourceDescriptor existingResourceDescriptor = index.findIndexAdapter(URI2ResourceCache.class)
				.findResourceDescriptor(resourceURI);
		if (existingResourceDescriptor != null) {
			remove((EObject) existingResourceDescriptor);
		}
	}

	public void update(ResourceDescriptor rootResourceDescriptor) {
		URI resourceURI = rootResourceDescriptor.getURI();
		ResourceDescriptor existingResourceDescriptor = index.findIndexAdapter(URI2ResourceCache.class)
				.findResourceDescriptor(resourceURI);
		if (existingResourceDescriptor != null) {
			EcoreUtil.replace((EObject) existingResourceDescriptor, (EObject) rootResourceDescriptor);
		} else {
			Resource newIndexResource = index.createResource();
			newIndexResource.getContents().add((EObject) rootResourceDescriptor);
		}
		Resource indexResource = ((EObject) rootResourceDescriptor).eResource();
		if(indexResource != null) {
			indexResource.setModified(true);
		}
	}

	private void remove(EObject oldObject) {
		Resource resource = ((InternalEObject) oldObject).eDirectResource();
		EcoreUtil.remove(oldObject);
		if (resource != null) {
			if (resource.getContents().isEmpty()) {
				index.deleteResource(resource);
			} else {
				resource.setModified(true);
			}
		}
	}

	public DescriptorFactory getDescriptorFactory() {
		return descriptorFactory;
	}
}
