/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.AbstractErrorHandler;
import com.google.inject.Binding;
import com.google.inject.BindingImpl;
import com.google.inject.BoundProviderFactory;
import com.google.inject.ConfigurationException;
import com.google.inject.ConstantConversionException;
import com.google.inject.ConstantFactory;
import com.google.inject.ConstructionProxyFactory;
import com.google.inject.ConstructorInjector;
import com.google.inject.ContextualCallable;
import com.google.inject.ErrorHandler;
import com.google.inject.ErrorMessages;
import com.google.inject.ExternalContext;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.InternalContext;
import com.google.inject.InternalFactory;
import com.google.inject.InvalidErrorHandler;
import com.google.inject.Key;
import com.google.inject.ProvidedBy;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.cglib.reflect.FastClass;
import com.google.inject.cglib.reflect.FastMethod;
import com.google.inject.spi.SourceProviders;
import com.google.inject.util.GuiceFastClass;
import com.google.inject.util.Objects;
import com.google.inject.util.ReferenceCache;
import com.google.inject.util.StackTraceElements;
import com.google.inject.util.Strings;
import com.google.inject.util.ToStringBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InjectorImpl
implements Injector {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_COUNTERPARTS;
    private static final Map<Class<?>, Converter<?>> PRIMITIVE_CONVERTERS;
    final ConstructionProxyFactory constructionProxyFactory;
    final Map<Key<?>, BindingImpl<?>> bindings;
    final BindingsMultimap bindingsMultimap = new BindingsMultimap();
    final Map<Class<? extends Annotation>, Scope> scopes;
    ErrorHandler errorHandler = new InvalidErrorHandler();
    Object defaultSource = SourceProviders.UNKNOWN_SOURCE;
    final Map<Class<?>, List<SingleMemberInjector>> injectors = new ReferenceCache<Class<?>, List<SingleMemberInjector>>(){

        @Override
        protected List<SingleMemberInjector> create(Class<?> key) {
            ArrayList<SingleMemberInjector> injectors = new ArrayList<SingleMemberInjector>();
            InjectorImpl.this.addInjectors(key, injectors);
            return injectors;
        }
    };
    final Map<Class<?>, ConstructorInjector> constructors = new ReferenceCache<Class<?>, ConstructorInjector>(){

        @Override
        protected ConstructorInjector<?> create(Class<?> implementation) {
            if (implementation.isInterface()) {
                InjectorImpl.this.errorHandler.handle(InjectorImpl.this.defaultSource, "Injecting into abstract types is not supported. Please use a concrete type instead of %s.", implementation);
                return ConstructorInjector.invalidConstructor();
            }
            return new ConstructorInjector(InjectorImpl.this, implementation);
        }
    };
    final ThreadLocal<InternalContext[]> localContext = new ThreadLocal<InternalContext[]>(){

        @Override
        protected InternalContext[] initialValue() {
            return new InternalContext[1];
        }
    };
    Map<Class<?>, InternalFactory<?>> implicitBindings = new HashMap();
    private static final InternalFactory<?> INVALID_FACTORY;

    InjectorImpl(ConstructionProxyFactory constructionProxyFactory, Map<Key<?>, BindingImpl<?>> bindings, Map<Class<? extends Annotation>, Scope> scopes) {
        this.constructionProxyFactory = constructionProxyFactory;
        this.bindings = bindings;
        this.scopes = scopes;
    }

    void index() {
        for (BindingImpl<?> binding : this.bindings.values()) {
            this.index(binding);
        }
    }

    <T> void index(BindingImpl<T> binding) {
        this.bindingsMultimap.put(binding.getKey().getTypeLiteral(), binding);
    }

    @Override
    public <T> List<Binding<T>> findBindingsByType(TypeLiteral<T> type) {
        return Collections.unmodifiableList(this.bindingsMultimap.getAll(type));
    }

    <T> List<String> getNamesOfBindingAnnotations(TypeLiteral<T> type) {
        ArrayList<String> names = new ArrayList<String>();
        for (Binding<T> binding : this.findBindingsByType(type)) {
            Key<T> key = binding.getKey();
            if (!key.hasAnnotationType()) {
                names.add("[no annotation]");
                continue;
            }
            names.add(key.getAnnotationName());
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void withDefaultSource(Object defaultSource, Runnable runnable) {
        Object previous = this.defaultSource;
        this.defaultSource = defaultSource;
        try {
            runnable.run();
        }
        finally {
            this.defaultSource = previous;
        }
    }

    void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> InternalFactory<? extends T> getInternalFactory(final Member member, Key<T> key) {
        Binding counterpartBinding;
        Binding binding = this.getBinding((Key)key);
        if (binding != null) {
            return ((BindingImpl)binding).getInternalFactory();
        }
        Class<T> rawType = key.getTypeLiteral().getRawType();
        if (rawType.equals(Provider.class)) {
            Type providerType = key.getTypeLiteral().getType();
            if (!(providerType instanceof ParameterizedType)) {
                return null;
            }
            Type entryType = ((ParameterizedType)providerType).getActualTypeArguments()[0];
            try {
                final Provider<?> provider = this.getProvider(key.ofType(entryType));
                return new InternalFactory<T>(){

                    @Override
                    public T get(InternalContext context) {
                        return provider;
                    }
                };
            }
            catch (ConfigurationException e) {
                if (key.hasAttributes()) {
                    return this.getInternalFactory(member, key.withoutAttributes());
                }
                ErrorMessages.handleMissingBinding(this.errorHandler, member, key, this.getNamesOfBindingAnnotations(key.getTypeLiteral()));
                return InjectorImpl.invalidFactory();
            }
        }
        Class<?> primitiveCounterpart = PRIMITIVE_COUNTERPARTS.get(rawType);
        if (primitiveCounterpart != null && (counterpartBinding = this.getBinding((Key)key.ofType(primitiveCounterpart))) != null) {
            return ((BindingImpl)counterpartBinding).getInternalFactory();
        }
        Key<String> stringKey = key.ofType(String.class);
        Binding stringBinding = this.getBinding((Key)stringKey);
        if (stringBinding != null && ((BindingImpl)stringBinding).isConstant()) {
            String value = (String)((BindingImpl)stringBinding).getInternalFactory().get(null);
            Converter<?> converter = PRIMITIVE_CONVERTERS.get(rawType);
            if (converter != null) {
                try {
                    Object t = converter.convert(member, key, value);
                    return new ConstantFactory(t);
                }
                catch (ConstantConversionException e) {
                    return this.handleConstantConversionError(member, stringBinding, rawType, e);
                }
            }
            if (Enum.class.isAssignableFrom(rawType)) {
                T t;
                try {
                    t = Enum.valueOf(rawType, value);
                }
                catch (IllegalArgumentException e) {
                    return this.handleConstantConversionError(member, stringBinding, rawType, e);
                }
                return new ConstantFactory<T>(t);
            }
            if (rawType == Class.class) {
                try {
                    return new ConstantFactory(Class.forName(value));
                }
                catch (ClassNotFoundException e) {
                    return this.handleConstantConversionError(member, stringBinding, rawType, e);
                }
            }
        }
        int modifiers = rawType.getModifiers();
        if (rawType.isArray() || rawType.isEnum() || rawType.isPrimitive()) {
            if (key.hasAttributes()) {
                return this.getInternalFactory(member, key.withoutAttributes());
            }
            return null;
        }
        if (key.hasAnnotationType()) {
            if (key.hasAttributes()) {
                return this.getInternalFactory(member, key.withoutAttributes());
            }
            return null;
        }
        if (member != null) {
            final ErrorHandler previous = this.errorHandler;
            this.errorHandler = new AbstractErrorHandler(){

                public void handle(Object source, String message) {
                    previous.handle(source, "Error while injecting at " + StackTraceElements.forMember(member) + ": " + message);
                }
            };
            try {
                InternalFactory<T> internalFactory = this.getImplicitBinding(member, rawType, null);
                return internalFactory;
            }
            finally {
                this.errorHandler = previous;
            }
        }
        return this.getImplicitBinding(member, rawType, null);
    }

    private <T> InternalFactory<T> handleConstantConversionError(Member member, Binding<String> stringBinding, Class<?> rawType, Exception e) {
        this.errorHandler.handle(StackTraceElements.forMember(member), "Error converting String constant bound at %s to %s: %s", stringBinding.getSource(), rawType, e.getMessage());
        return InjectorImpl.invalidFactory();
    }

    void addInjectors(Class clazz, List<SingleMemberInjector> injectors) {
        if (clazz == Object.class) {
            return;
        }
        this.addInjectors(clazz.getSuperclass(), injectors);
        this.addSingleInjectorsForFields(clazz.getDeclaredFields(), false, injectors);
        this.addSingleInjectorsForMethods(clazz.getDeclaredMethods(), false, injectors);
    }

    void addSingleInjectorsForMethods(Method[] methods, boolean statics, List<SingleMemberInjector> injectors) {
        this.addInjectorsForMembers(Arrays.asList(methods), statics, injectors, new SingleInjectorFactory<Method>(){

            @Override
            public SingleMemberInjector create(InjectorImpl injector, Method method) throws MissingDependencyException {
                return new SingleMethodInjector(injector, method);
            }
        });
    }

    void addSingleInjectorsForFields(Field[] fields, boolean statics, List<SingleMemberInjector> injectors) {
        this.addInjectorsForMembers(Arrays.asList(fields), statics, injectors, new SingleInjectorFactory<Field>(){

            @Override
            public SingleMemberInjector create(InjectorImpl injector, Field field) throws MissingDependencyException {
                return new SingleFieldInjector(injector, field);
            }
        });
    }

    <M extends Member & AnnotatedElement> void addInjectorsForMembers(List<M> members, boolean statics, List<SingleMemberInjector> injectors, SingleInjectorFactory<M> injectorFactory) {
        for (Member member : members) {
            Inject inject;
            if (this.isStatic(member) != statics || (inject = ((AnnotatedElement)((Object)member)).getAnnotation(Inject.class)) == null) continue;
            try {
                injectors.add(injectorFactory.create(this, member));
            }
            catch (MissingDependencyException e) {
                if (inject.optional()) continue;
                e.handle(this.errorHandler);
            }
        }
    }

    Map<Key<?>, BindingImpl<?>> internalBindings() {
        return this.bindings;
    }

    @Override
    public Map<Key<?>, Binding<?>> getBindings() {
        return Collections.unmodifiableMap(this.bindings);
    }

    public <T> BindingImpl<T> getBinding(Key<T> key) {
        return this.bindings.get(key);
    }

    private boolean isStatic(Member member) {
        return Modifier.isStatic(member.getModifiers());
    }

    <M extends AccessibleObject> SingleParameterInjector<?>[] getParametersInjectors(M member, Annotation[][] annotations, Type[] parameterTypes) throws MissingDependencyException {
        SingleParameterInjector[] parameterInjectors = new SingleParameterInjector[parameterTypes.length];
        Iterator annotationsIterator = Arrays.asList(annotations).iterator();
        int index = 0;
        for (Type parameterType : parameterTypes) {
            Annotation[] parameterAnnotations = (Annotation[])annotationsIterator.next();
            Key<?> key = Key.get(parameterType, (Member)((Object)member), parameterAnnotations, this.errorHandler);
            parameterInjectors[index] = this.createParameterInjector(key, (Member)((Object)member), index);
            ++index;
        }
        return parameterInjectors;
    }

    <T> SingleParameterInjector<T> createParameterInjector(Key<T> key, Member member, int index) throws MissingDependencyException {
        InternalFactory<T> factory = this.getInternalFactory(member, key);
        if (factory == null) {
            throw new MissingDependencyException(key, member);
        }
        ExternalContext<T> externalContext = ExternalContext.newInstance(member, index, key, this);
        return new SingleParameterInjector<T>(externalContext, factory);
    }

    static <T> Constructor<T> invalidConstructor() {
        try {
            return InvalidConstructor.class.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    static Object[] getParameters(InternalContext context, SingleParameterInjector[] parameterInjectors) {
        if (parameterInjectors == null) {
            return null;
        }
        Object[] parameters = new Object[parameterInjectors.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = parameterInjectors[i].inject(context);
        }
        return parameters;
    }

    void injectMembers(Object o, InternalContext context) {
        List<SingleMemberInjector> injectorsForClass = this.injectors.get(o.getClass());
        for (SingleMemberInjector injector : injectorsForClass) {
            injector.inject(context, o);
        }
    }

    @Override
    public void injectMembers(final Object o) {
        this.callInContext(new ContextualCallable<Void>(){

            @Override
            public Void call(InternalContext context) {
                InjectorImpl.this.injectMembers(o, context);
                return null;
            }
        });
    }

    @Override
    public <T> Provider<T> getProvider(Class<T> type) {
        return this.getProvider(Key.get(type));
    }

    @Override
    public <T> Provider<T> getProvider(final Key<T> key) {
        final InternalFactory<T> factory = this.getInternalFactory(null, key);
        if (factory == null) {
            throw new ConfigurationException("Missing binding to " + ErrorMessages.convert(key) + ".");
        }
        return new Provider<T>(){

            @Override
            public T get() {
                return InjectorImpl.this.callInContext(new ContextualCallable<T>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public T call(InternalContext context) {
                        ExternalContext previous = context.getExternalContext();
                        context.setExternalContext(ExternalContext.newInstance(null, key, InjectorImpl.this));
                        try {
                            Object t = factory.get(context);
                            return t;
                        }
                        finally {
                            context.setExternalContext(previous);
                        }
                    }
                });
            }

            public String toString() {
                return factory.toString();
            }
        };
    }

    @Override
    public <T> T getInstance(Key<T> key) {
        return this.getProvider(key).get();
    }

    @Override
    public <T> T getInstance(Class<T> type) {
        return this.getProvider(type).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T callInContext(ContextualCallable<T> callable) {
        InternalContext[] reference = this.localContext.get();
        if (reference[0] == null) {
            reference[0] = new InternalContext(this);
            try {
                T t = callable.call(reference[0]);
                return t;
            }
            finally {
                reference[0] = null;
            }
        }
        return callable.call(reference[0]);
    }

    <T> ConstructorInjector<T> getConstructor(Class<T> implementation) {
        return this.constructors.get(implementation);
    }

    <T> ConstructorInjector<T> getConstructor(TypeLiteral<T> implementation) {
        return this.constructors.get(implementation.getRawType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> InternalFactory<? extends T> getImplicitBinding(Member member, final Class<T> type, Scope scope) {
        ImplementedBy implementedBy = type.getAnnotation(ImplementedBy.class);
        if (implementedBy != null) {
            Class<?> implementationType = implementedBy.value();
            if (implementationType == type) {
                this.errorHandler.handle(StackTraceElements.forType(type), "@DefaultImplementation points to the same class it annotates.", type);
                return InjectorImpl.invalidFactory();
            }
            if (!type.isAssignableFrom(implementationType)) {
                this.errorHandler.handle(StackTraceElements.forType(type), "%s doesn't extend %s.", implementationType, type);
                return InjectorImpl.invalidFactory();
            }
            return this.getInternalFactory(member, Key.get(implementationType));
        }
        ProvidedBy providedBy = type.getAnnotation(ProvidedBy.class);
        if (providedBy != null) {
            final Class<? extends Provider<?>> providerType = providedBy.value();
            if (providerType == type) {
                this.errorHandler.handle(StackTraceElements.forType(type), "@DefaultProvider points to the same class it annotates.", type);
                return InjectorImpl.invalidFactory();
            }
            InternalFactory<? extends Provider<?>> providerFactory = this.getInternalFactory(member, Key.get(providerType));
            Key<? extends Provider<?>> providerKey = Key.get(providerType);
            return new BoundProviderFactory(providerKey, providerFactory, StackTraceElements.forType(type)){

                public Object get(InternalContext context) {
                    Object o = super.get(context);
                    try {
                        return type.cast(o);
                    }
                    catch (ClassCastException e) {
                        InjectorImpl.this.errorHandler.handle(StackTraceElements.forType(type), "%s doesn't provide instances of %s.", providerType, type);
                        throw new AssertionError();
                    }
                }
            };
        }
        if (Modifier.isAbstract(type.getModifiers())) {
            return null;
        }
        Map<Class<?>, InternalFactory<?>> map = this.implicitBindings;
        synchronized (map) {
            InternalFactory<?> factory = this.implicitBindings.get(type);
            if (factory != null) {
                return factory;
            }
            ImplicitBinding<T> implicitBinding = new ImplicitBinding<T>(type);
            if (scope == null) {
                scope = Scopes.getScopeForType(type, this.scopes, this.errorHandler);
            }
            InternalFactory<T> scoped = scope != null ? Scopes.scope(Key.get(type), this, implicitBinding, scope) : implicitBinding;
            this.implicitBindings.put(type, scoped);
            try {
                ConstructorInjector<T> constructor = this.getConstructor(type);
                implicitBinding.setConstructorInjector(constructor);
            }
            catch (RuntimeException e) {
                this.implicitBindings.remove(type);
                throw e;
            }
            catch (Throwable t) {
                this.implicitBindings.remove(type);
                throw new AssertionError((Object)t);
            }
            return scoped;
        }
    }

    static <T> InternalFactory<T> invalidFactory() {
        return INVALID_FACTORY;
    }

    public String toString() {
        return new ToStringBuilder(Injector.class).add("bindings", this.bindings).toString();
    }

    static {
        HashMap primitiveToWrapper = new HashMap<Class<?>, Class<?>>(){
            {
                this.put(Integer.TYPE, Integer.class);
                this.put(Long.TYPE, Long.class);
                this.put(Boolean.TYPE, Boolean.class);
                this.put(Byte.TYPE, Byte.class);
                this.put(Short.TYPE, Short.class);
                this.put(Float.TYPE, Float.class);
                this.put(Double.TYPE, Double.class);
                this.put(Character.TYPE, Character.class);
            }
        };
        HashMap<Class, Class> counterparts = new HashMap<Class, Class>();
        for (Map.Entry entry : primitiveToWrapper.entrySet()) {
            Class key = (Class)entry.getKey();
            Class value = (Class)entry.getValue();
            counterparts.put(key, value);
            counterparts.put(value, key);
        }
        PRIMITIVE_COUNTERPARTS = Collections.unmodifiableMap(counterparts);
        PRIMITIVE_CONVERTERS = new PrimitiveConverters();
        INVALID_FACTORY = new InternalFactory<Object>(){

            @Override
            public Object get(InternalContext context) {
                throw new AssertionError();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BindingsMultimap {
        private final Map<TypeLiteral<?>, List<? extends BindingImpl<?>>> map = new HashMap();

        private BindingsMultimap() {
        }

        public <T> void put(TypeLiteral<T> type, BindingImpl<T> binding) {
            List<BindingImpl<T>> bindingsForThisType = this.getFromMap(type);
            if (bindingsForThisType == null) {
                bindingsForThisType = new ArrayList<BindingImpl<T>>();
                this.map.put(type, bindingsForThisType);
            }
            bindingsForThisType.add(binding);
        }

        public <T> List<BindingImpl<T>> getAll(TypeLiteral<T> type) {
            List<BindingImpl<T>> list = this.getFromMap(type);
            return list == null ? Collections.emptyList() : list;
        }

        private <T> List<BindingImpl<T>> getFromMap(TypeLiteral<T> type) {
            return this.map.get(type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Converter<T> {
        public T convert(Member var1, Key<T> var2, String var3) throws ConstantConversionException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ImplicitBinding<T>
    implements InternalFactory<T> {
        final Class<T> implementation;
        ConstructorInjector<T> constructorInjector;

        ImplicitBinding(Class<T> implementation) {
            this.implementation = implementation;
        }

        void setConstructorInjector(ConstructorInjector<T> constructorInjector) {
            this.constructorInjector = constructorInjector;
        }

        @Override
        public T get(InternalContext context) {
            return (T)this.constructorInjector.construct(context, context.getExpectedType());
        }
    }

    static class InvalidConstructor {
        InvalidConstructor() {
            throw new AssertionError();
        }
    }

    static interface MethodInvoker {
        public Object invoke(Object var1, Object ... var2) throws IllegalAccessException, InvocationTargetException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MissingDependencyException
    extends Exception {
        final Key<?> key;
        final Member member;

        MissingDependencyException(Key<?> key, Member member) {
            this.key = key;
            this.member = member;
        }

        void handle(ErrorHandler errorHandler) {
            ErrorMessages.handleMissingBinding(errorHandler, this.member, this.key, InjectorImpl.this.getNamesOfBindingAnnotations(this.key.getTypeLiteral()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PrimitiveConverters
    extends HashMap<Class<?>, Converter<?>> {
        PrimitiveConverters() {
            this.putParser(Integer.TYPE);
            this.putParser(Long.TYPE);
            this.putParser(Boolean.TYPE);
            this.putParser(Byte.TYPE);
            this.putParser(Short.TYPE);
            this.putParser(Float.TYPE);
            this.putParser(Double.TYPE);
            Converter<Character> characterConverter = new Converter<Character>(){

                @Override
                public Character convert(Member member, Key<Character> key, String value) throws ConstantConversionException {
                    if ((value = value.trim()).length() != 1) {
                        throw new ConstantConversionException(member, key, value, "Length != 1.");
                    }
                    return Character.valueOf(value.charAt(0));
                }
            };
            this.put(Character.TYPE, characterConverter);
            this.put(Character.class, characterConverter);
        }

        <T> void putParser(Class<T> primitive) {
            try {
                Class wrapper = (Class)PRIMITIVE_COUNTERPARTS.get(primitive);
                final Method parser = wrapper.getMethod("parse" + Strings.capitalize(primitive.getName()), String.class);
                Converter converter = new Converter<T>(){

                    @Override
                    public T convert(Member member, Key<T> key, String value) throws ConstantConversionException {
                        try {
                            return parser.invoke(null, value);
                        }
                        catch (IllegalAccessException e) {
                            throw new AssertionError((Object)e);
                        }
                        catch (InvocationTargetException e) {
                            throw new ConstantConversionException(member, key, value, e.getTargetException());
                        }
                    }
                };
                this.put(wrapper, converter);
                this.put(primitive, converter);
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    class SingleFieldInjector
    implements SingleMemberInjector {
        final Field field;
        final InternalFactory<?> factory;
        final ExternalContext<?> externalContext;

        public SingleFieldInjector(InjectorImpl injector, Field field) throws MissingDependencyException {
            this.field = field;
            field.setAccessible(true);
            Key<?> key = Key.get(field.getGenericType(), field, field.getAnnotations(), InjectorImpl.this.errorHandler);
            this.factory = injector.getInternalFactory(field, key);
            if (this.factory == null) {
                throw new MissingDependencyException(key, field);
            }
            this.externalContext = ExternalContext.newInstance(field, key, injector);
        }

        public void inject(InternalContext context, Object o) {
            ExternalContext previous = context.getExternalContext();
            context.setExternalContext(this.externalContext);
            try {
                Object value = this.factory.get(context);
                if (value == null) {
                    throw new AssertionError();
                }
                this.field.set(o, value);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            catch (ConfigurationException e) {
                throw e;
            }
            catch (Throwable throwable) {
                throw new ProvisionException(this.externalContext, throwable);
            }
            finally {
                context.setExternalContext(previous);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface SingleInjectorFactory<M extends Member & AnnotatedElement> {
        public SingleMemberInjector create(InjectorImpl var1, M var2) throws MissingDependencyException;
    }

    static interface SingleMemberInjector {
        public void inject(InternalContext var1, Object var2);
    }

    static class SingleMethodInjector
    implements SingleMemberInjector {
        final MethodInvoker methodInvoker;
        final SingleParameterInjector<?>[] parameterInjectors;

        public SingleMethodInjector(InjectorImpl injector, final Method method) throws MissingDependencyException {
            if (Modifier.isPrivate(method.getModifiers()) || Modifier.isProtected(method.getModifiers())) {
                method.setAccessible(true);
                this.methodInvoker = new MethodInvoker(){

                    public Object invoke(Object target, Object ... parameters) throws IllegalAccessException, InvocationTargetException {
                        Objects.assertNoNulls(parameters);
                        return method.invoke(target, parameters);
                    }
                };
            } else {
                FastClass fastClass = GuiceFastClass.create(method.getDeclaringClass());
                final FastMethod fastMethod = fastClass.getMethod(method);
                this.methodInvoker = new MethodInvoker(){

                    public Object invoke(Object target, Object ... parameters) throws IllegalAccessException, InvocationTargetException {
                        Objects.assertNoNulls(parameters);
                        return fastMethod.invoke(target, parameters);
                    }
                };
            }
            Type[] parameterTypes = method.getGenericParameterTypes();
            this.parameterInjectors = parameterTypes.length > 0 ? injector.getParametersInjectors(method, method.getParameterAnnotations(), parameterTypes) : null;
        }

        public void inject(InternalContext context, Object o) {
            try {
                this.methodInvoker.invoke(o, InjectorImpl.getParameters(context, this.parameterInjectors));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SingleParameterInjector<T> {
        final ExternalContext<T> externalContext;
        final InternalFactory<? extends T> factory;

        public SingleParameterInjector(ExternalContext<T> externalContext, InternalFactory<? extends T> factory) {
            this.externalContext = externalContext;
            this.factory = factory;
        }

        T inject(InternalContext context) {
            ExternalContext previous = context.getExternalContext();
            context.setExternalContext(this.externalContext);
            try {
                T t = this.factory.get(context);
                return t;
            }
            catch (ConfigurationException e) {
                throw e;
            }
            catch (Throwable throwable) {
                throw new ProvisionException(this.externalContext, throwable);
            }
            finally {
                context.setExternalContext(previous);
            }
        }
    }
}

