/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMultisetEntry;
import com.google.common.collect.Comparators;
import com.google.common.collect.EnumMultiset;
import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.ForwardingMultiset;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.common.collect.Synchronized;
import com.google.common.collect.TreeMultiset;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Multisets {
    private Multisets() {
    }

    public static <E> HashMultiset<E> newHashMultiset() {
        return new HashMultiset();
    }

    public static <E> HashMultiset<E> newHashMultiset(E ... elements) {
        HashMultiset multiset = new HashMultiset();
        Collections.addAll(multiset, elements);
        return multiset;
    }

    public static <E> HashMultiset<E> newHashMultiset(Iterable<? extends E> elements) {
        return HashMultiset.create(elements);
    }

    public static <E extends Comparable> TreeMultiset<E> newTreeMultiset() {
        return new TreeMultiset();
    }

    public static <E> TreeMultiset<E> newTreeMultiset(Comparator<? super E> c) {
        return new TreeMultiset<E>(c);
    }

    public static <E extends Enum<E>> EnumMultiset<E> newEnumMultiset(Class<E> type) {
        return new EnumMultiset<E>(type);
    }

    public static <E extends Enum<E>> EnumMultiset<E> newEnumMultiset(Iterable<E> elements) {
        return new EnumMultiset<E>(elements);
    }

    public static <E extends Enum<E>> EnumMultiset<E> newEnumMultiset(E ... elements) {
        Preconditions.checkArgument(elements.length > 0, "newEnumMultiset requires at least one element");
        EnumMultiset<E> multiset = Multisets.newEnumMultiset(((Enum)elements[0]).getDeclaringClass());
        Collections.addAll(multiset, elements);
        return multiset;
    }

    public static <E> Multiset<E> unmodifiableMultiset(Multiset<E> multiset) {
        return new UnmodifiableMultiset(multiset);
    }

    public static <E> Multiset<E> synchronizedMultiset(Multiset<E> multiset) {
        return Synchronized.multiset(multiset, null);
    }

    public static <E> Multiset.Entry<E> immutableEntry(final E e, final int n) {
        Preconditions.checkArgument(n >= 0);
        return new AbstractMultisetEntry<E>(){

            @Override
            public E getElement() {
                return e;
            }

            @Override
            public int getCount() {
                return n;
            }
        };
    }

    public static <E> Multiset<E> forSet(Set<E> set) {
        return new SetMultiset<E>(set);
    }

    static int inferDistinctElements(Iterable<?> elements) {
        if (elements instanceof Multiset) {
            return ((Multiset)elements).elementSet().size();
        }
        return 11;
    }

    public static <T> Ordering<T> frequencyOrder(Multiset<?> multiset) {
        return new FrequencyOrder(multiset);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FrequencyOrder<T>
    extends Ordering<T> {
        final Multiset<?> multiset;
        private static final long serialVersionUID = 0L;

        FrequencyOrder(Multiset<?> multiset) {
            this.multiset = Preconditions.checkNotNull(multiset);
        }

        @Override
        public int compare(T left, T right) {
            int leftCount = this.multiset.count(left);
            int rightCount = this.multiset.count(right);
            return Comparators.compare(leftCount, rightCount);
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof FrequencyOrder) {
                FrequencyOrder that = (FrequencyOrder)object;
                return this.multiset.equals(that.multiset);
            }
            return false;
        }

        public int hashCode() {
            return this.multiset.hashCode();
        }

        public String toString() {
            return "FrequencyOrder " + this.multiset;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetMultiset<E>
    extends ForwardingCollection<E>
    implements Multiset<E>,
    Serializable {
        final Set<E> delegate;
        transient Set<E> elementSet;
        transient Set<Multiset.Entry<E>> entrySet;
        private static final long serialVersionUID = 0L;

        SetMultiset(Set<E> set) {
            this.delegate = Preconditions.checkNotNull(set);
        }

        @Override
        protected Set<E> delegate() {
            return this.delegate;
        }

        @Override
        public int count(Object element) {
            return this.delegate.contains(element) ? 1 : 0;
        }

        @Override
        public boolean add(E element, int occurrences) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int remove(Object element, int occurrences) {
            if (occurrences == 0) {
                return 0;
            }
            Preconditions.checkArgument(occurrences > 0);
            return this.removeAllOccurrences(element);
        }

        @Override
        public int removeAllOccurrences(Object element) {
            return this.delegate.remove(element) ? 1 : 0;
        }

        @Override
        public Set<E> elementSet() {
            ElementSet es = this.elementSet;
            return es == null ? (this.elementSet = new ElementSet()) : es;
        }

        @Override
        public Set<Multiset.Entry<E>> entrySet() {
            EntrySet es = this.entrySet;
            return es == null ? (this.entrySet = new EntrySet()) : es;
        }

        @Override
        public boolean add(E o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Multiset)) {
                return false;
            }
            Multiset m = (Multiset)o;
            return this.size() == m.size() && this.delegate.equals(m.elementSet());
        }

        @Override
        public int hashCode() {
            int sum = 0;
            for (Object e : this) {
                sum += (e == null ? 0 : e.hashCode()) ^ 1;
            }
            return sum;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ElementSet
        extends ForwardingSet<E> {
            ElementSet() {
            }

            @Override
            protected Set<E> delegate() {
                return SetMultiset.this.delegate;
            }

            @Override
            public boolean add(E o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends E> c) {
                throw new UnsupportedOperationException();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class EntrySet
        extends AbstractSet<Multiset.Entry<E>> {
            EntrySet() {
            }

            @Override
            public int size() {
                return SetMultiset.this.delegate.size();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                return super.retainAll(Preconditions.checkNotNull(c));
            }

            @Override
            public Iterator<Multiset.Entry<E>> iterator() {
                return new Iterator<Multiset.Entry<E>>(){
                    final Iterator<E> elements;
                    {
                        this.elements = ((EntrySet)EntrySet.this).SetMultiset.this.delegate.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.elements.hasNext();
                    }

                    @Override
                    public Multiset.Entry<E> next() {
                        return Multisets.immutableEntry(this.elements.next(), 1);
                    }

                    @Override
                    public void remove() {
                        this.elements.remove();
                    }
                };
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnmodifiableMultiset<E>
    extends ForwardingMultiset<E>
    implements Serializable {
        final Multiset<E> delegate;
        transient Set<E> elementSet;
        transient Set<Multiset.Entry<E>> entrySet;
        private static final long serialVersionUID = 0L;

        private UnmodifiableMultiset(Multiset<E> delegate) {
            this.delegate = delegate;
        }

        @Override
        protected Multiset<E> delegate() {
            return this.delegate;
        }

        @Override
        public Set<E> elementSet() {
            Set<E> es = this.elementSet;
            return es == null ? (this.elementSet = Collections.unmodifiableSet(this.delegate.elementSet())) : es;
        }

        @Override
        public Set<Multiset.Entry<E>> entrySet() {
            Set<Multiset.Entry<Multiset.Entry<E>>> es = this.entrySet;
            return es == null ? (this.entrySet = Collections.unmodifiableSet(this.delegate.entrySet())) : es;
        }

        @Override
        public Iterator<E> iterator() {
            return Iterators.unmodifiableIterator(this.delegate.iterator());
        }

        @Override
        public boolean add(E element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(E element, int occurences) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> elementsToAdd) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int remove(Object element, int occurrences) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int removeAllOccurrences(Object element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> elementsToRemove) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> elementsToRetain) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

