/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.edit.actions;

import org.eclipse.emf.henshin.diagram.edit.actions.Action;
import org.eclipse.emf.henshin.diagram.edit.actions.ActionType;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.util.HenshinNACUtil;

public class ActionNACUtil {
    public static final String DEFAULT_NAC_NAME = "default";

    public static NestedCondition getOrCreateNAC(Action action, Rule rule) {
        NestedCondition nac;
        if (action == null || action.getType() != ActionType.FORBID) {
            throw new IllegalArgumentException("NACs can be created only for FORBID actions");
        }
        String name = DEFAULT_NAC_NAME;
        String[] args = action.getArguments();
        if (args != null && args.length > 0 && args[0] != null) {
            name = args[0];
        }
        if ((nac = HenshinNACUtil.getNAC((Rule)rule, (String)name)) == null) {
            nac = HenshinNACUtil.createNAC((Rule)rule, (String)name);
        }
        return nac;
    }
}

