/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.commands;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.henshin.model.AmalgamationUnit;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.TransformationSystem;
import org.eclipse.emf.henshin.model.TransformationUnit;
import org.eclipse.emf.henshin.model.util.HenshinRuleAnalysisUtil;

public class GraphComplexUnsetCommand
extends CompoundCommand {
    private final EditingDomain domain;
    EObject owner;
    EStructuralFeature feature;

    public GraphComplexUnsetCommand(EditingDomain domain, EObject owner, EStructuralFeature feature) {
        this.domain = domain;
        this.owner = owner;
        this.feature = feature;
    }

    protected boolean prepare() {
        this.isPrepared = true;
        this.isExecutable = true;
        return true;
    }

    public void execute() {
        this.processMappings();
        this.appendAndExecute((Command)new SetCommand(this.domain, this.owner, this.feature, SetCommand.UNSET_VALUE));
    }

    private void processMappings() {
        HashSet<Mapping> mappingSet = new HashSet<Mapping>();
        Graph graph = (Graph)this.owner.eGet(this.feature);
        if (graph == null) {
            return;
        }
        EList nodes = graph.getNodes();
        if (this.owner instanceof Rule) {
            Rule rule = (Rule)this.owner;
            this.filterMappings((List<Mapping>)rule.getMappings(), mappingSet, (List<Node>)nodes);
            if (rule.eContainer() != null) {
                TransformationSystem trafoSys = (TransformationSystem)rule.eContainer();
                for (TransformationUnit unit : trafoSys.getTransformationUnits()) {
                    AmalgamationUnit au;
                    if (!(unit instanceof AmalgamationUnit) || (au = (AmalgamationUnit)unit).getKernelRule() != rule && !au.getMultiRules().contains((Object)rule)) continue;
                    if (HenshinRuleAnalysisUtil.isLHS((Graph)graph)) {
                        this.filterMappings((List<Mapping>)au.getLhsMappings(), mappingSet, (List<Node>)nodes);
                        continue;
                    }
                    this.filterMappings((List<Mapping>)au.getRhsMappings(), mappingSet, (List<Node>)nodes);
                }
            }
        } else if (this.owner instanceof NestedCondition) {
            NestedCondition nc = (NestedCondition)this.owner;
            this.filterMappings((List<Mapping>)nc.getMappings(), mappingSet, (List<Node>)nodes);
        }
        if (!mappingSet.isEmpty()) {
            this.appendAndExecute((Command)new DeleteCommand(this.domain, mappingSet));
        }
    }

    private void filterMappings(List<Mapping> unfilteredList, Set<Mapping> targetSet, List<Node> nodes) {
        block0: for (Mapping mapping : unfilteredList) {
            for (Node node : nodes) {
                if (mapping.getImage() != node && mapping.getOrigin() != node) continue;
                targetSet.add(mapping);
                continue block0;
            }
        }
    }
}

