/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.TransformationUnit;
import org.eclipse.emf.henshin.provider.DelegatingWrapperTrafoUnitItemProvider;
import org.eclipse.emf.henshin.provider.DescribedElementItemProvider;
import org.eclipse.emf.henshin.provider.trans.TrafoUnitParameterItemProvider;
import org.eclipse.emf.henshin.provider.trans.TrafoUnitParameterMappingItemProvider;

public class TransformationUnitItemProvider
extends DescribedElementItemProvider
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public static final int MAX_UNFOLD_PARAMETERS = 5;
    public static final int MAX_UNFOLD_PARAMETERMAPPINGS = 5;

    public TransformationUnitItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addNamePropertyDescriptor(object);
            this.addActivatedPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addNamePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(0, this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_NamedElement_name_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_NamedElement_name_feature", "_UI_NamedElement_type"), (EStructuralFeature)HenshinPackage.Literals.NAMED_ELEMENT__NAME, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addActivatedPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TransformationUnit_activated_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TransformationUnit_activated_feature", "_UI_TransformationUnit_type"), (EStructuralFeature)HenshinPackage.Literals.TRANSFORMATION_UNIT__ACTIVATED, true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(HenshinPackage.Literals.TRANSFORMATION_UNIT__PARAMETERS);
            this.childrenFeatures.add(HenshinPackage.Literals.TRANSFORMATION_UNIT__PARAMETER_MAPPINGS);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Collection<?> getChildren(Object object) {
        TransformationUnit tu = (TransformationUnit)object;
        List childrenList = (List)super.getChildren(object);
        if (tu.getParameterMappings().size() > 5) {
            childrenList.removeAll((Collection<?>)tu.getParameterMappings());
            int offset = 0;
            while (offset < childrenList.size()) {
                Object currentItem = childrenList.get(offset);
                if (!(currentItem instanceof Parameter)) break;
                ++offset;
            }
            childrenList.add(offset, new TrafoUnitParameterMappingItemProvider(this.adapterFactory, (EObject)tu));
        }
        if (tu.getParameters().size() > 5) {
            childrenList.removeAll((Collection<?>)tu.getParameters());
            childrenList.add(0, new TrafoUnitParameterItemProvider(this.adapterFactory, (EObject)tu));
        }
        return childrenList;
    }

    @Override
    public String getText(Object object) {
        String label = ((TransformationUnit)object).getName();
        return label == null || label.length() == 0 ? this.getString("_UI_TransformationUnit_type") : String.valueOf(this.getString("_UI_TransformationUnit_type")) + " " + label;
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(TransformationUnit.class)) {
            case 1: 
            case 2: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 3: 
            case 4: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected boolean isWrappingNeeded(Object object) {
        if (object instanceof TransformationUnit && !(object instanceof Rule)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected Object createWrapper(EObject object, EStructuralFeature feature, Object value, int index) {
        if (!this.isWrappingNeeded(object)) {
            return value;
        }
        value = !((EReference)feature).isContainment() ? new DelegatingWrapperTrafoUnitItemProvider(value, object, feature, index, this.adapterFactory) : super.createWrapper(object, feature, value, index);
        return value;
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(HenshinPackage.Literals.TRANSFORMATION_UNIT__PARAMETERS, HenshinFactory.eINSTANCE.createParameter()));
        newChildDescriptors.add(this.createChildParameter(HenshinPackage.Literals.TRANSFORMATION_UNIT__PARAMETER_MAPPINGS, HenshinFactory.eINSTANCE.createParameterMapping()));
    }
}

