/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.explorer.actions;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class EditPropertiesPage
extends WizardPage {
    private List<String> keys;
    private List<String> values;
    private boolean dirty;
    private Table table;

    protected EditPropertiesPage(EMap<String, String> properties) {
        super("Edit State Space Properties");
        this.setDescription("Edit the properties of this state space.");
        this.dirty = false;
        this.keys = new ArrayList<String>(properties.keySet());
        Collections.sort(this.keys);
        this.values = new ArrayList<String>();
        for (String key : this.keys) {
            this.values.add((String)properties.get((Object)key));
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        this.table = this.createTable(container);
        this.table.setLayoutData((Object)new GridData(1808));
        Composite buttons = new Composite(container, 0);
        buttons.setLayoutData((Object)new GridData(1));
        buttons.setLayout((Layout)new GridLayout(1, false));
        this.createButton(buttons, "Add");
        this.createButton(buttons, "Remove");
        this.setControl((Control)container);
    }

    private Table createTable(Composite parent) {
        final Table table = new Table(parent, 2050);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn keyColumn = new TableColumn(table, 0);
        keyColumn.setText("Key");
        keyColumn.setWidth(100);
        TableColumn valueColumn = new TableColumn(table, 0);
        valueColumn.setText("Value");
        valueColumn.setWidth(200);
        int i = 0;
        while (i < this.keys.size()) {
            TableItem item = new TableItem(table, 0);
            item.setText(new String[]{this.keys.get(i), this.values.get(i)});
            ++i;
        }
        final TableEditor editor = new TableEditor(table);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        table.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Rectangle clientArea = table.getClientArea();
                Point pt = new Point(event.x, event.y);
                int index = table.getTopIndex();
                while (index < table.getItemCount()) {
                    boolean visible = false;
                    final int row = index;
                    TableItem item = table.getItem(index);
                    int i = 0;
                    while (i < table.getColumnCount()) {
                        Rectangle rect = item.getBounds(i);
                        if (rect.contains(pt)) {
                            final int column = i;
                            final Text text = new Text((Composite)table, 2048);
                            Listener textListener = new Listener(){

                                public void handleEvent(Event e) {
                                    switch (e.type) {
                                        case 16: {
                                            EditPropertiesPage.this.setCellText(column, row, text.getText());
                                            text.dispose();
                                            break;
                                        }
                                        case 31: {
                                            switch (e.detail) {
                                                case 4: {
                                                    EditPropertiesPage.this.setCellText(column, row, text.getText());
                                                }
                                                case 2: {
                                                    text.dispose();
                                                    e.doit = false;
                                                }
                                            }
                                        }
                                    }
                                }
                            };
                            text.addListener(31, textListener);
                            text.addListener(16, textListener);
                            editor.setEditor((Control)text, item, i);
                            text.setText(item.getText(i));
                            text.selectAll();
                            text.setFocus();
                            return;
                        }
                        if (!visible && rect.intersects(clientArea)) {
                            visible = true;
                        }
                        ++i;
                    }
                    if (!visible) {
                        return;
                    }
                    ++index;
                }
            }
        });
        return table;
    }

    private void setCellText(int column, int row, String text) {
        TableItem item = this.table.getItem(row);
        item.setText(column, text);
        if (column == 0) {
            this.keys.set(row, text);
        } else {
            this.values.set(row, text);
        }
        this.dirty = true;
    }

    public void add() {
        this.keys.add("key" + this.keys.size());
        this.values.add("value" + this.values.size());
        TableItem item = new TableItem(this.table, 0);
        item.setText(new String[]{this.keys.get(this.keys.size() - 1), this.values.get(this.values.size() - 1)});
        this.dirty = true;
    }

    public void remove() {
        int[] indices = this.table.getSelectionIndices();
        if (indices == null) {
            return;
        }
        this.table.remove(indices);
        ArrayList<String> keysToRemove = new ArrayList<String>();
        ArrayList<String> valuesToRemove = new ArrayList<String>();
        int i = 0;
        while (i < indices.length) {
            keysToRemove.add(this.keys.get(indices[i]));
            valuesToRemove.add(this.values.get(indices[i]));
            ++i;
        }
        this.keys.removeAll(keysToRemove);
        this.values.removeAll(valuesToRemove);
        this.dirty = true;
    }

    public Map<String, String> getResult() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        int i = 0;
        while (i < this.keys.size()) {
            result.put(this.keys.get(i), this.values.get(i));
            ++i;
        }
        return result;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private Button createButton(Composite parent, final String name) {
        Button button = new Button(parent, 8);
        button.setText(name);
        button.setLayoutData((Object)new GridData(768));
        final EditPropertiesPage thisPage = this;
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                try {
                    Method method = EditPropertiesPage.class.getMethod(name.toLowerCase(), new Class[0]);
                    if (method != null) {
                        method.invoke((Object)thisPage, new Object[0]);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        });
        return button;
    }
}

