/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.explorer.jobs;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceManager;
import org.eclipse.emf.henshin.statespace.explorer.StateSpaceExplorerPlugin;
import org.eclipse.emf.henshin.statespace.explorer.commands.ExploreStatesCommand;
import org.eclipse.emf.henshin.statespace.explorer.jobs.AbstractStateSpaceJob;
import org.eclipse.emf.henshin.statespace.impl.MultiThreadedStateSpaceManager;
import org.eclipse.emf.henshin.statespace.impl.StateSpaceManagerImpl;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.commands.Command;

public class ExploreStateSpaceJob
extends AbstractStateSpaceJob {
    public static final int DEFAULT_NUM_STATES_AT_ONCE = 40;
    protected EditDomain editDomain;
    private int numStatesAtOnce = 40;
    private int cleanupInterval = 600;
    private int saveInterval = 1800;
    protected boolean logInfo = true;

    public ExploreStateSpaceJob(StateSpaceManager manager, EditDomain editDomain) {
        super("Exploring state space...", manager);
        this.editDomain = editDomain;
        this.setUser(true);
        this.setPriority(30);
    }

    protected IStatus run(IProgressMonitor monitor) {
        long start;
        monitor.beginTask("Exploring state space...", -1);
        StateSpaceManagerImpl manager = (StateSpaceManagerImpl)this.getStateSpaceManager();
        StateSpace stateSpace = manager.getStateSpace();
        DecimalFormat large = new DecimalFormat("#,###,###,##0");
        DecimalFormat speed = new DecimalFormat("###,##0.0");
        long lastSave = start = System.currentTimeMillis();
        long lastCleanup = start;
        int explored = 0;
        try {
            block2: while (!stateSpace.getOpenStates().isEmpty() && !monitor.isCanceled()) {
                ArrayList<State> open = new ArrayList<State>((Collection<State>)stateSpace.getOpenStates());
                int index = 0;
                while (index < open.size()) {
                    ExploreStatesCommand command = this.createExploreCommand(open, index, this.numStatesAtOnce);
                    this.executeExploreCommand(command, monitor);
                    int states = stateSpace.getStates().size();
                    long time = System.currentTimeMillis();
                    monitor.subTask(String.valueOf(large.format(states)) + " states (" + large.format(stateSpace.getOpenStates().size()) + " open), " + large.format(stateSpace.getTransitionCount()) + " transitions. Exploring " + speed.format((double)(1000 * (explored += command.getStatesToExplore().size())) / (double)(time - start)) + " states/second...");
                    if (monitor.isCanceled()) continue block2;
                    long current = System.currentTimeMillis();
                    if (this.cleanupInterval >= 0 && current > lastCleanup + (long)(this.cleanupInterval * 1000)) {
                        this.clearCache(monitor);
                        lastCleanup = System.currentTimeMillis();
                    }
                    if (this.saveInterval >= 0 && current > lastSave + (long)(this.saveInterval * 1000)) {
                        monitor.subTask("Saving state space...");
                        this.saveStateSpace();
                        lastSave = System.currentTimeMillis();
                    }
                    if (monitor.isCanceled()) continue block2;
                    index += this.numStatesAtOnce;
                }
            }
        }
        catch (Throwable e) {
            return new Status(4, "org.eclipse.emf.henshin.statespace.explorer", 0, "Error exploring state space", e);
        }
        long end = System.currentTimeMillis();
        this.clearCache(monitor);
        if (this.saveInterval >= 0) {
            monitor.subTask("Saving state space...");
            this.saveStateSpace();
        }
        if (this.logInfo) {
            boolean multiThreaded = manager instanceof MultiThreadedStateSpaceManager;
            StateSpaceExplorerPlugin.getInstance().logInfo("Explored " + explored + " states in " + (end - start) / 1000L + " seconds (" + speed.format((double)(1000 * explored) / (double)(end - start)) + " states/second) in " + (multiThreaded ? "multi" : "single") + "-threaded mode.");
        }
        return new Status(0, "org.eclipse.emf.henshin.statespace.explorer", 0, null, null);
    }

    private void clearCache(IProgressMonitor monitor) {
        if (this.getStateSpaceManager() instanceof StateSpaceManagerImpl) {
            monitor.subTask("Clearing state model cache...");
            ((StateSpaceManagerImpl)this.getStateSpaceManager()).clearStateModelCache();
        }
    }

    protected void executeExploreCommand(Command command, IProgressMonitor monitor) {
        this.editDomain.getCommandStack().execute(command);
    }

    protected ExploreStatesCommand createExploreCommand(List<State> states, int start, int count) {
        int end = Math.min(start + count, states.size());
        ExploreStatesCommand command = new ExploreStatesCommand(this.getStateSpaceManager(), states.subList(start, end));
        command.setGenerateLocations(false);
        return command;
    }

    public void setNumStatesAtOnce(int num) {
        this.numStatesAtOnce = num;
    }

    public void setSaveInterval(int seconds) {
        this.saveInterval = seconds;
    }

    public void setCleanupInterval(int seconds) {
        this.cleanupInterval = seconds;
    }
}

