/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.explorer.jobs;

import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.henshin.statespace.StateSpaceManager;
import org.eclipse.emf.henshin.statespace.explorer.commands.IrreversibleCommand;
import org.eclipse.emf.henshin.statespace.explorer.jobs.ExploreStateSpaceJobWithDisplay;
import org.eclipse.emf.henshin.statespace.explorer.jobs.LayoutStateSpaceJob;
import org.eclipse.emf.henshin.statespace.explorer.jobs.ReloadStateSpaceJob;
import org.eclipse.emf.henshin.statespace.explorer.jobs.ValidateStateSpaceJob;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.commands.Command;

public class StateSpaceJobManager {
    private ReloadStateSpaceJob reloadJob;
    private LayoutStateSpaceJob layoutJob;
    private ExploreStateSpaceJobWithDisplay exploreJob;
    private ValidateStateSpaceJob validateJob;
    private StateSpaceManager stateSpaceManager;
    private EditDomain editDomain;

    public StateSpaceJobManager(StateSpaceManager stateSpaceManager, EditDomain editDomain) {
        this.stateSpaceManager = stateSpaceManager;
        this.editDomain = editDomain;
        this.reloadJob = new ReloadStateSpaceJob(stateSpaceManager);
        this.layoutJob = new LayoutStateSpaceJob(stateSpaceManager.getStateSpace());
        this.exploreJob = new ExploreStateSpaceJobWithDisplay(stateSpaceManager, editDomain);
        this.validateJob = new ValidateStateSpaceJob(stateSpaceManager);
    }

    public LayoutStateSpaceJob startLayoutJob() {
        if (this.isTerminated(this.layoutJob)) {
            this.editDomain.getCommandStack().execute((Command)new IrreversibleCommand("start layouter"));
            this.layoutJob.schedule();
        }
        return this.layoutJob;
    }

    public ReloadStateSpaceJob startReloadJob() {
        if (this.isTerminated(this.reloadJob)) {
            this.reloadJob.schedule();
        }
        return this.reloadJob;
    }

    public ExploreStateSpaceJobWithDisplay startExploreJob() {
        if (this.isTerminated(this.exploreJob)) {
            this.exploreJob.schedule();
        }
        return this.exploreJob;
    }

    public ValidateStateSpaceJob startValidateJob() {
        if (this.isTerminated(this.validateJob)) {
            this.validateJob.schedule();
        }
        return this.validateJob;
    }

    public void stopLayoutJob() {
        this.stop(this.layoutJob);
    }

    public void stopReloadJob() {
        this.stop(this.reloadJob);
    }

    public void stopExploreJob() {
        this.stop(this.exploreJob);
    }

    public void stopValidateJob() {
        this.stop(this.validateJob);
    }

    private void stop(Job job) {
        int waited = 0;
        while (!this.isTerminated(job) && waited < 1000) {
            try {
                job.cancel();
                waited += 100;
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private boolean isTerminated(Job job) {
        return job.getState() == 0;
    }

    public void stopAllJobs() {
        this.stopLayoutJob();
        this.stopExploreJob();
        this.stopReloadJob();
        this.stopValidateJob();
    }

    public LayoutStateSpaceJob getLayoutJob() {
        return this.layoutJob;
    }

    public ReloadStateSpaceJob getReloadJob() {
        return this.reloadJob;
    }

    public ExploreStateSpaceJobWithDisplay getExploreJob() {
        return this.exploreJob;
    }

    public ValidateStateSpaceJob getValidateJob() {
        return this.validateJob;
    }

    public StateSpaceManager getStateSpaceManager() {
        return this.stateSpaceManager;
    }
}

