/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.explorer.parts;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceFactory;
import org.eclipse.emf.henshin.statespace.StateSpaceManager;
import org.eclipse.emf.henshin.statespace.Trace;
import org.eclipse.emf.henshin.statespace.Transition;
import org.eclipse.emf.henshin.statespace.explorer.StateSpaceExplorerPlugin;
import org.eclipse.emf.henshin.statespace.explorer.edit.StateSpaceEditPartFactory;
import org.eclipse.emf.henshin.statespace.explorer.jobs.StateSpaceJobManager;
import org.eclipse.emf.henshin.statespace.explorer.parts.StateSpaceContextMenuProvider;
import org.eclipse.emf.henshin.statespace.explorer.parts.StateSpaceToolsMenu;
import org.eclipse.emf.henshin.statespace.impl.StateSpaceManagerImpl;
import org.eclipse.emf.henshin.statespace.resource.StateSpaceResource;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;

public class StateSpaceExplorer
extends GraphicalEditor {
    private StateSpaceManager stateSpaceManager;
    private StateSpaceJobManager jobManager;
    private StateSpaceToolsMenu toolsMenu;
    private boolean displayContent;
    private boolean dirty;
    private Adapter dirtyUpdater = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            StateSpaceExplorer.this.dirty = true;
            StateSpaceExplorer.this.firePropertyChange(257);
        }
    };

    public StateSpaceExplorer() {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm(parent, 256);
        sashForm.SASH_WIDTH = 2;
        sashForm.setBackground(parent.getDisplay().getSystemColor(16));
        this.createGraphicalViewer((Composite)sashForm);
        ScrollingGraphicalViewer viewer = (ScrollingGraphicalViewer)this.getGraphicalViewer();
        ScalableFreeformRootEditPart root = (ScalableFreeformRootEditPart)viewer.getRootEditPart();
        FigureCanvas canvas = (FigureCanvas)viewer.getControl();
        this.toolsMenu = new StateSpaceToolsMenu((Composite)sashForm, (EditDomain)this.getEditDomain());
        this.toolsMenu.setZoomManager(root.getZoomManager());
        this.toolsMenu.setCanvas(canvas);
        if (this.jobManager != null) {
            this.toolsMenu.setJobManager(this.jobManager);
        }
        this.toolsMenu.setExplorer(this);
        sashForm.setWeights(new int[]{5, 2});
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setEditPartFactory((EditPartFactory)new StateSpaceEditPartFactory());
        viewer.setRootEditPart((RootEditPart)new ScalableFreeformRootEditPart());
        viewer.setKeyHandler((KeyHandler)new GraphicalViewerKeyHandler(viewer));
        StateSpaceContextMenuProvider provider = new StateSpaceContextMenuProvider((EditPartViewer)viewer, this.getActionRegistry());
        viewer.setContextMenu((MenuManager)provider);
        this.getSite().registerContextMenu((MenuManager)provider, (ISelectionProvider)viewer);
    }

    protected void initializeGraphicalViewer() {
        this.updateGraphicalViewer(true);
    }

    private void updateGraphicalViewer(boolean force) {
        boolean newDisplayContent;
        boolean bl = newDisplayContent = this.stateSpaceManager.getStateSpace().getStates().size() < 1000;
        if (newDisplayContent != this.displayContent || force) {
            this.displayContent = newDisplayContent;
            GraphicalViewer viewer = this.getGraphicalViewer();
            ((StateSpaceEditPartFactory)viewer.getEditPartFactory()).setStateSpaceManager(this.stateSpaceManager);
            if (this.displayContent) {
                this.getGraphicalViewer().setContents((Object)this.stateSpaceManager.getStateSpace());
                viewer.getControl().setBackground(ColorConstants.white);
                this.jobManager.getExploreJob().setDelay(750);
            } else {
                viewer.setContents((Object)StateSpaceFactory.eINSTANCE.createStateSpace());
                viewer.getControl().setBackground(Display.getDefault().getSystemColor(22));
                this.jobManager.getExploreJob().setDelay(0);
            }
        }
    }

    public void commandStackChanged(EventObject event) {
        this.firePropertyChange(257);
        this.updateGraphicalViewer(false);
        super.commandStackChanged(event);
    }

    public boolean isDirty() {
        return this.dirty || super.isDirty();
    }

    public void doSave(IProgressMonitor monitor) {
        this.jobManager.stopAllJobs();
        try {
            Resource resource = this.stateSpaceManager.getStateSpace().eResource();
            resource.save(null);
            this.dirty = false;
            this.getCommandStack().markSaveLocation();
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)"Error saving file. See the error log for more info.");
            StateSpaceExplorerPlugin.getInstance().logError("Error saving file", e);
        }
    }

    public void doSaveAs() {
        this.jobManager.stopAllJobs();
        Shell shell = this.getSite().getWorkbenchWindow().getShell();
        SaveAsDialog dialog = new SaveAsDialog(shell);
        dialog.setOriginalFile(((IFileEditorInput)this.getEditorInput()).getFile());
        dialog.open();
        IPath path = dialog.getResult();
        if (path != null) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            URI uri = URI.createPlatformResourceURI((String)path.toString(), (boolean)false);
            try {
                StateSpaceResource resource = (StateSpaceResource)this.stateSpaceManager.getStateSpace().eResource();
                resource.setURI(uri);
                resource.save(null);
                this.setInput((IEditorInput)new FileEditorInput(file));
                this.dirty = false;
                this.getCommandStack().markSaveLocation();
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)"Error saving file. See the error log for more info.");
                StateSpaceExplorerPlugin.getInstance().logError("Error saving file", e);
            }
        }
    }

    public StateSpaceManager getStateSpaceManager() {
        return this.stateSpaceManager;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        IFile file = ((IFileEditorInput)input).getFile();
        this.setPartName(file.getName());
        this.dirty = false;
        try {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)false);
            StateSpaceResource resource = (StateSpaceResource)resourceSet.getResource(uri, true);
            StateSpace stateSpace = resource.getStateSpace();
            this.stateSpaceManager = new StateSpaceManagerImpl(stateSpace);
            this.jobManager = new StateSpaceJobManager(this.stateSpaceManager, (EditDomain)this.getEditDomain());
            if (this.toolsMenu != null) {
                this.toolsMenu.setJobManager(this.jobManager);
            }
            stateSpace.eAdapters().add((Object)this.dirtyUpdater);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void dispose() {
        this.jobManager.stopAllJobs();
        this.toolsMenu.dispose();
        super.dispose();
    }

    public void executeCommand(Command command) {
        this.getCommandStack().execute(command);
    }

    public GraphicalViewer getGraphicalViewer() {
        return super.getGraphicalViewer();
    }

    public void selectTrace(Trace trace) {
        Map registry = this.getGraphicalViewer().getEditPartRegistry();
        ArrayList<EditPart> editparts = new ArrayList<EditPart>();
        if (registry.containsKey(trace.getSource())) {
            editparts.add((EditPart)registry.get(trace.getSource()));
            for (Transition transition : trace) {
                editparts.add((EditPart)registry.get(transition));
                editparts.add((EditPart)registry.get(transition.getTarget()));
            }
        }
        this.getGraphicalViewer().setSelection((ISelection)new StructuredSelection(editparts));
    }

    public StateSpaceJobManager getJobManager() {
        return this.jobManager;
    }
}

