/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.presentation;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.henshin.editor.menuContributors.CopySubgraphMenuContributor;
import org.eclipse.emf.henshin.editor.menuContributors.CreateEdgeCommandMenuContributor;
import org.eclipse.emf.henshin.editor.menuContributors.CreateMappingCommandMenuContributor;
import org.eclipse.emf.henshin.editor.menuContributors.CreateNestedConditionMenuContributor;
import org.eclipse.emf.henshin.editor.menuContributors.FormulaCommandMenuContributor;
import org.eclipse.emf.henshin.editor.menuContributors.RemoveMappedNodesMenuContributor;
import org.eclipse.emf.henshin.editor.menuContributors.SimpleCommandMenuContributor;
import org.eclipse.emf.henshin.presentation.HenshinActionBarContributor;
import org.eclipse.emf.henshin.presentation.HenshinEditorPlugin;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorPart;

public class CustomizedHenshinActionBarContributor
extends HenshinActionBarContributor
implements CommandStackListener {
    protected Collection<IMenuManager> managedMenus = new HashSet<IMenuManager>();
    protected EditingDomain domain;
    protected List<?> currentSelection;

    @Override
    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        if (part != null) {
            this.domain = ((IEditingDomainProvider)part).getEditingDomain();
            this.domain.getCommandStack().addCommandStackListener((CommandStackListener)this);
        } else {
            if (this.domain != null) {
                this.domain.getCommandStack().removeCommandStackListener((CommandStackListener)this);
            }
            this.domain = null;
        }
    }

    public void commandStackChanged(EventObject event) {
        this.clearMenuManagers();
    }

    @Override
    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        if (event.getSelection() instanceof IStructuredSelection) {
            this.currentSelection = ((IStructuredSelection)event.getSelection()).toList();
        }
        this.refreshMenuManagers();
    }

    protected void clearMenuManagers() {
        for (IMenuManager mm : this.managedMenus) {
            mm.removeAll();
        }
    }

    protected void refreshMenuManagers() {
        for (IMenuManager mm : this.managedMenus) {
            mm.removeAll();
            this.buildContributions(mm);
        }
    }

    @Override
    public void menuAboutToShow(IMenuManager menuManager) {
        super.menuAboutToShow(menuManager);
        MenuManager submenuManager = new MenuManager(HenshinEditorPlugin.INSTANCE.getString("_UI_CreateAdvanced_menu_item"));
        this.buildContributions((IMenuManager)submenuManager);
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
    }

    @Override
    public void contributeToMenu(IMenuManager menuManager) {
        super.contributeToMenu(menuManager);
        IMenuManager subMenuManager = (IMenuManager)menuManager.find("org.eclipse.emf.henshin.modelMenuID");
        MenuManager mm = new MenuManager(HenshinEditorPlugin.INSTANCE.getString("_UI_CreateAdvanced_menu_item"));
        subMenuManager.setVisible(false);
        subMenuManager.insertBefore("additions", (IContributionItem)mm);
        this.managedMenus.add((IMenuManager)mm);
    }

    protected void buildContributions(IMenuManager menuManager) {
        SimpleCommandMenuContributor.INSTANCE.buildContributions(menuManager, this.currentSelection, this.domain);
        CreateEdgeCommandMenuContributor.INSTANCE.buildContributions(menuManager, this.currentSelection, this.domain);
        RemoveMappedNodesMenuContributor.INSTANCE.buildContributions(menuManager, this.currentSelection, this.domain);
        CreateMappingCommandMenuContributor.INSTANCE.buildContributions(menuManager, this.currentSelection, this.domain);
        FormulaCommandMenuContributor.INSTANCE.buildContributions(menuManager, this.currentSelection, this.domain);
        CreateNestedConditionMenuContributor.INSTANCE.buildContributions(menuManager, this.currentSelection, this.domain);
        CopySubgraphMenuContributor.INSTANCE.buildContributions(menuManager, this.currentSelection, this.domain);
        menuManager.update(true);
    }
}

