/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.statespace.Model;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceException;
import org.eclipse.emf.henshin.statespace.StateSpaceFactory;
import org.eclipse.emf.henshin.statespace.StateSpaceManager;
import org.eclipse.emf.henshin.statespace.StateSpacePackage;
import org.eclipse.emf.henshin.statespace.Transition;
import org.eclipse.emf.henshin.statespace.impl.StateSpaceIndexImpl;
import org.eclipse.emf.henshin.statespace.impl.StorageImpl;
import org.eclipse.emf.henshin.statespace.util.StateSpaceSearch;

public abstract class AbstractStateSpaceManager
extends StateSpaceIndexImpl
implements StateSpaceManager {
    private static final EAttribute METADATA_FEATURE = StateSpacePackage.eINSTANCE.getStorage_Data();
    private boolean tainted = false;
    private boolean change = false;
    private Adapter adapter = new AdapterImpl(){

        public void notifyChanged(Notification event) {
            if (!AbstractStateSpaceManager.this.change && event.getFeature() == METADATA_FEATURE) {
                AbstractStateSpaceManager.this.tainted = true;
            }
        }
    };
    private final Object stateSpaceLock = new Object();

    public AbstractStateSpaceManager(StateSpace stateSpace) {
        super(stateSpace);
        stateSpace.eAdapters().add((Object)this.adapter);
    }

    public final void reload(IProgressMonitor monitor) throws StateSpaceException {
        monitor.beginTask("Reload models", this.getStateSpace().getStates().size());
        boolean ignoreNodeIDs = this.getStateSpace().getEqualityHelper().isIgnoreNodeIDs();
        try {
            try {
                this.resetIndex();
                for (State state : this.getStateSpace().getStates()) {
                    if (state.isInitial()) continue;
                    state.setModel(null);
                }
                monitor.worked(1);
                for (State state : this.getStateSpace().getStates()) {
                    Model model = this.getModel(state);
                    int[] nodeIDs = StorageImpl.EMPTY_DATA;
                    if (!ignoreNodeIDs) {
                        model.updateNodeIDs();
                        nodeIDs = model.getNodeIDs();
                    }
                    state.setNodeIDs(nodeIDs);
                    state.setNodeCount(nodeIDs.length);
                    int hash = this.hashCode(model);
                    if (this.getState(model, hash) != null) {
                        this.markTainted();
                        throw new StateSpaceException("Duplicate state: " + state.getIndex());
                    }
                    state.setHashCode(hash);
                    this.setOpen(state, this.isOpen(state));
                    this.addToIndex(state);
                    monitor.worked(1);
                }
            }
            catch (Throwable t) {
                this.markTainted();
                throw new StateSpaceException(t);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected boolean isOpen(State state) throws StateSpaceException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setOpen(State state, boolean open) {
        Object object = this.stateSpaceLock;
        synchronized (object) {
            this.change = true;
            state.setOpen(open);
            if (open) {
                if (!this.getStateSpace().getOpenStates().contains((Object)state)) {
                    this.getStateSpace().getOpenStates().add((Object)state);
                }
            } else {
                this.getStateSpace().getOpenStates().remove((Object)state);
            }
            this.change = false;
        }
    }

    protected State createOpenState(Model model, int hash) {
        return this.createOpenState(model, hash, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected State createOpenState(Model model, int hash, int[] location) {
        State state = StateSpaceFactory.eINSTANCE.createState();
        state.setIndex(this.getStateSpace().getStates().size());
        state.setHashCode(hash);
        state.setModel(model);
        state.setOpen(true);
        if (location != null) {
            state.setLocation(location);
        }
        if (!this.getStateSpace().getEqualityHelper().isIgnoreNodeIDs()) {
            int[] nodeIDs = model.getNodeIDs();
            state.setNodeIDs(nodeIDs);
            state.setNodeCount(nodeIDs.length);
        }
        Object object = this.stateSpaceLock;
        synchronized (object) {
            this.change = true;
            this.getStateSpace().getStates().add((Object)state);
            this.getStateSpace().getOpenStates().add((Object)state);
            this.change = false;
        }
        this.addToIndex(state);
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final State createInitialState(Model model) throws StateSpaceException {
        Resource resource = model.getResource();
        if (resource == null || resource.getURI() == null) {
            throw new IllegalArgumentException("Model is not persisted");
        }
        EcoreUtil.resolveAll((EObject)model);
        int hash = this.hashCode(model);
        State state = this.getState(model, hash);
        if (state != null) {
            return state;
        }
        State initial = this.createOpenState(model, hash);
        Object object = this.stateSpaceLock;
        synchronized (object) {
            this.change = true;
            this.getStateSpace().getInitialStates().add((Object)initial);
            this.change = false;
        }
        return initial;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<State> removeState(State state) throws StateSpaceException {
        if (this.tainted) {
            throw new StateSpaceException();
        }
        ArrayList<State> removed = new ArrayList<State>();
        Object object = this.stateSpaceLock;
        synchronized (object) {
            this.change = true;
            if (this.getStateSpace().removeState(state)) {
                removed.addAll(StateSpaceSearch.removeUnreachableStates(this.getStateSpace()));
                removed.add(state);
            }
            this.getStateSpace().getOpenStates().removeAll(removed);
            this.getStateSpace().getInitialStates().removeAll(removed);
            HashSet<Transition> transitions = new HashSet<Transition>();
            for (State current : removed) {
                this.removeFromIndex(current);
                transitions.addAll((Collection<Transition>)current.getOutgoing());
                transitions.addAll((Collection<Transition>)current.getIncoming());
            }
            int number = this.getStateSpace().getTransitionCount() - transitions.size();
            this.getStateSpace().setTransitionCount(number);
            this.change = false;
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void resetStateSpace() {
        Object object = this.stateSpaceLock;
        synchronized (object) {
            this.change = true;
            this.getStateSpace().getStates().clear();
            this.getStateSpace().getOpenStates().clear();
            this.getStateSpace().getStates().addAll(this.getStateSpace().getInitialStates());
            for (State initial : this.getStateSpace().getStates()) {
                initial.getOutgoing().clear();
                initial.getIncoming().clear();
            }
            this.getStateSpace().setTransitionCount(0);
            this.change = false;
        }
        try {
            this.reload((IProgressMonitor)new NullProgressMonitor());
            this.tainted = false;
        }
        catch (StateSpaceException e) {
            e.printStackTrace();
            this.tainted = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Transition createTransition(State source, State target, Rule rule, int match, int[] paramIDs) {
        Transition transition = StateSpaceFactory.eINSTANCE.createTransition();
        transition.setRule(rule);
        transition.setMatch(match);
        transition.setParameterIDs(paramIDs);
        transition.setParameterCount(paramIDs.length);
        Object object = this.stateSpaceLock;
        synchronized (object) {
            this.change = true;
            transition.setSource(source);
            transition.setTarget(target);
            this.getStateSpace().setTransitionCount(this.getStateSpace().getTransitionCount() + 1);
            this.change = false;
        }
        return transition;
    }

    protected static Transition findTransition(State source, State target, Rule rule, int[] paramIDs) {
        for (Transition transition : source.getOutgoing()) {
            if (rule != transition.getRule() || target != transition.getTarget() || !Arrays.equals(paramIDs, transition.getParameterIDs())) continue;
            return transition;
        }
        return null;
    }

    protected boolean isTainted() {
        return this.tainted;
    }

    protected void markTainted() {
        this.tainted = true;
    }
}

