/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.resource;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.resource.StateSpaceDeserializer;
import org.eclipse.emf.henshin.statespace.resource.StateSpaceSerializer;

public class StateSpaceResource
extends ResourceImpl {
    public static final String FILE_EXTENSION = "statespace";
    public static final int BUFFER_CAPACITY = 524288;
    private static final String STATESPACE_BIN = "statespace.bin";
    private static final String PROPERTIES_TXT = "properties.txt";
    private String currentEntry = null;

    public StateSpaceResource() {
    }

    public StateSpaceResource(URI uri) {
        super(uri);
    }

    public StateSpace getStateSpace() {
        for (EObject item : this.getContents()) {
            if (!(item instanceof StateSpace)) continue;
            return (StateSpace)item;
        }
        return null;
    }

    protected void doSave(OutputStream out, Map<?, ?> options) throws IOException {
        ZipOutputStream zip = (ZipOutputStream)out;
        BufferedOutputStream buffered = new BufferedOutputStream(zip, 524288);
        StateSpaceSerializer serializer = new StateSpaceSerializer();
        serializer.write(this.getStateSpace(), buffered);
        buffered.flush();
        zip.putNextEntry(new ZipEntry(PROPERTIES_TXT));
        Properties properties = new Properties();
        for (Map.Entry entry : this.getStateSpace().getProperties().entrySet()) {
            properties.put(entry.getKey(), entry.getValue());
        }
        properties.store(zip, "State space properties");
    }

    protected void doLoad(InputStream in, Map<?, ?> options) throws IOException {
        ZipInputStream zip = (ZipInputStream)in;
        BufferedInputStream buffered = new BufferedInputStream(zip, 524288);
        Properties properties = new Properties();
        ZipEntry entry = null;
        do {
            if (STATESPACE_BIN.equals(this.currentEntry)) {
                StateSpaceDeserializer deserializer = new StateSpaceDeserializer();
                deserializer.read(this, buffered);
            }
            if (PROPERTIES_TXT.equals(this.currentEntry)) {
                properties.load(buffered);
            }
            entry = zip.getNextEntry();
            while (entry != null && !this.isContentZipEntry(entry)) {
                entry = zip.getNextEntry();
            }
        } while (entry != null);
        if (this.getStateSpace() == null) {
            throw new IOException("Zip entry 'statespace.bin' not found");
        }
        for (String key : properties.stringPropertyNames()) {
            this.getStateSpace().getProperties().put((Object)key, (Object)properties.getProperty(key));
        }
    }

    protected boolean useZip() {
        return true;
    }

    protected ZipEntry newContentZipEntry() {
        return new ZipEntry(STATESPACE_BIN);
    }

    protected boolean isContentZipEntry(ZipEntry entry) {
        this.currentEntry = STATESPACE_BIN.equals(entry.getName()) ? STATESPACE_BIN : (PROPERTIES_TXT.equals(entry.getName()) ? PROPERTIES_TXT : null);
        return this.currentEntry != null;
    }
}

